/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.model;

import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.net.websocket.WebSocketConnection;

public class WSMessage {
    private MessageType messageType;
    private WeakReference<WebSocketConnection> connection;
    private IoBuffer payload;
    private String path;
    private long timeStamp = System.currentTimeMillis();

    public WSMessage() {
        this.payload = IoBuffer.allocate((int)0);
    }

    public WSMessage(String message) throws UnsupportedEncodingException {
        this.payload = IoBuffer.wrap((byte[])message.getBytes("UTF8"));
    }

    public String getMessageAsString() throws UnsupportedEncodingException {
        return new String(this.payload.array(), "UTF8").trim();
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public WebSocketConnection getConnection() {
        return (WebSocketConnection)this.connection.get();
    }

    public void setConnection(WebSocketConnection connection) {
        this.connection = new WeakReference<WebSocketConnection>(connection);
        this.setPath(connection.getPath());
    }

    public IoBuffer getPayload() {
        return this.payload.flip();
    }

    public void setPayload(IoBuffer payload) {
        this.payload = payload;
    }

    public void addPayload(IoBuffer additionalPayload) {
        if (this.payload == null) {
            this.payload = IoBuffer.allocate((int)additionalPayload.remaining());
            this.payload.setAutoExpand(true);
        }
        this.payload.put(additionalPayload);
    }

    public void addPayload(byte[] additionalPayload) {
        if (this.payload == null) {
            this.payload = IoBuffer.allocate((int)additionalPayload.length);
            this.payload.setAutoExpand(true);
        }
        this.payload.put(additionalPayload);
    }

    public boolean isPayloadComplete() {
        return !this.payload.hasRemaining();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return "WSMessage [messageType=" + this.messageType + ", timeStamp=" + this.timeStamp + ", path=" + this.path + ", payload=" + this.payload + "]";
    }

    public static enum MessageType {
        BINARY,
        TEXT;

    }
}

