/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.proxy;

import java.nio.channels.WritableByteChannel;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.red5.server.net.proxy.ProxyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDumpFilter
extends IoFilterAdapter {
    protected static Logger log = LoggerFactory.getLogger(ProxyFilter.class);
    protected WritableByteChannel raw;
    protected WritableByteChannel headers;

    public NetworkDumpFilter(WritableByteChannel headers, WritableByteChannel raw) {
        this.raw = raw;
        this.headers = headers;
    }

    public void messageReceived(IoFilter.NextFilter next, IoSession session, Object message) throws Exception {
        if (message instanceof IoBuffer) {
            IoBuffer out = (IoBuffer)message;
            if (this.headers != null) {
                IoBuffer header = IoBuffer.allocate((int)12);
                header.putLong(System.currentTimeMillis());
                header.putInt(out.limit() - out.position());
                header.flip();
                this.headers.write(header.buf());
            }
            if (this.raw != null) {
                this.raw.write(out.asReadOnlyBuffer().buf());
            }
        }
        next.messageReceived(session, message);
    }

    public void sessionClosed(IoFilter.NextFilter next, IoSession session) throws Exception {
        if (this.headers.isOpen()) {
            this.headers.close();
        }
        if (this.raw.isOpen()) {
            this.raw.close();
        }
        next.sessionClosed(session);
    }
}

