/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.security.jaas;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.security.jaas.SimplePrincipal;
import org.slf4j.Logger;

public class SimpleLoginModule
implements LoginModule {
    private static Logger log = Red5LoggerFactory.getLogger(SimpleLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, SimplePrincipal> principals = new HashMap<String, SimplePrincipal>();
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private ThreadLocal<SimplePrincipal> userPrincipal = new ThreadLocal();

    public SimpleLoginModule() {
        SimplePrincipal prince = new SimplePrincipal("red5", "password");
        this.principals.put("red5", prince);
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        log.debug("initialize - subject: {}", (Object)subject);
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        char[] passwd;
        String userName;
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available, required to hold authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("User name: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
            userName = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            passwd = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, passwd, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to hold authentication information");
        }
        String password = new String(passwd);
        log.debug("User name: {} password: {}", (Object)userName, (Object)password);
        SimplePrincipal prince = new SimplePrincipal(userName, password);
        SimplePrincipal tmp = this.principals.get(userName);
        if (tmp != null && tmp.equals(prince) && tmp.getPassword().equals(prince.getPassword())) {
            this.userPrincipal.set(prince);
            log.debug("Authentication succeeded");
            this.succeeded = true;
            return true;
        }
        this.succeeded = false;
        throw new FailedLoginException("Authentication failed");
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        SimplePrincipal prince = this.userPrincipal.get();
        if (!this.subject.getPrincipals().contains(prince)) {
            this.subject.getPrincipals().add(prince);
        }
        log.debug("Added principal to the subject");
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.userPrincipal.remove();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        SimplePrincipal prince = this.userPrincipal.get();
        this.subject.getPrincipals().remove(prince);
        this.userPrincipal.remove();
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        return true;
    }

    public void add(String userName, String password) {
        SimplePrincipal prince = new SimplePrincipal(userName, password);
        this.principals.put(userName, prince);
    }
}

