/*
 * Decompiled with CFR 0.152.
 */
package org.red5.logging;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyLogInterceptor {
    protected static Logger log = LoggerFactory.getLogger(DerbyLogInterceptor.class);
    private static ThreadLocal<StringBuilder> local = new ThreadLocal();

    public static OutputStream handleDerbyLogFile() {
        return new OutputStream(){

            @Override
            public void write(byte[] b) throws IOException {
                log.info("Derby log: {}", (Object)new String(b));
            }

            @Override
            public void write(int i) throws IOException {
                StringBuilder sb = local.get();
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if (i == 10) {
                    log.info("Derby log: {}", (Object)sb.toString());
                    sb.delete(0, sb.length() - 1);
                } else {
                    log.trace("Derby log: {}", (Object)i);
                    sb.append(new String(DerbyLogInterceptor.intToDWord(i)));
                }
                local.set(sb);
            }
        };
    }

    private static byte[] intToDWord(int i) {
        byte[] dword = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return dword;
    }
}

