/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.lang3.StringUtils;
import org.red5.net.websocket.WebSocketScope;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.listener.IWebSocketDataListener;
import org.red5.net.websocket.server.DefaultServerEndpointConfigurator;
import org.red5.net.websocket.server.DefaultWsServerContainer;
import org.red5.server.Server;
import org.red5.server.adapter.MultiThreadedApplicationAdapter;
import org.red5.server.api.listeners.IScopeListener;
import org.red5.server.api.listeners.ScopeListenerAdapter;
import org.red5.server.api.plugin.IRed5Plugin;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.plugin.PluginRegistry;
import org.red5.server.plugin.Red5Plugin;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketPlugin
extends Red5Plugin {
    private static Logger log = LoggerFactory.getLogger(WebSocketPlugin.class);
    public static final String NAME = "WebSocketPlugin";
    private static ExecutorService executor = Executors.newCachedThreadPool();
    private static boolean sameOriginPolicy;
    private static boolean crossOriginPolicy;
    private static String[] allowedOrigins;
    private static ConcurrentMap<IScope, WebSocketScopeManager> managerMap;
    private static ConcurrentMap<String, DefaultWsServerContainer> containerMap;
    private ScopeListenerAdapter scopeListener;

    public WebSocketPlugin() {
        log.trace("WebSocketPlugin ctor");
    }

    public void doStart() throws Exception {
        super.doStart();
        log.trace("WebSocketPlugin start");
        this.scopeListener = new ScopeListenerAdapter(){

            public void notifyScopeCreated(IScope scope) {
                log.debug("Scope created: {}", (Object)scope);
                if (scope.getType() == ScopeType.APPLICATION) {
                    WebSocketPlugin.this.configureApplicationScopeWebSocket(scope);
                } else if (scope.getType() == ScopeType.ROOM) {
                    WebSocketPlugin.this.configureRoomScopeWebSocket(scope);
                }
            }

            public void notifyScopeRemoved(IScope scope) {
                WebSocketScopeManager manager;
                log.trace("Scope removed: {}", (Object)scope);
                if (scope.getType() == ScopeType.APPLICATION && (manager = WebSocketPlugin.this.removeManager(scope)) != null) {
                    manager.stop();
                }
            }
        };
        log.info("Setting server scope listener");
        this.server.addListener((IScopeListener)this.scopeListener);
        this.server.getGlobalScopes().forEachRemaining(gscope -> {
            log.info("Got global scope: {}", (Object)gscope.getName());
            gscope.getBasicScopeNames(ScopeType.APPLICATION).forEach(appName -> {
                log.debug("Setting up websocket for {}", appName);
                IScope appScope = (IScope)gscope.getBasicScope(ScopeType.APPLICATION, appName);
                log.debug("Configuring application scope: {}", (Object)appScope);
                this.configureApplicationScopeWebSocket(appScope);
            });
        });
    }

    public void doStop() throws Exception {
        log.trace("WebSocketPlugin stop");
        PluginRegistry.unregister((IRed5Plugin)this);
        managerMap.entrySet().forEach(entry -> ((WebSocketScopeManager)entry.getValue()).stop());
        managerMap.clear();
        executor.shutdownNow();
        super.doStop();
    }

    private void configureApplicationScopeWebSocket(IScope scope) {
        if (scope.hasAttribute("ws.scope")) {
            log.debug("Application scope already configured: {}", (Object)scope);
        } else {
            log.debug("Configuring application scope: {}", (Object)scope);
            WebSocketScopeManager manager = (WebSocketScopeManager)managerMap.get(scope);
            if (manager == null) {
                MultiThreadedApplicationAdapter app = (MultiThreadedApplicationAdapter)scope.getHandler();
                log.info("Creating WebSocketScopeManager for {}", (Object)app);
                this.setApplication(app);
                manager = (WebSocketScopeManager)managerMap.get(scope);
            }
            WebSocketScope wsScope = new WebSocketScope(scope);
            wsScope.register();
        }
    }

    private void configureRoomScopeWebSocket(IScope scope) {
        if (scope.hasAttribute("ws.scope")) {
            log.debug("Room scope already configured: {}", (Object)scope);
        } else {
            log.debug("Configuring room scope: {}", (Object)scope);
            IScope appScope = ScopeUtils.findApplication((IScope)scope);
            String path = scope.getContextPath();
            log.debug("Room path: {}", (Object)path);
            WebSocketScopeManager manager = (WebSocketScopeManager)managerMap.get(appScope);
            if (manager != null) {
                WebSocketScope wsScope = manager.getScope(path);
                if (wsScope == null) {
                    manager.makeScope(scope);
                    wsScope = manager.getScope(path);
                }
                wsScope.setScope(scope);
                WebSocketScope wsScopeParent = manager.getScope(appScope.getContextPath());
                for (IWebSocketDataListener listener : wsScopeParent.getListeners()) {
                    log.debug("Adding listener: {}", (Object)listener);
                    wsScope.addListener(listener);
                }
            }
        }
    }

    public static Future<?> submit(Runnable task) {
        return executor.submit(task);
    }

    public String getName() {
        return NAME;
    }

    public Server getServer() {
        return super.getServer();
    }

    public IScope getApplicationScope(String path) {
        String applicationScopeName = path.split("\\/")[1];
        log.debug("Looking for application scope: {}", (Object)applicationScopeName);
        return managerMap.keySet().stream().filter(scope -> ScopeUtils.isApp((IBasicScope)scope) && scope.getName().equals(applicationScopeName)).findFirst().get();
    }

    public WebSocketScopeManager getManager(IScope scope) {
        return (WebSocketScopeManager)managerMap.get(scope);
    }

    public WebSocketScopeManager getManager(String path) {
        log.debug("getManager: {}", (Object)path);
        Object[] parts = path.split("\\/");
        if (log.isTraceEnabled()) {
            log.trace("Path parts: {}", (Object)Arrays.toString(parts));
        }
        if (parts.length > 1) {
            Object name;
            Object object = !"default".equals(parts[1]) ? parts[1] : (name = parts.length >= 3 ? parts[2] : parts[1]);
            if (log.isTraceEnabled()) {
                log.trace("Managers: {}", managerMap.entrySet());
            }
            for (Map.Entry entry : managerMap.entrySet()) {
                IScope appScope = (IScope)entry.getKey();
                if (appScope.getName().equals(name)) {
                    log.debug("Application scope name matches path: {}", name);
                    return (WebSocketScopeManager)entry.getValue();
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("Application scope name: {} didnt match path: {}", (Object)appScope.getName(), name);
            }
        }
        return null;
    }

    public WebSocketScopeManager removeManager(IScope scope) {
        return (WebSocketScopeManager)managerMap.remove(scope);
    }

    public DefaultWsServerContainer getWsServerContainer(String path) {
        log.debug("getWsServerContainer: {}", (Object)path);
        return (DefaultWsServerContainer)((Object)containerMap.get(path));
    }

    public void setApplication(MultiThreadedApplicationAdapter application) {
        log.info("WebSocketPlugin application: {}", (Object)application);
        IScope appScope = application.getScope();
        managerMap.putIfAbsent(appScope, new WebSocketScopeManager());
        ((WebSocketScopeManager)managerMap.get(appScope)).setApplication(appScope);
        super.setApplication(application);
    }

    public static boolean isSameOriginPolicy() {
        return sameOriginPolicy;
    }

    public void setSameOriginPolicy(boolean sameOriginPolicy) {
        WebSocketPlugin.sameOriginPolicy = sameOriginPolicy;
    }

    public static boolean isCrossOriginPolicy() {
        return crossOriginPolicy;
    }

    public void setCrossOriginPolicy(boolean crossOriginPolicy) {
        WebSocketPlugin.crossOriginPolicy = crossOriginPolicy;
    }

    public static String[] getAllowedOrigins() {
        return allowedOrigins;
    }

    public void setAllowedOrigins(String[] allowedOrigins) {
        WebSocketPlugin.allowedOrigins = allowedOrigins;
        log.info("allowedOrigins: {}", (Object)Arrays.toString(WebSocketPlugin.allowedOrigins));
    }

    public static ServerEndpointConfig.Configurator getWsConfiguratorInstance() {
        DefaultServerEndpointConfigurator configurator = new DefaultServerEndpointConfigurator();
        return configurator;
    }

    public static ServerContainer getWsServerContainerInstance(ServletContext servletContext) {
        DefaultWsServerContainer container;
        String path = servletContext.getContextPath();
        if (path.length() == 0) {
            path = "/";
        }
        log.info("getWsServerContainerInstance: {}", (Object)path);
        if (containerMap.containsKey(path)) {
            container = (DefaultWsServerContainer)((Object)containerMap.get(path));
        } else {
            Optional<String> opt;
            container = new DefaultWsServerContainer(servletContext);
            if (log.isDebugEnabled()) {
                log.debug("Attributes: {} params: {}", Collections.list(servletContext.getAttributeNames()), Collections.list(servletContext.getInitParameterNames()));
            }
            ServerEndpointConfig.Configurator configurator = WebSocketPlugin.getWsConfiguratorInstance();
            log.debug("Checking for subprotocols");
            ArrayList<String> subProtocols = new ArrayList<String>();
            Optional<String> subProtocolsAttr = Optional.ofNullable(servletContext.getInitParameter("subProtocols"));
            if (subProtocolsAttr.isPresent()) {
                String attr = subProtocolsAttr.get();
                log.debug("Subprotocols: {}", (Object)attr);
                if (StringUtils.isNotBlank((CharSequence)attr)) {
                    if (attr.contains(",")) {
                        Stream.of(attr.split(",")).forEach(entry -> subProtocols.add((String)entry));
                    } else {
                        subProtocols.add(attr);
                    }
                }
            } else {
                subProtocols.add("*");
            }
            log.debug("Checking for CORS");
            Optional<Object> crossOpt = Optional.ofNullable(servletContext.getAttribute("crossOriginPolicy"));
            if (crossOpt.isPresent() && Boolean.valueOf((String)crossOpt.get()).booleanValue() && (opt = Optional.ofNullable((String)servletContext.getAttribute("allowedOrigins"))).isPresent()) {
                ((DefaultServerEndpointConfigurator)configurator).setAllowedOrigins(opt.get().split(","));
            }
            log.debug("Checking for endpoint override");
            String wsEndpointClass = Optional.ofNullable((String)servletContext.getAttribute("wsEndpointClass")).orElse("org.red5.net.websocket.server.DefaultWebSocketEndpoint");
            try {
                Class<?> endpointClass = Class.forName(wsEndpointClass);
                log.debug("startWebSocket - endpointPath: {} endpointClass: {}", (Object)path, (Object)wsEndpointClass);
                ServerEndpointConfig serverEndpointConfig = ServerEndpointConfig.Builder.create(endpointClass, (String)path).configurator(configurator).subprotocols(subProtocols).build();
                container.addEndpoint(serverEndpointConfig);
            }
            catch (Throwable t) {
                log.warn("WebSocket endpoint setup exception", t);
            }
            containerMap.put(path, container);
            servletContext.addListener((EventListener)new HttpSessionListener(){

                public void sessionCreated(HttpSessionEvent se) {
                    log.debug("sessionCreated: {}", (Object)se.getSession().getId());
                    ServletContext sc = se.getSession().getServletContext();
                    if (sc.getAttribute("javax.websocket.server.ServerContainer") == null) {
                        DefaultWsServerContainer serverContainer = (DefaultWsServerContainer)WebSocketPlugin.getWsServerContainerInstance(sc);
                        sc.setAttribute("javax.websocket.server.ServerContainer", (Object)serverContainer);
                    }
                }

                public void sessionDestroyed(HttpSessionEvent se) {
                    log.debug("sessionDestroyed: {}", (Object)se);
                    container.closeAuthenticatedSession(se.getSession().getId());
                }
            });
        }
        servletContext.setAttribute("javax.websocket.server.ServerContainer", (Object)container);
        return container;
    }

    static {
        allowedOrigins = new String[]{"*"};
        managerMap = new ConcurrentHashMap<IScope, WebSocketScopeManager>();
        containerMap = new ConcurrentHashMap<String, DefaultWsServerContainer>();
    }
}

