/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.WsWebSocketContainer;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;
import org.apache.tomcat.websocket.server.UriTemplate;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.red5.net.websocket.server.UpgradeUtil;
import org.red5.net.websocket.server.WsMappingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWsServerContainer
extends WsWebSocketContainer
implements ServerContainer {
    private final Logger log = LoggerFactory.getLogger(DefaultWsServerContainer.class);
    private static final StringManager sm = StringManager.getManager(WsServerContainer.class);
    private static final CloseReason AUTHENTICATED_HTTP_SESSION_CLOSED = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Authenticated HTTP session that has ended");
    private final ServletContext servletContext;
    private final ConcurrentMap<String, ServerEndpointConfig> configExactMatchMap = new ConcurrentHashMap<String, ServerEndpointConfig>();
    private final ConcurrentMap<Integer, SortedSet<TemplatePathMatch>> configTemplateMatchMap = new ConcurrentHashMap<Integer, SortedSet<TemplatePathMatch>>();
    private volatile boolean enforceNoAddAfterHandshake = Constants.STRICT_SPEC_COMPLIANCE;
    private volatile boolean addAllowed = true;
    private final ConcurrentMap<String, Set<WsSession>> authenticatedSessions = new ConcurrentHashMap<String, Set<WsSession>>();
    private volatile boolean endpointsRegistered;
    private volatile CopyOnWriteArraySet<String> registeredEndpointPaths = new CopyOnWriteArraySet();

    public DefaultWsServerContainer(ServletContext servletContext) {
        this.log.debug("ctor - context: {}", (Object)servletContext);
        this.servletContext = servletContext;
        this.setInstanceManager((InstanceManager)servletContext.getAttribute(InstanceManager.class.getName()));
        String value = servletContext.getInitParameter("org.apache.tomcat.websocket.binaryBufferSize");
        if (value != null) {
            this.setDefaultMaxBinaryMessageBufferSize(Integer.parseInt(value));
        }
        if ((value = servletContext.getInitParameter("org.apache.tomcat.websocket.textBufferSize")) != null) {
            this.setDefaultMaxTextMessageBufferSize(Integer.parseInt(value));
        }
        if ((value = servletContext.getInitParameter("org.apache.tomcat.websocket.noAddAfterHandshake")) != null) {
            this.setEnforceNoAddAfterHandshake(Boolean.parseBoolean(value));
        }
    }

    public void addEndpoint(ServerEndpointConfig sec) throws DeploymentException {
        UriTemplate uriTemplate;
        this.log.debug("addEndpoint: {}", (Object)sec);
        if (this.enforceNoAddAfterHandshake && !this.addAllowed) {
            throw new DeploymentException(sm.getString("serverContainer.addNotAllowed"));
        }
        if (this.servletContext == null) {
            throw new DeploymentException(sm.getString("serverContainer.servletContextMissing"));
        }
        String path = sec.getPath();
        PojoMethodMapping methodMapping = new PojoMethodMapping(sec.getEndpointClass(), sec.getDecoders(), path, null);
        if (methodMapping.getOnClose() != null || methodMapping.getOnOpen() != null || methodMapping.getOnError() != null || methodMapping.hasMessageHandlers()) {
            sec.getUserProperties().put("org.apache.tomcat.websocket.pojo.PojoEndpoint.methodMapping", methodMapping);
        }
        if ((uriTemplate = new UriTemplate(path)).hasParameters()) {
            Integer key = uriTemplate.getSegmentCount();
            SortedSet<TemplatePathMatch> templateMatches = (TreeSet<TemplatePathMatch>)this.configTemplateMatchMap.get(key);
            if (templateMatches == null) {
                templateMatches = new TreeSet<TemplatePathMatch>(TemplatePathMatchComparator.getInstance());
                this.configTemplateMatchMap.putIfAbsent(key, templateMatches);
                templateMatches = (SortedSet)this.configTemplateMatchMap.get(key);
            }
            if (!templateMatches.add(new TemplatePathMatch(sec, uriTemplate))) {
                throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", new Object[]{path, sec.getEndpointClass(), sec.getEndpointClass()}));
            }
        } else {
            ServerEndpointConfig old = this.configExactMatchMap.put(path, sec);
            if (old != null) {
                throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", new Object[]{path, old.getEndpointClass(), sec.getEndpointClass()}));
            }
        }
        this.registeredEndpointPaths.add(path);
        this.endpointsRegistered = true;
    }

    public void addEndpoint(Class<?> pojo) throws DeploymentException {
        this.log.debug("addEndpoint: {}", pojo);
        ServerEndpoint annotation = pojo.getAnnotation(ServerEndpoint.class);
        if (annotation == null) {
            throw new DeploymentException(sm.getString("serverContainer.missingAnnotation", new Object[]{pojo.getName()}));
        }
        String path = annotation.value();
        DefaultWsServerContainer.validateEncoders(annotation.encoders());
        Class configuratorClazz = annotation.configurator();
        ServerEndpointConfig.Configurator configurator = null;
        if (!configuratorClazz.equals(ServerEndpointConfig.Configurator.class)) {
            try {
                configurator = (ServerEndpointConfig.Configurator)annotation.configurator().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new DeploymentException(sm.getString("serverContainer.configuratorFail", new Object[]{annotation.configurator().getName(), pojo.getClass().getName()}), (Throwable)e);
            }
        }
        ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(pojo, (String)path).decoders(Arrays.asList(annotation.decoders())).encoders(Arrays.asList(annotation.encoders())).subprotocols(Arrays.asList(annotation.subprotocols())).configurator(configurator).build();
        this.addEndpoint(sec);
    }

    boolean areEndpointsRegistered() {
        return this.endpointsRegistered;
    }

    public void doUpgrade(HttpServletRequest request, HttpServletResponse response, ServerEndpointConfig sec, Map<String, String> pathParams) throws ServletException, IOException {
        this.log.debug("doUpgrade");
        UpgradeUtil.doUpgrade(this, request, response, sec, pathParams);
    }

    public WsMappingResult findMapping(String path) {
        this.log.debug("findMapping: {}", (Object)path);
        if (this.addAllowed) {
            this.addAllowed = false;
        }
        ServerEndpointConfig sec = (ServerEndpointConfig)this.configExactMatchMap.get(path);
        this.log.debug("configExactMatchMap: {}", this.configExactMatchMap);
        if (sec != null) {
            return new WsMappingResult(sec, Collections.emptyMap());
        }
        UriTemplate pathUriTemplate = null;
        try {
            pathUriTemplate = new UriTemplate(path);
        }
        catch (DeploymentException e) {
            return null;
        }
        Integer key = pathUriTemplate.getSegmentCount();
        SortedSet templateMatches = (SortedSet)this.configTemplateMatchMap.get(key);
        this.log.debug("configTemplateMatchMap - key: {} {}", (Object)key, this.configTemplateMatchMap);
        if (templateMatches == null) {
            return null;
        }
        Map pathParams = null;
        for (TemplatePathMatch templateMatch : templateMatches) {
            pathParams = templateMatch.getUriTemplate().match(pathUriTemplate);
            if (pathParams == null) continue;
            sec = templateMatch.getConfig();
            break;
        }
        if (sec == null) {
            return null;
        }
        return new WsMappingResult(sec, pathParams);
    }

    public boolean isEnforceNoAddAfterHandshake() {
        return this.enforceNoAddAfterHandshake;
    }

    public void setEnforceNoAddAfterHandshake(boolean enforceNoAddAfterHandshake) {
        this.enforceNoAddAfterHandshake = enforceNoAddAfterHandshake;
    }

    public Set<String> getRegisteredEndpointPaths() {
        return Collections.unmodifiableSet(this.registeredEndpointPaths);
    }

    protected void registerSession(Object endpoint, WsSession wsSession) {
        super.registerSession(endpoint, wsSession);
        if (wsSession.isOpen() && wsSession.getUserPrincipal() != null && wsSession.getHttpSessionId() != null) {
            this.registerAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
            this.log.debug("registerSession - registerAuthenticatedSession: {}", (Object)wsSession.getId());
        }
        this.log.debug("registerSession: {} endpoint: {}", (Object)wsSession.getId(), endpoint);
    }

    protected void unregisterSession(Object endpoint, WsSession wsSession) {
        if (wsSession.getUserPrincipal() != null && wsSession.getHttpSessionId() != null) {
            this.unregisterAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
            this.log.debug("unregisterSession - unregisterAuthenticatedSession: {}", (Object)wsSession.getId());
        }
        super.unregisterSession(endpoint, wsSession);
        this.log.debug("unregisterSession: {} endpoint: {}", (Object)wsSession.getId(), endpoint);
    }

    private void registerAuthenticatedSession(WsSession wsSession, String httpSessionId) {
        Set wsSessions = (Set)this.authenticatedSessions.get(httpSessionId);
        if (wsSessions == null) {
            wsSessions = Collections.newSetFromMap(new ConcurrentHashMap());
            this.authenticatedSessions.putIfAbsent(httpSessionId, wsSessions);
            wsSessions = (Set)this.authenticatedSessions.get(httpSessionId);
        }
        wsSessions.add(wsSession);
    }

    private void unregisterAuthenticatedSession(WsSession wsSession, String httpSessionId) {
        Set wsSessions = (Set)this.authenticatedSessions.get(httpSessionId);
        if (wsSessions != null) {
            wsSessions.remove(wsSession);
        }
    }

    public void closeAuthenticatedSession(String httpSessionId) {
        Set wsSessions = (Set)this.authenticatedSessions.remove(httpSessionId);
        if (wsSessions != null && !wsSessions.isEmpty()) {
            for (WsSession wsSession : wsSessions) {
                try {
                    wsSession.close(AUTHENTICATED_HTTP_SESSION_CLOSED);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void validateEncoders(Class<? extends Encoder>[] encoders) throws DeploymentException {
        for (Class<? extends Encoder> encoder : encoders) {
            try {
                encoder.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new DeploymentException(sm.getString("serverContainer.encoderFail", new Object[]{encoder.getName()}), (Throwable)e);
            }
        }
    }

    private static class TemplatePathMatchComparator
    implements Comparator<TemplatePathMatch> {
        private static final TemplatePathMatchComparator INSTANCE = new TemplatePathMatchComparator();

        public static TemplatePathMatchComparator getInstance() {
            return INSTANCE;
        }

        private TemplatePathMatchComparator() {
        }

        @Override
        public int compare(TemplatePathMatch tpm1, TemplatePathMatch tpm2) {
            return tpm1.getUriTemplate().getNormalizedPath().compareTo(tpm2.getUriTemplate().getNormalizedPath());
        }
    }

    private static class TemplatePathMatch {
        private final ServerEndpointConfig config;
        private final UriTemplate uriTemplate;

        public TemplatePathMatch(ServerEndpointConfig config, UriTemplate uriTemplate) {
            this.config = config;
            this.uriTemplate = uriTemplate;
        }

        public ServerEndpointConfig getConfig() {
            return this.config;
        }

        public UriTemplate getUriTemplate() {
            return this.uriTemplate;
        }
    }
}

