/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.jaspic.AuthConfigFactoryImpl;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.realm.JAASRealm;
import org.apache.catalina.realm.NullRealm;
import org.apache.catalina.realm.RealmBase;
import org.red5.logging.Red5LoggerFactory;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.server.ContextLoader;
import org.red5.server.LoaderBase;
import org.red5.server.Server;
import org.red5.server.api.IApplicationContext;
import org.red5.server.api.IApplicationLoader;
import org.red5.server.api.plugin.IRed5Plugin;
import org.red5.server.jmx.mxbeans.ContextLoaderMXBean;
import org.red5.server.jmx.mxbeans.LoaderMXBean;
import org.red5.server.plugin.PluginRegistry;
import org.red5.server.security.IRed5Realm;
import org.red5.server.tomcat.EmbeddedTomcat;
import org.red5.server.tomcat.TomcatApplicationContext;
import org.red5.server.tomcat.TomcatApplicationLoader;
import org.red5.server.tomcat.TomcatConnector;
import org.red5.server.util.FileUtil;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

@ManagedResource(objectName="org.red5.server:type=TomcatLoader", description="TomcatLoader")
public class TomcatLoader
extends LoaderBase
implements InitializingBean,
DisposableBean,
LoaderMXBean {
    private static final String CONFIG_LOCATION_PARAM = "contextConfigLocation";
    private static final String LOCATOR_FACTORY_KEY_PARAM = "locatorFactorySelector";
    private static final String CONTEXT_CLASS_PARAM = "contextClass";
    private static Logger log;
    public static final String defaultSpringConfigLocation = "/WEB-INF/red5-*.xml";
    public static final String defaultParentContextKey = "default.context";
    public String serviceEngineName = "red5Engine";
    protected Host host;
    protected static EmbeddedTomcat embedded;
    protected static Engine engine;
    protected Realm realm;
    protected List<Host> hosts;
    protected List<TomcatConnector> connectors;
    protected List<Valve> valves = new ArrayList<Valve>();
    protected boolean websocketEnabled = true;

    public void afterPropertiesSet() throws Exception {
        if (this.websocketEnabled && PluginRegistry.getPlugin((String)"WebSocketPlugin") == null) {
            ApplicationContext common = (ApplicationContext)applicationContext.getBean("red5.common");
            Server server = (Server)common.getBean("red5.server");
            WebSocketPlugin plugin = new WebSocketPlugin();
            plugin.setApplicationContext(applicationContext);
            plugin.setServer(server);
            plugin.doStart();
            PluginRegistry.register((IRed5Plugin)plugin);
        }
        this.start();
    }

    public Context addContext(String path, String docBase) throws ServletException {
        return this.addContext(path, docBase, this.host);
    }

    public Context addContext(String contextPath, String docBase, Host host) throws ServletException {
        log.debug("Add context - path: {} docbase: {}", (Object)contextPath, (Object)docBase);
        Context ctx = embedded.addWebapp(host, contextPath, docBase);
        if (this.websocketEnabled) {
            ctx.setContainerSciFilter("WsSci");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ctx.setParentClassLoader(classLoader);
        Loader ldr = ctx.getLoader();
        log.trace("Context loader (null if the context has not been started): {}", (Object)ldr);
        if (ldr == null) {
            ctx.setLoader((Loader)new WebappLoader());
        }
        log.trace("Context loader (check): {} Context classloader: {}", (Object)ctx.getLoader(), (Object)ctx.getLoader().getClassLoader());
        LoaderBase.setRed5ApplicationContext((String)(this.getHostId() + contextPath), (IApplicationContext)new TomcatApplicationContext(ctx));
        return ctx;
    }

    public void removeContext(String path) {
        IApplicationContext ctx;
        Container[] children;
        for (Container c : children = this.host.findChildren()) {
            if (!(c instanceof StandardContext) || !c.getName().equals(path)) continue;
            try {
                ((StandardContext)c).stop();
                this.host.removeChild(c);
                break;
            }
            catch (Exception e) {
                log.error("Could not remove context: {}", (Object)c.getName(), (Object)e);
            }
        }
        if ((ctx = LoaderBase.removeRed5ApplicationContext((String)path)) != null) {
            ctx.stop();
        } else {
            log.warn("Context could not be stopped, it was null for path: {}", (Object)path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void start() throws ServletException {
        log.info("Loading Tomcat");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        String serverRoot = System.getProperty("red5.root");
        log.info("Server root: {}", (Object)serverRoot);
        String confRoot = System.getProperty("red5.config_root");
        log.info("Config root: {}", (Object)confRoot);
        Boolean useNaming = Boolean.valueOf(System.getProperty("catalina.useNaming"));
        if (embedded == null) {
            embedded = new EmbeddedTomcat();
        }
        File serverRootF = new File(serverRoot);
        embedded.getServer().setCatalinaBase(serverRootF);
        embedded.getServer().setCatalinaHome(serverRootF);
        embedded.setHost(this.host);
        embedded.setSilent(false);
        engine = embedded.getEngine();
        engine.setName(this.serviceEngineName);
        engine.setDefaultHost(this.host.getName());
        if (this.webappFolder == null) {
            this.webappFolder = FileUtil.formatPath((String)serverRoot, (String)"/webapps");
        }
        System.setProperty("red5.webapp.root", this.webappFolder);
        log.info("Application root: {}", (Object)this.webappFolder);
        File appDirBase = new File(this.webappFolder);
        File[] dirs = appDirBase.listFiles(new DirectoryFilter());
        for (File file : dirs) {
            String dirName = "/" + file.getName();
            if (null != this.host.findChild(dirName)) continue;
            String webappContextDir = FileUtil.formatPath((String)appDirBase.getAbsolutePath(), (String)dirName);
            log.debug("Webapp context directory (full path): {}", (Object)webappContextDir);
            Context ctx = null;
            if ("/root".equalsIgnoreCase(dirName)) {
                log.trace("Adding ROOT context");
                ctx = this.addContext("", webappContextDir);
            } else {
                log.trace("Adding context from directory scan: {}", (Object)dirName);
                ctx = this.addContext(dirName, webappContextDir);
            }
            log.trace("Context: {}", (Object)ctx);
            webappContextDir = null;
        }
        appDirBase = null;
        dirs = null;
        if (log.isDebugEnabled()) {
            for (File file : this.host.findChildren()) {
                log.debug("Context child name: {}", (Object)file.getName());
            }
        }
        if (this.realm != null) {
            embedded.getEngine().setRealm(this.realm);
        } else {
            this.realm = new NullRealm();
            embedded.getEngine().setRealm(this.realm);
        }
        if (Boolean.TRUE.equals(useNaming)) {
            embedded.enableNaming();
        }
        for (Valve valve : this.valves) {
            log.debug("Adding host valve: {}", (Object)valve);
            ((StandardHost)this.host).addValve(valve);
        }
        if (this.hosts != null && !this.hosts.isEmpty()) {
            Container[] currentContexts = this.host.findChildren();
            log.info("Adding {} additional hosts", (Object)this.hosts.size());
            for (Host h : this.hosts) {
                log.debug("Host - name: {} appBase: {} info: {}", new Object[]{h.getName(), h.getAppBase(), h});
                for (Container cont : currentContexts) {
                    Context c = (Context)cont;
                    this.addContext(c.getPath(), c.getDocBase(), h);
                }
                engine.addChild((Container)h);
            }
        }
        try {
            boolean added = false;
            for (TomcatConnector tomcatConnector : this.connectors) {
                Connector connector = tomcatConnector.getConnector();
                if (!added) {
                    embedded.setConnector(connector);
                    added = true;
                } else {
                    embedded.getService().addConnector(connector);
                }
                log.trace("Connector oName: {}", (Object)connector.getObjectName());
            }
        }
        catch (Exception ex) {
            log.warn("An exception occurred during network configuration", (Throwable)ex);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            void var11_30;
            log.info("Starting Tomcat servlet engine");
            embedded.start();
            LoaderBase.setApplicationLoader((IApplicationLoader)new TomcatApplicationLoader(embedded, this.host, applicationContext));
            Container[] valve = this.host.findChildren();
            int n = valve.length;
            boolean bl = false;
            while (var11_30 < n) {
                final Container cont = valve[var11_30];
                if (cont instanceof StandardContext) {
                    if (log.isDebugEnabled()) {
                        ContainerBase cb = (ContainerBase)cont;
                        log.debug("Oname - domain: {}", (Object)cb.getDomain());
                    }
                    final StandardContext ctx = (StandardContext)cont;
                    final ServletContext servletContext = ctx.getServletContext();
                    servletContext.setAttribute("red5.host.id", (Object)this.getHostId());
                    final String prefix = servletContext.getRealPath("/");
                    log.info("Context initialized: {} path: {}", (Object)servletContext.getContextPath(), (Object)prefix);
                    try {
                        ctx.resourcesStart();
                        log.debug("Context - privileged: {}, start time: {}, reloadable: {}", new Object[]{ctx.getPrivileged(), ctx.getStartTime(), ctx.getReloadable()});
                        Loader cldr = ctx.getLoader();
                        log.debug("Loader delegate: {} type: {}", (Object)cldr.getDelegate(), (Object)cldr.getClass().getName());
                        if (log.isTraceEnabled() && cldr instanceof WebappLoader) {
                            log.trace("WebappLoader class path: {}", (Object)((WebappLoader)cldr).getClasspath());
                        }
                        final ClassLoader webClassLoader = cldr.getClassLoader();
                        log.debug("Webapp classloader: {}", (Object)webClassLoader);
                        final String contextConfigLocation = servletContext.getInitParameter(CONFIG_LOCATION_PARAM) == null ? defaultSpringConfigLocation : servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
                        log.debug("Spring context config location: {}", (Object)contextConfigLocation);
                        final String parentContextKey = servletContext.getInitParameter(LOCATOR_FACTORY_KEY_PARAM) == null ? defaultParentContextKey : servletContext.getInitParameter(LOCATOR_FACTORY_KEY_PARAM);
                        log.debug("Spring parent context key: {}", (Object)parentContextKey);
                        Thread.currentThread().setContextClassLoader(webClassLoader);
                        Future<?> appStartTask = executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                Thread.currentThread().setContextClassLoader(webClassLoader);
                                Thread.currentThread().setName("Loader:" + servletContext.getContextPath());
                                ApplicationContext parentContext = null;
                                if (applicationContext.containsBean(parentContextKey)) {
                                    parentContext = (ApplicationContext)applicationContext.getBean(parentContextKey);
                                } else {
                                    log.warn("Parent context was not found: {}", (Object)parentContextKey);
                                }
                                String contextClass = servletContext.getInitParameter(TomcatLoader.CONTEXT_CLASS_PARAM) == null ? XmlWebApplicationContext.class.getName() : servletContext.getInitParameter(TomcatLoader.CONTEXT_CLASS_PARAM);
                                ConfigurableWebApplicationContext appctx = null;
                                try {
                                    Class<?> clazz = Class.forName(contextClass, true, webClassLoader);
                                    appctx = (ConfigurableWebApplicationContext)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                    servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)appctx);
                                    appctx.setConfigLocations(new String[]{contextConfigLocation});
                                    appctx.setServletContext(servletContext);
                                    if (parentContext != null) {
                                        appctx.setParent(parentContext);
                                    } else {
                                        appctx.setParent(applicationContext);
                                    }
                                    log.trace("Classloader prior to refresh: {}", (Object)appctx.getClassLoader());
                                    appctx.refresh();
                                    if (log.isDebugEnabled()) {
                                        log.debug("Red5 app is active: {} running: {}", (Object)appctx.isActive(), (Object)appctx.isRunning());
                                    }
                                    if (appctx.containsBean("realm")) {
                                        log.debug("Realm specified in context configuration");
                                        Realm contextRealm = (Realm)appctx.getBean("realm");
                                        if (contextRealm != null) {
                                            log.debug("Realm class: {}", (Object)contextRealm.getClass().getName());
                                            contextRealm.setContainer(cont);
                                            ctx.setRealm(contextRealm);
                                            if (contextRealm instanceof IRed5Realm) {
                                                ((IRed5Realm)contextRealm).setApplicationContext((ApplicationContext)appctx);
                                                ((IRed5Realm)contextRealm).setServletContext(servletContext);
                                            }
                                            if (contextRealm instanceof JAASRealm) {
                                                log.debug("Realm is JAAS type");
                                                System.setProperty("java.security.auth.login.config", prefix + "WEB-INF/jaas.config");
                                            }
                                            log.debug("Realm info: {} path: {}", (Object)contextRealm, (Object)((RealmBase)contextRealm).getRealmPath());
                                        }
                                    }
                                    appctx.start();
                                }
                                catch (Throwable e) {
                                    throw new RuntimeException("Failed to load webapplication context class", e);
                                }
                            }
                        });
                        log.debug("Context: {} done: {}", (Object)servletContext.getContextPath(), (Object)appStartTask.isDone());
                    }
                    catch (Throwable t) {
                        log.error("Error setting up context: {} due to: {}", (Object)servletContext.getContextPath(), (Object)t.getMessage());
                        t.printStackTrace();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                    }
                }
                ++var11_30;
            }
            if (applicationContext.containsBean("rtmpt.server")) {
                log.debug("Initializing RTMPT");
                applicationContext.getBean("rtmpt.server");
                log.debug("Finished initializing RTMPT");
            } else {
                log.info("Dedicated RTMPT server configuration was not specified");
            }
            if (applicationContext.containsBean("rtmps.server")) {
                log.debug("Initializing RTMPS");
                applicationContext.getBean("rtmps.server");
                log.debug("Finished initializing RTMPS");
            } else {
                log.debug("Dedicated RTMPS server configuration was not specified");
            }
        }
        catch (Exception e) {
            if (e instanceof BindException || e.getMessage().indexOf("BindException") != -1) {
                log.error("Error loading tomcat, unable to bind connector. You may not have permission to use the selected port", (Throwable)e);
            } else {
                log.error("Error loading tomcat", (Throwable)e);
            }
        }
        finally {
            executor.shutdown();
            this.registerJMX();
        }
        log.debug("Tomcat load completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startWebApplication(String applicationName) throws ServletException {
        log.info("Starting Tomcat - Web application");
        boolean result = false;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        log.debug("Webapp root: {}", (Object)this.webappFolder);
        if (this.webappFolder == null) {
            this.webappFolder = System.getProperty("red5.root") + "/webapps";
        }
        System.setProperty("red5.webapp.root", this.webappFolder);
        log.info("Application root: {}", (Object)this.webappFolder);
        String contextName = "/" + applicationName;
        Container ctx = null;
        File appDirBase = new File(this.webappFolder);
        ctx = this.host.findChild(contextName);
        if (ctx == null) {
            log.debug("Context did not exist in host");
            String webappContextDir = FileUtil.formatPath((String)appDirBase.getAbsolutePath(), (String)applicationName);
            log.debug("Webapp context directory (full path): {}", (Object)webappContextDir);
            ctx = this.addContext(contextName, webappContextDir);
        } else {
            log.debug("Context already exists in host");
        }
        final ServletContext servletContext = ((Context)ctx).getServletContext();
        log.debug("Context initialized: {}", (Object)servletContext.getContextPath());
        String prefix = servletContext.getRealPath("/");
        log.debug("Path: {}", (Object)prefix);
        try {
            Loader cldr = ((Context)ctx).getLoader();
            log.debug("Loader delegate: {} type: {}", (Object)cldr.getDelegate(), (Object)cldr.getClass().getName());
            if (cldr instanceof WebappLoader) {
                log.debug("WebappLoader class path: {}", (Object)((WebappLoader)cldr).getClasspath());
            }
            final ClassLoader webClassLoader = cldr.getClassLoader();
            log.debug("Webapp classloader: {}", (Object)webClassLoader);
            final String contextConfigLocation = servletContext.getInitParameter(CONFIG_LOCATION_PARAM) == null ? defaultSpringConfigLocation : servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
            log.debug("Spring context config location: {}", (Object)contextConfigLocation);
            String parentContextKey = servletContext.getInitParameter("parentContextKey") == null ? defaultParentContextKey : servletContext.getInitParameter("parentContextKey");
            log.debug("Spring parent context key: {}", (Object)parentContextKey);
            Thread.currentThread().setContextClassLoader(webClassLoader);
            Thread thread = new Thread("Launcher:" + servletContext.getContextPath()){

                @Override
                public void run() {
                    Thread.currentThread().setContextClassLoader(webClassLoader);
                    XmlWebApplicationContext appctx = new XmlWebApplicationContext();
                    appctx.setClassLoader(webClassLoader);
                    appctx.setConfigLocations(new String[]{contextConfigLocation});
                    ApplicationContext parentAppCtx = null;
                    if (applicationContext.containsBean(TomcatLoader.defaultParentContextKey)) {
                        parentAppCtx = (ApplicationContext)applicationContext.getBean(TomcatLoader.defaultParentContextKey);
                        appctx.setParent(parentAppCtx);
                    } else {
                        log.warn("{} bean was not found in context: {}", (Object)TomcatLoader.defaultParentContextKey, (Object)applicationContext.getDisplayName());
                        if (applicationContext.containsBean("context.loader")) {
                            ContextLoader contextLoader = (ContextLoader)applicationContext.getBean("context.loader");
                            parentAppCtx = contextLoader.getContext(TomcatLoader.defaultParentContextKey);
                            appctx.setParent(parentAppCtx);
                        } else {
                            log.debug("Context loader was not found, trying JMX");
                            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                            ContextLoaderMXBean proxy = null;
                            ObjectName oName = null;
                            try {
                                oName = new ObjectName("org.red5.server:name=contextLoader,type=ContextLoader");
                                if (mbs.isRegistered(oName)) {
                                    proxy = JMX.newMXBeanProxy(mbs, oName, ContextLoaderMXBean.class, true);
                                    log.debug("Context loader was found");
                                    proxy.setParentContext(TomcatLoader.defaultParentContextKey, appctx.getId());
                                } else {
                                    log.warn("Context loader was not found");
                                }
                            }
                            catch (Exception e) {
                                log.warn("Exception looking up ContextLoader", (Throwable)e);
                            }
                        }
                    }
                    if (log.isDebugEnabled() && appctx.getParent() != null) {
                        log.debug("Parent application context: {}", (Object)appctx.getParent().getDisplayName());
                    }
                    appctx.setServletContext(servletContext);
                    servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)appctx);
                    appctx.refresh();
                }
            };
            thread.setDaemon(true);
            thread.start();
            result = true;
        }
        catch (Throwable t) {
            log.error("Error setting up context: {} due to: {}", (Object)servletContext.getContextPath(), (Object)t.getMessage());
            t.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return result;
    }

    public void setBaseHost(Host baseHost) {
        log.debug("setBaseHost: {}", (Object)baseHost);
        this.host = baseHost;
    }

    public Host getBaseHost() {
        return this.host;
    }

    public Engine getEngine() {
        return engine;
    }

    public void setConnectors(List<TomcatConnector> connectors) {
        log.debug("setConnectors: {}", (Object)connectors.size());
        this.connectors = connectors;
    }

    public void setContexts(Map<String, String> contexts) throws ServletException {
        log.debug("setContexts: {}", (Object)contexts.size());
        for (Map.Entry<String, String> entry : contexts.entrySet()) {
            this.host.addChild((Container)embedded.addWebapp(entry.getKey(), this.webappFolder + entry.getValue()));
        }
    }

    public void setEmbedded(EmbeddedTomcat embedded) {
        log.info("Setting embedded: {}", (Object)((Object)((Object)embedded)).getClass().getName());
        TomcatLoader.embedded = embedded;
    }

    public EmbeddedTomcat getEmbedded() {
        return embedded;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        log.debug("setHost");
        this.host = host;
    }

    public void setHosts(List<Host> hosts) {
        log.debug("setHosts: {}", (Object)hosts.size());
        this.hosts = hosts;
    }

    public void setRealm(Realm realm) {
        log.info("Setting realm: {}", (Object)realm.getClass().getName());
        this.realm = realm;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setValves(List<Valve> valves) {
        log.debug("setValves: {}", (Object)valves.size());
        this.valves.addAll(valves);
    }

    public boolean isWebsocketEnabled() {
        return this.websocketEnabled;
    }

    public void setWebsocketEnabled(boolean websocketEnabled) {
        this.websocketEnabled = websocketEnabled;
    }

    protected String getHostId() {
        String hostId = this.host.getName();
        log.debug("Host id: {}", (Object)hostId);
        return hostId;
    }

    protected void registerJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName oName = new ObjectName("org.red5.server:type=TomcatLoader");
            if (!mbs.isRegistered(oName)) {
                mbs.registerMBean((Object)this, oName);
            } else {
                log.debug("ContextLoader is already registered in JMX");
            }
        }
        catch (Exception e) {
            log.warn("Error on jmx registration", (Throwable)e);
        }
    }

    protected void unregisterJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName oName = new ObjectName("org.red5.server:type=TomcatLoader");
            mbs.unregisterMBean(oName);
        }
        catch (Exception e) {
            log.warn("Exception unregistering", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        log.info("Shutting down Tomcat context");
        AbstractApplicationContext absCtx = (AbstractApplicationContext)LoaderBase.getApplicationContext();
        if (absCtx != null) {
            log.debug("Using loader base application context for shutdown");
            Map contexts = LoaderBase.getRed5ApplicationContexts();
            if (contexts.isEmpty()) {
                log.info("No contexts were found to shutdown");
            }
            for (Map.Entry entry : contexts.entrySet()) {
                log.debug("Calling stop on context: {}", entry.getKey());
                ((IApplicationContext)entry.getValue()).stop();
            }
            if (absCtx.isActive()) {
                log.debug("Closing application context");
                absCtx.close();
            }
        } else {
            log.error("Error getting Spring bean factory for shutdown");
        }
        try {
            WebSocketPlugin plugin = (WebSocketPlugin)PluginRegistry.getPlugin((String)"WebSocketPlugin");
            if (plugin != null) {
                plugin.doStop();
            }
        }
        catch (Exception e) {
            log.warn("WebSocket plugin stop, failed", (Throwable)e);
        }
        try {
            embedded.stop();
        }
        catch (Exception e) {
            log.warn("Tomcat could not be stopped", (Throwable)e);
            throw new RuntimeException("Tomcat could not be stopped");
        }
    }

    public String toString() {
        return "TomcatLoader [serviceEngineName=" + this.serviceEngineName + "]";
    }

    static {
        Security.setProperty("authconfigprovider.factory", AuthConfigFactoryImpl.class.getName());
        log = Red5LoggerFactory.getLogger(TomcatLoader.class);
        log.debug("Initializing Tomcat");
    }

    protected static final class DirectoryFilter
    implements FilenameFilter {
        protected DirectoryFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            if (log.isTraceEnabled()) {
                log.trace("Filtering: {} name: {} dir: {}", new Object[]{dir.getName(), name, f.getAbsolutePath()});
            }
            boolean result = f.isDirectory() && f.canRead() && !f.isHidden();
            f = null;
            return result;
        }
    }
}

