<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    public function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    public function __toString()
    {
        return $this->_string;
    }

    public function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    public function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    public function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);

                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    public function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 13 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 80 "smarty_internal_templateparser.php"
{
#line 15 "smarty_internal_templateparser.y"

    const Err1 = "Security error: Call to private object member not allowed";
    const Err2 = "Security error: Call to dynamic object member not allowed";
    const Err3 = "PHP in template not allowed. Use SmartyBC to enable it";
    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    public static $prefix_number = 0;
    private $lex;
    private $internalError = false;
    private $strip = false;

    function __construct($lex, $compiler) {
        
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        $this->compiler->has_variable_string = false;
        $this->compiler->prefix_code = array();
        $this->block_nesting_level = 0;
        if ($this->security = isset($this->smarty->security_policy)) {
            $this->php_handling = $this->smarty->security_policy->php_handling;
        } else {
            $this->php_handling = $this->smarty->php_handling;
        }
        $this->is_xml = false;
        $this->asp_tags = (ini_get('asp_tags') != '0');
        $this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }

    public static function escape_start_tag($tag_text) {
        $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
        return $tag;
    }

    public static function escape_end_tag($tag_text) {
        return '?<?php ?>>';
    }

    public function compileVariable($variable) {
        if (strpos($variable,'(') == 0) {
            // not a variable variable
            $var = trim($variable,'\'');
            $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable($var, null, true, false)->nocache;
            $this->template->properties['variables'][$var] = $this->compiler->tag_nocache|$this->compiler->nocache;
        }
//       return '(isset($_smarty_tpl->tpl_vars['. $variable .'])?$_smarty_tpl->tpl_vars['. $variable .']->value:$_smarty_tpl->getVariable('. $variable .')->value)';
        return '$_smarty_tpl->tpl_vars['. $variable .']->value';
    }
#line 133 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_RDEL                           =  3;
    const TP_COMMENT                        =  4;
    const TP_PHPSTARTTAG                    =  5;
    const TP_PHPENDTAG                      =  6;
    const TP_ASPSTARTTAG                    =  7;
    const TP_ASPENDTAG                      =  8;
    const TP_FAKEPHPSTARTTAG                =  9;
    const TP_XMLTAG                         = 10;
    const TP_TEXT                           = 11;
    const TP_STRIPON                        = 12;
    const TP_STRIPOFF                       = 13;
    const TP_BLOCKSOURCE                    = 14;
    const TP_LITERALSTART                   = 15;
    const TP_LITERALEND                     = 16;
    const TP_LITERAL                        = 17;
    const TP_LDEL                           = 18;
    const TP_DOLLAR                         = 19;
    const TP_ID                             = 20;
    const TP_EQUAL                          = 21;
    const TP_PTR                            = 22;
    const TP_LDELIF                         = 23;
    const TP_LDELFOR                        = 24;
    const TP_SEMICOLON                      = 25;
    const TP_INCDEC                         = 26;
    const TP_TO                             = 27;
    const TP_STEP                           = 28;
    const TP_LDELFOREACH                    = 29;
    const TP_SPACE                          = 30;
    const TP_AS                             = 31;
    const TP_APTR                           = 32;
    const TP_LDELSETFILTER                  = 33;
    const TP_SMARTYBLOCKCHILDPARENT         = 34;
    const TP_LDELSLASH                      = 35;
    const TP_ATTR                           = 36;
    const TP_INTEGER                        = 37;
    const TP_COMMA                          = 38;
    const TP_OPENP                          = 39;
    const TP_CLOSEP                         = 40;
    const TP_MATH                           = 41;
    const TP_UNIMATH                        = 42;
    const TP_ANDSYM                         = 43;
    const TP_ISIN                           = 44;
    const TP_ISDIVBY                        = 45;
    const TP_ISNOTDIVBY                     = 46;
    const TP_ISEVEN                         = 47;
    const TP_ISNOTEVEN                      = 48;
    const TP_ISEVENBY                       = 49;
    const TP_ISNOTEVENBY                    = 50;
    const TP_ISODD                          = 51;
    const TP_ISNOTODD                       = 52;
    const TP_ISODDBY                        = 53;
    const TP_ISNOTODDBY                     = 54;
    const TP_INSTANCEOF                     = 55;
    const TP_QMARK                          = 56;
    const TP_NOT                            = 57;
    const TP_TYPECAST                       = 58;
    const TP_HEX                            = 59;
    const TP_DOT                            = 60;
    const TP_SINGLEQUOTESTRING              = 61;
    const TP_DOUBLECOLON                    = 62;
    const TP_AT                             = 63;
    const TP_HATCH                          = 64;
    const TP_OPENB                          = 65;
    const TP_CLOSEB                         = 66;
    const TP_EQUALS                         = 67;
    const TP_NOTEQUALS                      = 68;
    const TP_GREATERTHAN                    = 69;
    const TP_LESSTHAN                       = 70;
    const TP_GREATEREQUAL                   = 71;
    const TP_LESSEQUAL                      = 72;
    const TP_IDENTITY                       = 73;
    const TP_NONEIDENTITY                   = 74;
    const TP_MOD                            = 75;
    const TP_LAND                           = 76;
    const TP_LOR                            = 77;
    const TP_LXOR                           = 78;
    const TP_QUOTE                          = 79;
    const TP_BACKTICK                       = 80;
    const TP_DOLLARID                       = 81;
    const YY_NO_ACTION = 570;
    const YY_ACCEPT_ACTION = 569;
    const YY_ERROR_ACTION = 568;

    const YY_SZ_ACTTAB = 2407;
static public $yy_action = array(
 /*     0 */   219,  309,  305,  301,  302,  303,  304,  310,  311,  317,
 /*    10 */   318,  319,  201,   30,  273,    9,   33,  238,  280,   15,
 /*    20 */     5,  108,  235,  234,  220,    7,  126,   42,   30,   30,
 /*    30 */   259,  211,  256,  495,   15,   15,   10,   33,  495,  280,
 /*    40 */    46,   47,   51,   45,   24,   14,  352,  353,   39,   37,
 /*    50 */   278,  359,   12,   25,  219,  219,  326,  434,  219,  192,
 /*    60 */   434,  569,   95,  263,  227,  306,  360,  361,  358,  357,
 /*    70 */   354,  355,  356,  342,  341,  328,  329,  330,  292,  219,
 /*    80 */   202,  322,  242,   30,  434,  231,  207,  434,  143,   15,
 /*    90 */   434,   35,  158,  434,   46,   47,   51,   45,   24,   14,
 /*   100 */   352,  353,   39,   37,  278,  359,   12,   25,  219,   48,
 /*   110 */    32,  219,   48,  391,  196,    2,   31,  138,  321,    4,
 /*   120 */   360,  361,  358,  357,  354,  355,  356,  342,  341,  328,
 /*   130 */   329,  330,  127,   48,  290,  349,  251,   30,  145,  140,
 /*   140 */    30,  207,  264,   15,  200,  322,   15,  334,   46,   47,
 /*   150 */    51,   45,   24,   14,  352,  353,   39,   37,  278,  359,
 /*   160 */    12,   25,  219,  289,  219,   48,  431,  297,  219,   33,
 /*   170 */   396,  280,   18,  191,  360,  361,  358,  357,  354,  355,
 /*   180 */   356,  342,  341,  328,  329,  330,  300,  285,  286,  287,
 /*   190 */   299,  206,  219,  431,  428,  194,  201,  315,  314,  431,
 /*   200 */   207,  281,   46,   47,   51,   45,   24,   14,  352,  353,
 /*   210 */    39,   37,  278,  359,   12,   25,  219,   33,   48,  280,
 /*   220 */    34,   30,   48,  197,  322,  276,  158,   15,  360,  361,
 /*   230 */   358,  357,  354,  355,  356,  342,  341,  328,  329,  330,
 /*   240 */   230,  338,   16,  289,  103,  179,  244,  219,  295,    2,
 /*   250 */    41,   33,  265,  280,  283,  148,   46,   47,   51,   45,
 /*   260 */    24,   14,  352,  353,   39,   37,  278,  359,   12,   25,
 /*   270 */   219,  207,  145,   43,  132,  189,  109,  333,  307,  227,
 /*   280 */   306,  190,  360,  361,  358,  357,  354,  355,  356,  342,
 /*   290 */   341,  328,  329,  330,   20,   22,  248,  339,  219,   99,
 /*   300 */   174,   48,  324,   33,  346,  280,   18,  288,  207,  283,
 /*   310 */    46,   47,   51,   45,   24,   14,  352,  353,   39,   37,
 /*   320 */   278,  359,   12,   25,  219,  289,  207,   30,   41,  110,
 /*   330 */   275,    2,   41,   15,  272,  266,  360,  361,  358,  357,
 /*   340 */   354,  355,  356,  342,  341,  328,  329,  330,  242,   40,
 /*   350 */   236,  347,  104,  177,  145,  219,   44,  316,  148,  135,
 /*   360 */   228,   27,  283,  269,   46,   47,   51,   45,   24,   14,
 /*   370 */   352,  353,   39,   37,  278,  359,   12,   25,  219,  207,
 /*   380 */   208,   33,    7,  280,  245,  239,  136,  173,  241,  279,
 /*   390 */   360,  361,  358,  357,  354,  355,  356,  342,  341,  328,
 /*   400 */   329,  330,   29,  158,  106,   13,  122,  171,  181,    6,
 /*   410 */    33,   15,  226,   33,  219,  237,  283,  283,   46,   47,
 /*   420 */    51,   45,   24,   14,  352,  353,   39,   37,  278,  359,
 /*   430 */    12,   25,  219,  205,  205,  252,  313,  238,  312,  235,
 /*   440 */   232,  195,   97,  127,  360,  361,  358,  357,  354,  355,
 /*   450 */   356,  342,  341,  328,  329,  330,   28,  320,  230,  105,
 /*   460 */   182,  164,  176,   33,  279,  254,  282,  186,  207,  283,
 /*   470 */   283,  253,   46,   47,   51,   45,   24,   14,  352,  353,
 /*   480 */    39,   37,  278,  359,   12,   25,  219,  205,  260,  107,
 /*   490 */   235,  262,   33,  193,  214,  332,  166,  198,  360,  361,
 /*   500 */   358,  357,  354,  355,  356,  342,  341,  328,  329,  330,
 /*   510 */   137,  175,  167,  291,  308,  344,  185,  261,  267,  161,
 /*   520 */   283,  283,  128,  337,  124,  283,   46,   47,   51,   45,
 /*   530 */    24,   14,  352,  353,   39,   37,  278,  359,   12,   25,
 /*   540 */   219,   38,  205,  203,  141,  169,  257,  134,   35,  130,
 /*   550 */   156,  114,  360,  361,  358,  357,  354,  355,  356,  342,
 /*   560 */   341,  328,  329,  330,  320,  158,  320,  241,   36,  293,
 /*   570 */   298,   94,   21,   26,  284,  219,  292,  168,  271,  162,
 /*   580 */    46,   47,   51,   45,   24,   14,  352,  353,   39,   37,
 /*   590 */   278,  359,   12,   25,  219,  279,  229,  205,   44,  281,
 /*   600 */   187,   17,  270,  331,   98,  127,  360,  361,  358,  357,
 /*   610 */   354,  355,  356,  342,  341,  328,  329,  330,  199,  320,
 /*   620 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*   630 */   331,  331,  331,  331,   46,   47,   51,   45,   24,   14,
 /*   640 */   352,  353,   39,   37,  278,  359,   12,   25,  219,  331,
 /*   650 */   268,  331,  331,  331,  331,  331,  331,  331,  125,  115,
 /*   660 */   360,  361,  358,  357,  354,  355,  356,  342,  341,  328,
 /*   670 */   329,  330,  279,  331,  320,  331,  331,  331,  331,  331,
 /*   680 */   331,  331,  331,  331,  331,  331,  331,  331,   46,   47,
 /*   690 */    51,   45,   24,   14,  352,  353,   39,   37,  278,  359,
 /*   700 */    12,   25,  219,  331,  204,  331,  331,  331,  331,  331,
 /*   710 */   331,  159,  100,  116,  360,  361,  358,  357,  354,  355,
 /*   720 */   356,  342,  341,  328,  329,  330,  320,  320,  320,  331,
 /*   730 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*   740 */   331,  331,   46,   47,   51,   45,   24,   14,  352,  353,
 /*   750 */    39,   37,  278,  359,   12,   25,  219,  331,  331,  331,
 /*   760 */   331,  331,  331,  331,  331,  102,  117,  331,  360,  361,
 /*   770 */   358,  357,  354,  355,  356,  342,  341,  328,  329,  330,
 /*   780 */   320,  320,  331,  331,  331,  331,  331,  331,  331,  331,
 /*   790 */   331,  331,  331,  331,  331,  331,   46,   47,   51,   45,
 /*   800 */    24,   14,  352,  353,   39,   37,  278,  359,   12,   25,
 /*   810 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*   820 */   158,  331,  360,  361,  358,  357,  354,  355,  356,  342,
 /*   830 */   341,  328,  329,  330,  331,  331,  331,  331,   46,   47,
 /*   840 */    51,   45,   24,   14,  352,  353,   39,   37,  278,  359,
 /*   850 */    12,   25,  331,  331,  331,  331,  331,  331,  211,  331,
 /*   860 */   331,  331,  331,   10,  360,  361,  358,  357,  354,  355,
 /*   870 */   356,  342,  341,  328,  329,  330,  331,  331,  331,  331,
 /*   880 */   331,  331,  331,    9,  142,  212,  331,  331,    5,  108,
 /*   890 */   331,  246,  331,  331,  126,  157,  183,  331,  259,  123,
 /*   900 */   256,  331,  250,  331,   23,  283,  331,   52,  277,  331,
 /*   910 */   331,  255,  350,  348,  331,  345,  331,  279,  180,  178,
 /*   920 */   331,  331,   49,   50,  296,  240,  351,  283,  283,  106,
 /*   930 */     1,  274,  331,  147,  331,  331,  331,  331,  331,  279,
 /*   940 */   279,    9,  144,   92,   96,  233,    5,  108,  331,  345,
 /*   950 */   331,  331,  126,  331,  331,  246,  259,  323,  256,  146,
 /*   960 */   250,  331,   23,  123,  184,   52,  331,  331,  331,  331,
 /*   970 */   246,  331,  343,  283,  153,  255,  350,  348,  123,  345,
 /*   980 */    49,   50,  296,  240,  351,  279,  331,  106,    1,  331,
 /*   990 */   255,  350,  348,  331,  345,   33,  331,  280,  331,    9,
 /*  1000 */   142,  224,   96,  331,    5,  108,  331,   30,  331,  247,
 /*  1010 */   126,  246,  331,   15,  259,  149,  256,  331,  250,  123,
 /*  1020 */    23,  331,  331,   52,  331,  331,  331,  331,  331,  331,
 /*  1030 */   331,  255,  350,  348,  331,  345,  331,  331,   49,   50,
 /*  1040 */   296,  240,  351,  331,  331,  106,    1,  331,  331,  331,
 /*  1050 */   331,  331,   33,  331,  280,  331,  331,    9,  135,  224,
 /*  1060 */    96,  331,    5,  108,   30,  246,  258,  331,  126,  151,
 /*  1070 */    15,  246,  259,  123,  256,  154,  250,  331,   11,  123,
 /*  1080 */   331,   52,  331,  331,  331,  255,  350,  348,  331,  345,
 /*  1090 */   331,  255,  350,  348,  331,  345,   49,   50,  296,  240,
 /*  1100 */   351,  331,  331,  106,    1,  331,  331,  331,  331,  331,
 /*  1110 */   331,  331,  331,  331,  331,    9,  142,  210,   96,  331,
 /*  1120 */     5,  108,  331,  331,  331,  331,  126,  246,  331,  331,
 /*  1130 */   259,  155,  256,  331,  216,  123,   23,  331,  331,   52,
 /*  1140 */   331,  331,  331,  331,  331,  331,  331,  255,  350,  348,
 /*  1150 */   331,  345,  331,  331,   49,   50,  296,  240,  351,  331,
 /*  1160 */   331,  106,    1,  331,  331,  331,  331,  331,  331,  331,
 /*  1170 */   331,  331,  331,    9,  131,  224,   96,  331,    5,  108,
 /*  1180 */   331,  331,  331,  331,  126,  246,  331,  331,  259,  152,
 /*  1190 */   256,  331,  250,  123,    3,  331,  331,   52,  331,  331,
 /*  1200 */   331,  331,  331,  331,  331,  255,  350,  348,  331,  345,
 /*  1210 */   331,  331,   49,   50,  296,  240,  351,  331,  331,  106,
 /*  1220 */     1,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  1230 */   331,    9,  142,  213,   96,  331,    5,  108,  331,  331,
 /*  1240 */   331,  331,  126,  246,  331,  331,  259,  150,  256,  331,
 /*  1250 */   250,  123,   23,  331,  331,   52,  331,  331,  331,  331,
 /*  1260 */   331,  331,  331,  255,  350,  348,  331,  345,  331,  331,
 /*  1270 */    49,   50,  296,  240,  351,  331,  331,  106,    1,  331,
 /*  1280 */   219,  331,  401,  331,  331,  331,  331,  331,  331,    9,
 /*  1290 */   142,  209,   96,  331,    5,  108,  331,  331,  331,  331,
 /*  1300 */   126,  249,  331,  331,  259,  331,  256,  331,  250,   30,
 /*  1310 */    23,  190,  163,   52,  331,   15,  331,  331,    2,  331,
 /*  1320 */   331,  283,  331,  331,   20,   22,  331,  331,   49,   50,
 /*  1330 */   296,  240,  351,  331,  331,  106,    1,  331,  207,  331,
 /*  1340 */   331,  145,  331,  331,  331,  432,  331,    9,  139,  224,
 /*  1350 */    96,  331,    5,  108,  331,  331,  331,  331,  126,  331,
 /*  1360 */   331,  331,  259,  243,  256,  331,  250,  331,   23,  190,
 /*  1370 */   188,   52,  432,  331,  331,  331,  331,  331,  432,  283,
 /*  1380 */   331,    2,   20,   22,  331,  331,   49,   50,  296,  240,
 /*  1390 */   351,  331,  331,  106,    1,  331,  207,  331,  331,  331,
 /*  1400 */   331,  331,  331,  331,  145,    9,  135,  224,   96,  331,
 /*  1410 */     5,  108,  331,  331,  331,  331,  126,  331,  331,  331,
 /*  1420 */   259,  331,  256,  331,  250,  331,   11,  101,  160,   52,
 /*  1430 */   331,  331,  331,  331,  331,  331,  331,  283,  331,  331,
 /*  1440 */    20,   22,  331,  331,   49,   50,  296,  240,  351,  331,
 /*  1450 */   331,  106,  331,  331,  207,  331,  331,  331,  331,  331,
 /*  1460 */   331,  331,  331,    9,  135,  225,   96,  331,    5,  108,
 /*  1470 */   331,  331,  331,  331,  126,  331,  331,  331,  259,  331,
 /*  1480 */   256,  331,  250,  331,   11,  331,  477,   52,  331,  331,
 /*  1490 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  1500 */   331,  331,   49,   50,  296,  240,  351,  331,  477,  106,
 /*  1510 */   477,  477,  331,  477,  477,  331,  331,  331,  331,  477,
 /*  1520 */   331,  477,    2,  477,   96,  331,  331,  331,  331,  331,
 /*  1530 */   331,  331,  331,  331,  331,  246,  331,  331,  477,  120,
 /*  1540 */   331,  331,   84,  123,  331,  145,  331,  331,  331,  477,
 /*  1550 */   331,  294,  327,  331,  331,  255,  350,  348,  331,  345,
 /*  1560 */   331,  331,  331,  477,  331,  331,  331,  246,  331,  218,
 /*  1570 */   362,  120,  331,  331,   84,  123,  331,  331,  331,  331,
 /*  1580 */   331,  331,  331,  294,  327,  331,  331,  255,  350,  348,
 /*  1590 */   246,  345,  331,  331,  129,  331,  331,   61,  119,  232,
 /*  1600 */   331,  246,  335,  331,  331,  129,  294,  327,   80,  123,
 /*  1610 */   255,  350,  348,  331,  345,  331,  331,  294,  327,  331,
 /*  1620 */   331,  255,  350,  348,  331,  345,  246,  331,  331,  331,
 /*  1630 */   129,  331,  215,   80,  123,  331,  331,  331,  331,  331,
 /*  1640 */   331,  331,  294,  327,  331,  331,  255,  350,  348,  331,
 /*  1650 */   345,  331,  331,  331,  246,  190,  170,  221,  129,  331,
 /*  1660 */   331,   55,  119,  133,  331,  283,  331,  331,   20,   22,
 /*  1670 */   294,  327,  331,  331,  255,  350,  348,  246,  345,  331,
 /*  1680 */   331,  129,  207,  331,   80,  123,  331,  331,  331,  331,
 /*  1690 */   331,  331,  331,  294,  327,  331,  246,  255,  350,  348,
 /*  1700 */   129,  345,  331,   89,  123,  331,  331,  331,  223,  331,
 /*  1710 */   331,  331,  294,  327,  331,  331,  255,  350,  348,  246,
 /*  1720 */   345,  331,  331,  129,  331,  331,   70,  123,  331,  331,
 /*  1730 */   246,  331,  331,  331,  111,  294,  327,   67,  123,  255,
 /*  1740 */   350,  348,  331,  345,  331,  331,  294,  327,  331,  246,
 /*  1750 */   255,  350,  348,  129,  345,  331,   86,  123,  331,  331,
 /*  1760 */   331,  331,  331,  331,  331,  294,  327,  331,  246,  255,
 /*  1770 */   350,  348,  129,  345,  331,   90,  123,  331,  331,  331,
 /*  1780 */   331,  331,  331,  331,  294,  327,  331,  246,  255,  350,
 /*  1790 */   348,  129,  345,  331,   77,  123,  331,  331,  331,  331,
 /*  1800 */   331,  331,  331,  294,  327,  331,  246,  255,  350,  348,
 /*  1810 */   129,  345,  331,   74,  123,  331,  331,  246,  331,  331,
 /*  1820 */   331,  129,  294,  327,   66,  123,  255,  350,  348,  331,
 /*  1830 */   345,  331,  331,  294,  327,  331,  246,  222,  350,  348,
 /*  1840 */   129,  345,  331,   69,  123,  331,  331,  331,  331,  331,
 /*  1850 */   331,  331,  294,  327,  331,  246,  255,  350,  348,  129,
 /*  1860 */   345,  331,   78,  123,  331,  331,  331,  331,  331,  331,
 /*  1870 */   331,  294,  327,  331,  246,  255,  350,  348,  129,  345,
 /*  1880 */   331,   60,  123,  331,  331,  331,  331,  331,  331,  331,
 /*  1890 */   294,  327,  331,  246,  255,  350,  348,  129,  345,  331,
 /*  1900 */    53,  123,  331,  331,  246,  331,  331,  331,  129,  294,
 /*  1910 */   327,   65,  123,  255,  350,  348,  331,  345,  331,  331,
 /*  1920 */   294,  327,  336,  331,  255,  350,  348,  331,  345,    8,
 /*  1930 */   331,  331,  331,  331,    5,  108,  331,  331,  331,  331,
 /*  1940 */   126,  331,  331,  246,  259,  331,  256,  129,  331,  331,
 /*  1950 */    72,  123,  331,  331,  331,  331,  331,  331,  331,  294,
 /*  1960 */   327,  331,  246,  255,  350,  348,  129,  345,  331,   85,
 /*  1970 */   123,  331,  331,  331,  331,  331,  331,  331,  294,  327,
 /*  1980 */   331,  246,  255,  350,  348,  129,  345,  331,   81,  123,
 /*  1990 */   331,   19,  340,  331,  331,  331,  331,  294,  327,  331,
 /*  2000 */   246,  255,  350,  348,  113,  345,  331,   82,  123,  331,
 /*  2010 */   331,  246,  331,  331,  331,   93,  294,  327,   54,  121,
 /*  2020 */   255,  350,  348,  331,  345,  331,  331,  294,  327,  331,
 /*  2030 */   246,  217,  350,  348,  129,  345,  331,   58,  123,  331,
 /*  2040 */   331,  331,  331,  331,  331,  331,  294,  327,  331,  336,
 /*  2050 */   255,  350,  348,  331,  345,  331,    8,  331,  331,  331,
 /*  2060 */   331,    5,  108,  331,  331,  331,  331,  126,  246,  331,
 /*  2070 */   331,  259,  129,  256,  331,   88,  123,  331,  331,  246,
 /*  2080 */   331,  331,  331,  129,  294,  327,   56,  123,  255,  350,
 /*  2090 */   348,  331,  345,  331,  331,  294,  327,  331,  331,  255,
 /*  2100 */   350,  348,  331,  345,  246,  331,  331,  331,  129,  331,
 /*  2110 */   331,   68,  123,  331,  331,  331,  331,  325,   19,  340,
 /*  2120 */   294,  327,  331,  331,  255,  350,  348,  331,  345,  331,
 /*  2130 */   331,  331,  331,  246,  331,  331,  331,  118,  331,  331,
 /*  2140 */    59,  123,  331,  331,  331,  331,  190,  172,  331,  294,
 /*  2150 */   327,  331,  331,  255,  350,  348,  283,  345,  246,   20,
 /*  2160 */    22,  331,   93,  331,  331,   57,  121,  331,  331,  331,
 /*  2170 */   331,  331,  331,  207,  294,  327,  331,  246,  255,  350,
 /*  2180 */   348,  129,  345,  331,   64,  123,  331,  331,  246,  331,
 /*  2190 */   331,  331,  129,  294,  327,   63,  123,  255,  350,  348,
 /*  2200 */   331,  345,  331,  331,  294,  327,  331,  246,  255,  350,
 /*  2210 */   348,  129,  345,  331,   73,  123,  331,  331,  331,  331,
 /*  2220 */   190,  165,  331,  294,  327,  331,  331,  255,  350,  348,
 /*  2230 */   283,  345,  331,   20,   22,  331,  246,  331,  331,  331,
 /*  2240 */   129,  331,  331,   87,  123,  331,  331,  207,  331,  331,
 /*  2250 */   331,  331,  294,  327,  331,  331,  255,  350,  348,  331,
 /*  2260 */   345,  246,  331,  331,  331,  129,  331,  331,   75,  123,
 /*  2270 */   331,  331,  246,  331,  331,  331,  129,  294,  327,   61,
 /*  2280 */   123,  255,  350,  348,  331,  345,  331,  331,  294,  327,
 /*  2290 */   331,  246,  255,  350,  348,  129,  345,  331,   71,  123,
 /*  2300 */   331,  331,  246,  331,  331,  331,  129,  294,  327,   83,
 /*  2310 */   123,  255,  350,  348,  331,  345,  331,  331,  294,  327,
 /*  2320 */   331,  331,  255,  350,  348,  331,  345,  246,  331,  331,
 /*  2330 */   331,  112,  331,  331,   76,  123,  331,  331,  331,  331,
 /*  2340 */   331,  331,  331,  294,  327,  331,  331,  255,  350,  348,
 /*  2350 */   331,  345,  246,  331,  331,  331,  129,  331,  331,   91,
 /*  2360 */   123,  331,  331,  246,  331,  331,  331,  129,  294,  327,
 /*  2370 */    62,  123,  255,  350,  348,  331,  345,  331,  331,  294,
 /*  2380 */   327,  331,  246,  255,  350,  348,  129,  345,  331,   79,
 /*  2390 */   123,  331,  331,  331,  331,  331,  331,  331,  294,  327,
 /*  2400 */   331,  331,  255,  350,  348,  331,  345,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*    10 */    13,   14,   15,   30,   66,   18,   18,    2,   20,   36,
 /*    20 */    23,   24,   94,   95,   96,   39,   29,   28,   30,   30,
 /*    30 */    33,   60,   35,   60,   36,   36,   65,   18,   65,   20,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*    50 */    51,   52,   53,   54,    1,    1,    3,    3,    1,   91,
 /*    60 */     3,   83,   84,   85,   86,   87,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,   74,   75,   76,   77,   78,  112,    1,
 /*    80 */   114,  115,   63,   30,   30,   31,  118,   30,   19,   36,
 /*    90 */    36,   21,   22,   36,   41,   42,   43,   44,   45,   46,
 /*   100 */    47,   48,   49,   50,   51,   52,   53,   54,    1,   55,
 /*   110 */    32,    1,   55,    3,   91,   39,   18,   19,   20,   38,
 /*   120 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   130 */    77,   78,   62,   55,   20,   37,   60,   30,   62,   20,
 /*   140 */    30,  118,   66,   36,  114,  115,   36,   66,   41,   42,
 /*   150 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
 /*   160 */    53,   54,    1,   26,    1,   55,    3,   37,    1,   18,
 /*   170 */     3,   20,   21,   91,   67,   68,   69,   70,   71,   72,
 /*   180 */    73,   74,   75,   76,   77,   78,    5,    6,    7,    8,
 /*   190 */     9,   20,    1,   30,    3,  100,   15,   16,   17,   36,
 /*   200 */   118,  119,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   210 */    49,   50,   51,   52,   53,   54,    1,   18,   55,   20,
 /*   220 */    21,   30,   55,  114,  115,   26,   22,   36,   67,   68,
 /*   230 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   240 */    86,   80,   32,   26,   91,   92,   31,    1,  109,   39,
 /*   250 */    38,   18,   40,   20,  101,  116,   41,   42,   43,   44,
 /*   260 */    45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
 /*   270 */     1,  118,   62,   18,   19,   20,  122,  123,   85,   86,
 /*   280 */    87,   91,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   290 */    75,   76,   77,   78,  104,  105,   63,   80,    1,   91,
 /*   300 */    92,   55,    3,   18,  115,   20,   21,   20,  118,  101,
 /*   310 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   320 */    51,   52,   53,   54,    1,   26,  118,   30,   38,   88,
 /*   330 */    40,   39,   38,   36,   40,   66,   67,   68,   69,   70,
 /*   340 */    71,   72,   73,   74,   75,   76,   77,   78,   63,   21,
 /*   350 */    63,  109,   91,   92,   62,    1,    2,   16,  116,   19,
 /*   360 */    20,   18,  101,   40,   41,   42,   43,   44,   45,   46,
 /*   370 */    47,   48,   49,   50,   51,   52,   53,   54,    1,  118,
 /*   380 */     3,   18,   39,   20,   19,   20,   19,  111,   60,  113,
 /*   390 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   400 */    77,   78,   21,   22,   64,   30,   39,   92,   92,   39,
 /*   410 */    18,   36,   20,   18,    1,   20,  101,  101,   41,   42,
 /*   420 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
 /*   430 */    53,   54,    1,  118,  118,   22,   87,    2,   89,   94,
 /*   440 */    95,   91,   98,   62,   67,   68,   69,   70,   71,   72,
 /*   450 */    73,   74,   75,   76,   77,   78,   21,  113,   86,  111,
 /*   460 */    92,   92,  111,   18,  113,   20,   20,  111,  118,  101,
 /*   470 */   101,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   480 */    49,   50,   51,   52,   53,   54,    1,  118,    3,  100,
 /*   490 */    94,   95,   18,  100,   20,  123,  111,   25,   67,   68,
 /*   500 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   510 */    38,   92,   92,   20,    3,    3,   92,   20,   40,   64,
 /*   520 */   101,  101,   19,    3,   19,  101,   41,   42,   43,   44,
 /*   530 */    45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
 /*   540 */     1,    2,  118,   20,   19,   64,   20,   19,   21,   98,
 /*   550 */    20,   98,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   560 */    75,   76,   77,   78,  113,   22,  113,   60,   27,   20,
 /*   570 */    37,   20,   56,    2,  101,    1,  112,  111,  116,  111,
 /*   580 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   590 */    51,   52,   53,   54,    1,  113,   97,  118,    2,  119,
 /*   600 */   111,   97,   30,  124,   98,   62,   67,   68,   69,   70,
 /*   610 */    71,   72,   73,   74,   75,   76,   77,   78,   25,  113,
 /*   620 */   124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
 /*   630 */   124,  124,  124,  124,   41,   42,   43,   44,   45,   46,
 /*   640 */    47,   48,   49,   50,   51,   52,   53,   54,    1,  124,
 /*   650 */     3,  124,  124,  124,  124,  124,  124,  124,   99,   98,
 /*   660 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   670 */    77,   78,  113,  124,  113,  124,  124,  124,  124,  124,
 /*   680 */   124,  124,  124,  124,  124,  124,  124,  124,   41,   42,
 /*   690 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
 /*   700 */    53,   54,    1,  124,    3,  124,  124,  124,  124,  124,
 /*   710 */   124,   98,   98,   98,   67,   68,   69,   70,   71,   72,
 /*   720 */    73,   74,   75,   76,   77,   78,  113,  113,  113,  124,
 /*   730 */   124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
 /*   740 */   124,  124,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   750 */    49,   50,   51,   52,   53,   54,    1,  124,  124,  124,
 /*   760 */   124,  124,  124,  124,  124,   98,   98,  124,   67,   68,
 /*   770 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   780 */   113,  113,  124,  124,  124,  124,  124,  124,  124,  124,
 /*   790 */   124,  124,  124,  124,  124,  124,   41,   42,   43,   44,
 /*   800 */    45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
 /*   810 */   124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
 /*   820 */    22,  124,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   830 */    75,   76,   77,   78,  124,  124,  124,  124,   41,   42,
 /*   840 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
 /*   850 */    53,   54,  124,  124,  124,  124,  124,  124,   60,  124,
 /*   860 */   124,  124,  124,   65,   67,   68,   69,   70,   71,   72,
 /*   870 */    73,   74,   75,   76,   77,   78,  124,  124,  124,  124,
 /*   880 */   124,  124,  124,   18,   19,   20,  124,  124,   23,   24,
 /*   890 */   124,   86,  124,  124,   29,   90,   92,  124,   33,   94,
 /*   900 */    35,  124,   37,  124,   39,  101,  124,   42,  103,  124,
 /*   910 */   124,  106,  107,  108,  124,  110,  124,  113,   92,   92,
 /*   920 */   124,  124,   57,   58,   59,   60,   61,  101,  101,   64,
 /*   930 */    65,   66,  124,   94,  124,  124,  124,  124,  124,  113,
 /*   940 */   113,   18,   19,   20,   79,  106,   23,   24,  124,  110,
 /*   950 */   124,  124,   29,  124,  124,   86,   33,   34,   35,   90,
 /*   960 */    37,  124,   39,   94,   92,   42,  124,  124,  124,  124,
 /*   970 */    86,  124,  103,  101,   90,  106,  107,  108,   94,  110,
 /*   980 */    57,   58,   59,   60,   61,  113,  124,   64,   65,  124,
 /*   990 */   106,  107,  108,  124,  110,   18,  124,   20,  124,   18,
 /*  1000 */    19,   20,   79,  124,   23,   24,  124,   30,  124,   32,
 /*  1010 */    29,   86,  124,   36,   33,   90,   35,  124,   37,   94,
 /*  1020 */    39,  124,  124,   42,  124,  124,  124,  124,  124,  124,
 /*  1030 */   124,  106,  107,  108,  124,  110,  124,  124,   57,   58,
 /*  1040 */    59,   60,   61,  124,  124,   64,   65,  124,  124,  124,
 /*  1050 */   124,  124,   18,  124,   20,  124,  124,   18,   19,   20,
 /*  1060 */    79,  124,   23,   24,   30,   86,   32,  124,   29,   90,
 /*  1070 */    36,   86,   33,   94,   35,   90,   37,  124,   39,   94,
 /*  1080 */   124,   42,  124,  124,  124,  106,  107,  108,  124,  110,
 /*  1090 */   124,  106,  107,  108,  124,  110,   57,   58,   59,   60,
 /*  1100 */    61,  124,  124,   64,   65,  124,  124,  124,  124,  124,
 /*  1110 */   124,  124,  124,  124,  124,   18,   19,   20,   79,  124,
 /*  1120 */    23,   24,  124,  124,  124,  124,   29,   86,  124,  124,
 /*  1130 */    33,   90,   35,  124,   37,   94,   39,  124,  124,   42,
 /*  1140 */   124,  124,  124,  124,  124,  124,  124,  106,  107,  108,
 /*  1150 */   124,  110,  124,  124,   57,   58,   59,   60,   61,  124,
 /*  1160 */   124,   64,   65,  124,  124,  124,  124,  124,  124,  124,
 /*  1170 */   124,  124,  124,   18,   19,   20,   79,  124,   23,   24,
 /*  1180 */   124,  124,  124,  124,   29,   86,  124,  124,   33,   90,
 /*  1190 */    35,  124,   37,   94,   39,  124,  124,   42,  124,  124,
 /*  1200 */   124,  124,  124,  124,  124,  106,  107,  108,  124,  110,
 /*  1210 */   124,  124,   57,   58,   59,   60,   61,  124,  124,   64,
 /*  1220 */    65,  124,  124,  124,  124,  124,  124,  124,  124,  124,
 /*  1230 */   124,   18,   19,   20,   79,  124,   23,   24,  124,  124,
 /*  1240 */   124,  124,   29,   86,  124,  124,   33,   90,   35,  124,
 /*  1250 */    37,   94,   39,  124,  124,   42,  124,  124,  124,  124,
 /*  1260 */   124,  124,  124,  106,  107,  108,  124,  110,  124,  124,
 /*  1270 */    57,   58,   59,   60,   61,  124,  124,   64,   65,  124,
 /*  1280 */     1,  124,    3,  124,  124,  124,  124,  124,  124,   18,
 /*  1290 */    19,   20,   79,  124,   23,   24,  124,  124,  124,  124,
 /*  1300 */    29,   22,  124,  124,   33,  124,   35,  124,   37,   30,
 /*  1310 */    39,   91,   92,   42,  124,   36,  124,  124,   39,  124,
 /*  1320 */   124,  101,  124,  124,  104,  105,  124,  124,   57,   58,
 /*  1330 */    59,   60,   61,  124,  124,   64,   65,  124,  118,  124,
 /*  1340 */   124,   62,  124,  124,  124,    3,  124,   18,   19,   20,
 /*  1350 */    79,  124,   23,   24,  124,  124,  124,  124,   29,  124,
 /*  1360 */   124,  124,   33,   21,   35,  124,   37,  124,   39,   91,
 /*  1370 */    92,   42,   30,  124,  124,  124,  124,  124,   36,  101,
 /*  1380 */   124,   39,  104,  105,  124,  124,   57,   58,   59,   60,
 /*  1390 */    61,  124,  124,   64,   65,  124,  118,  124,  124,  124,
 /*  1400 */   124,  124,  124,  124,   62,   18,   19,   20,   79,  124,
 /*  1410 */    23,   24,  124,  124,  124,  124,   29,  124,  124,  124,
 /*  1420 */    33,  124,   35,  124,   37,  124,   39,   91,   92,   42,
 /*  1430 */   124,  124,  124,  124,  124,  124,  124,  101,  124,  124,
 /*  1440 */   104,  105,  124,  124,   57,   58,   59,   60,   61,  124,
 /*  1450 */   124,   64,  124,  124,  118,  124,  124,  124,  124,  124,
 /*  1460 */   124,  124,  124,   18,   19,   20,   79,  124,   23,   24,
 /*  1470 */   124,  124,  124,  124,   29,  124,  124,  124,   33,  124,
 /*  1480 */    35,  124,   37,  124,   39,  124,    3,   42,  124,  124,
 /*  1490 */   124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
 /*  1500 */   124,  124,   57,   58,   59,   60,   61,  124,   25,   64,
 /*  1510 */    27,   28,  124,   30,   31,  124,  124,  124,  124,   36,
 /*  1520 */   124,   38,   39,   40,   79,  124,  124,  124,  124,  124,
 /*  1530 */   124,  124,  124,  124,  124,   86,  124,  124,   55,   90,
 /*  1540 */   124,  124,   93,   94,  124,   62,  124,  124,  124,   66,
 /*  1550 */   124,  102,  103,  124,  124,  106,  107,  108,  124,  110,
 /*  1560 */   124,  124,  124,   80,  124,  124,  124,   86,  124,  120,
 /*  1570 */   121,   90,  124,  124,   93,   94,  124,  124,  124,  124,
 /*  1580 */   124,  124,  124,  102,  103,  124,  124,  106,  107,  108,
 /*  1590 */    86,  110,  124,  124,   90,  124,  124,   93,   94,   95,
 /*  1600 */   124,   86,  121,  124,  124,   90,  102,  103,   93,   94,
 /*  1610 */   106,  107,  108,  124,  110,  124,  124,  102,  103,  124,
 /*  1620 */   124,  106,  107,  108,  124,  110,   86,  124,  124,  124,
 /*  1630 */    90,  124,  117,   93,   94,  124,  124,  124,  124,  124,
 /*  1640 */   124,  124,  102,  103,  124,  124,  106,  107,  108,  124,
 /*  1650 */   110,  124,  124,  124,   86,   91,   92,  117,   90,  124,
 /*  1660 */   124,   93,   94,   95,  124,  101,  124,  124,  104,  105,
 /*  1670 */   102,  103,  124,  124,  106,  107,  108,   86,  110,  124,
 /*  1680 */   124,   90,  118,  124,   93,   94,  124,  124,  124,  124,
 /*  1690 */   124,  124,  124,  102,  103,  124,   86,  106,  107,  108,
 /*  1700 */    90,  110,  124,   93,   94,  124,  124,  124,  117,  124,
 /*  1710 */   124,  124,  102,  103,  124,  124,  106,  107,  108,   86,
 /*  1720 */   110,  124,  124,   90,  124,  124,   93,   94,  124,  124,
 /*  1730 */    86,  124,  124,  124,   90,  102,  103,   93,   94,  106,
 /*  1740 */   107,  108,  124,  110,  124,  124,  102,  103,  124,   86,
 /*  1750 */   106,  107,  108,   90,  110,  124,   93,   94,  124,  124,
 /*  1760 */   124,  124,  124,  124,  124,  102,  103,  124,   86,  106,
 /*  1770 */   107,  108,   90,  110,  124,   93,   94,  124,  124,  124,
 /*  1780 */   124,  124,  124,  124,  102,  103,  124,   86,  106,  107,
 /*  1790 */   108,   90,  110,  124,   93,   94,  124,  124,  124,  124,
 /*  1800 */   124,  124,  124,  102,  103,  124,   86,  106,  107,  108,
 /*  1810 */    90,  110,  124,   93,   94,  124,  124,   86,  124,  124,
 /*  1820 */   124,   90,  102,  103,   93,   94,  106,  107,  108,  124,
 /*  1830 */   110,  124,  124,  102,  103,  124,   86,  106,  107,  108,
 /*  1840 */    90,  110,  124,   93,   94,  124,  124,  124,  124,  124,
 /*  1850 */   124,  124,  102,  103,  124,   86,  106,  107,  108,   90,
 /*  1860 */   110,  124,   93,   94,  124,  124,  124,  124,  124,  124,
 /*  1870 */   124,  102,  103,  124,   86,  106,  107,  108,   90,  110,
 /*  1880 */   124,   93,   94,  124,  124,  124,  124,  124,  124,  124,
 /*  1890 */   102,  103,  124,   86,  106,  107,  108,   90,  110,  124,
 /*  1900 */    93,   94,  124,  124,   86,  124,  124,  124,   90,  102,
 /*  1910 */   103,   93,   94,  106,  107,  108,  124,  110,  124,  124,
 /*  1920 */   102,  103,   11,  124,  106,  107,  108,  124,  110,   18,
 /*  1930 */   124,  124,  124,  124,   23,   24,  124,  124,  124,  124,
 /*  1940 */    29,  124,  124,   86,   33,  124,   35,   90,  124,  124,
 /*  1950 */    93,   94,  124,  124,  124,  124,  124,  124,  124,  102,
 /*  1960 */   103,  124,   86,  106,  107,  108,   90,  110,  124,   93,
 /*  1970 */    94,  124,  124,  124,  124,  124,  124,  124,  102,  103,
 /*  1980 */   124,   86,  106,  107,  108,   90,  110,  124,   93,   94,
 /*  1990 */    79,   80,   81,  124,  124,  124,  124,  102,  103,  124,
 /*  2000 */    86,  106,  107,  108,   90,  110,  124,   93,   94,  124,
 /*  2010 */   124,   86,  124,  124,  124,   90,  102,  103,   93,   94,
 /*  2020 */   106,  107,  108,  124,  110,  124,  124,  102,  103,  124,
 /*  2030 */    86,  106,  107,  108,   90,  110,  124,   93,   94,  124,
 /*  2040 */   124,  124,  124,  124,  124,  124,  102,  103,  124,   11,
 /*  2050 */   106,  107,  108,  124,  110,  124,   18,  124,  124,  124,
 /*  2060 */   124,   23,   24,  124,  124,  124,  124,   29,   86,  124,
 /*  2070 */   124,   33,   90,   35,  124,   93,   94,  124,  124,   86,
 /*  2080 */   124,  124,  124,   90,  102,  103,   93,   94,  106,  107,
 /*  2090 */   108,  124,  110,  124,  124,  102,  103,  124,  124,  106,
 /*  2100 */   107,  108,  124,  110,   86,  124,  124,  124,   90,  124,
 /*  2110 */   124,   93,   94,  124,  124,  124,  124,   79,   80,   81,
 /*  2120 */   102,  103,  124,  124,  106,  107,  108,  124,  110,  124,
 /*  2130 */   124,  124,  124,   86,  124,  124,  124,   90,  124,  124,
 /*  2140 */    93,   94,  124,  124,  124,  124,   91,   92,  124,  102,
 /*  2150 */   103,  124,  124,  106,  107,  108,  101,  110,   86,  104,
 /*  2160 */   105,  124,   90,  124,  124,   93,   94,  124,  124,  124,
 /*  2170 */   124,  124,  124,  118,  102,  103,  124,   86,  106,  107,
 /*  2180 */   108,   90,  110,  124,   93,   94,  124,  124,   86,  124,
 /*  2190 */   124,  124,   90,  102,  103,   93,   94,  106,  107,  108,
 /*  2200 */   124,  110,  124,  124,  102,  103,  124,   86,  106,  107,
 /*  2210 */   108,   90,  110,  124,   93,   94,  124,  124,  124,  124,
 /*  2220 */    91,   92,  124,  102,  103,  124,  124,  106,  107,  108,
 /*  2230 */   101,  110,  124,  104,  105,  124,   86,  124,  124,  124,
 /*  2240 */    90,  124,  124,   93,   94,  124,  124,  118,  124,  124,
 /*  2250 */   124,  124,  102,  103,  124,  124,  106,  107,  108,  124,
 /*  2260 */   110,   86,  124,  124,  124,   90,  124,  124,   93,   94,
 /*  2270 */   124,  124,   86,  124,  124,  124,   90,  102,  103,   93,
 /*  2280 */    94,  106,  107,  108,  124,  110,  124,  124,  102,  103,
 /*  2290 */   124,   86,  106,  107,  108,   90,  110,  124,   93,   94,
 /*  2300 */   124,  124,   86,  124,  124,  124,   90,  102,  103,   93,
 /*  2310 */    94,  106,  107,  108,  124,  110,  124,  124,  102,  103,
 /*  2320 */   124,  124,  106,  107,  108,  124,  110,   86,  124,  124,
 /*  2330 */   124,   90,  124,  124,   93,   94,  124,  124,  124,  124,
 /*  2340 */   124,  124,  124,  102,  103,  124,  124,  106,  107,  108,
 /*  2350 */   124,  110,   86,  124,  124,  124,   90,  124,  124,   93,
 /*  2360 */    94,  124,  124,   86,  124,  124,  124,   90,  102,  103,
 /*  2370 */    93,   94,  106,  107,  108,  124,  110,  124,  124,  102,
 /*  2380 */   103,  124,   86,  106,  107,  108,   90,  110,  124,   93,
 /*  2390 */    94,  124,  124,  124,  124,  124,  124,  124,  102,  103,
 /*  2400 */   124,  124,  106,  107,  108,  124,  110,
);
    const YY_SHIFT_USE_DFLT = -53;
    const YY_SHIFT_MAX = 259;
    static public $yy_shift_ofst = array(
 /*     0 */    -3, 1213,  981, 1155, 1213, 1155,  981,  981,  923,  923,
 /*    10 */   865,  981,  981, 1097,  981,  981,  981,  981,  981,  981,
 /*    20 */   981, 1329,  981,  981,  981,  981, 1271,  981,  981,  981,
 /*    30 */  1097,  981,  981,  981,  981,  981,  981,  981,  981,  981,
 /*    40 */   981,  981,  981,  981, 1039, 1039, 1387, 1387, 1445, 1387,
 /*    50 */  1387, 1387, 1387,   -1,   53,  107,  107,  107,  107,  107,
 /*    60 */   485,  431,  593,  647,  701,  323,  161,  215,  377,  269,
 /*    70 */   539,  755,  755,  755,  755,  755,  755,  755,  755,  755,
 /*    80 */   755,  755,  755,  755,  755,  755,  755,  755,  755,  755,
 /*    90 */   797,  797, 1279,  110,  297,   -3, 2038,  977, 1034,  191,
 /*   100 */    -2,  191,   -2,  297,  297,  798,  340,  354,  367, 1911,
 /*   110 */   181,   54,   57,  163,  199,  285,   19,  151,  167,   70,
 /*   120 */    78,  381,  367,  543,  363,  -17,  375,  365,  363,  246,
 /*   130 */   363,  395,  392,  -17,  363,  363,  363,  367,  363,  445,
 /*   140 */   413,  363,  395,  363,  474,  365,  574,  204,  204,  574,
 /*   150 */   574,  574,  574,  574,  574,  574,  574,  -53,  255,  233,
 /*   160 */   -17,  -27,  -29,  -17,  -17,  -17,  -29,  -17,  -29,  -27,
 /*   170 */   -17,  -17,  -17,  -29,  -17,  -17,  -29,  -17,  -17,  -17,
 /*   180 */   -17,  -17,  -17,  -17,  -17,  -17,  -29,  -29,  -17,  343,
 /*   190 */   574,  574,  574,  596,  596,  574,  574,  204,  572,  572,
 /*   200 */   204,  341,  204,  370,  -53,  -53,  -53,  -53,  -53, 1483,
 /*   210 */  1342,   98,   76,  210,  435,  212,  328,  299,   81,  287,
 /*   220 */   472,  294,  217,  290,  292,  292,  370,  511,  455,  505,
 /*   230 */   520,  528,  478,  481,  541,  527,  446,   15,  114,  -14,
 /*   240 */   533,  130,  493,  497,  503,  523,  512,  525,  549,  551,
 /*   250 */   507,  526,  530,  516,  571,  137,  119,  -52,   69,  171,
);
    const YY_REDUCE_USE_DFLT = -73;
    const YY_REDUCE_MAX = 208;
    static public $yy_reduce_ofst = array(
 /*     0 */   -22, 1449, 1540, 1504, 1481, 1568, 1515, 1591, 1925, 2072,
 /*    10 */  1750, 1818, 1895, 1644, 1663, 1914, 2205, 2277, 1876, 1731,
 /*    20 */  1857, 1633, 1701, 2186, 2150, 2296, 2266, 2091, 2047, 1993,
 /*    30 */  2241, 2102, 1720, 1788, 1982, 1769, 1807, 1610, 1682, 2175,
 /*    40 */  2216, 2121, 1944, 2018,  805,  869,  884,  979,  925,  985,
 /*    50 */  1041, 1157, 1099, 1220, 1336, 2129, 1278, 1336, 1564, 2055,
 /*    60 */   190,  190,  190,  190,  190,  190,  190,  190,  190,  190,
 /*    70 */   190,  190,  190,  190,  190,  190,  190,  190,  190,  190,
 /*    80 */   190,  190,  190,  190,  190,  190,  190,  190,  190,  190,
 /*    90 */   190,  190,  261,  208,  153,  193,  154,  827,  826,  369,
 /*   100 */   804,  315,  872,  316,  424,  -34,  839,   82,  -72,  372,
 /*   110 */   349,  -32,  -32,  -32,  559,  351,  351,  351,  -32,   30,
 /*   120 */   -32,   30,  345,   30,  453,  420,  368,  242,  344,  -32,
 /*   130 */   276,  561,  451,  419,  506,  615,  668,  396,  613,  615,
 /*   140 */   350,  614,  615,  667,  615,  139,  -32,   30,  109,  -32,
 /*   150 */   -32,  -32,  -32,  -32,  -32,  -32,   23,  -32,  462,  482,
 /*   160 */   473,  466,  464,  473,  473,  473,  464,  473,  464,  468,
 /*   170 */   473,  473,  473,  464,  473,  473,  464,  473,  473,  473,
 /*   180 */   473,  473,  473,  473,  473,  473,  464,  464,  473,  489,
 /*   190 */   479,  479,  479,  480,  480,  479,  479,  189,  504,  499,
 /*   200 */   189,  241,  189,  348,  356,  393,  389,   95,  385,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 23, 24, 29, 33, 35, ),
        /* 1 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 2 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 3 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 4 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 5 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 6 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 7 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 8 */ array(18, 19, 20, 23, 24, 29, 33, 34, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 9 */ array(18, 19, 20, 23, 24, 29, 33, 34, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 10 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 66, 79, ),
        /* 11 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 12 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 13 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 14 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 15 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 16 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 17 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 18 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 19 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 20 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 21 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 22 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 23 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 24 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 25 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 26 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 27 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 28 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 29 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 30 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 31 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 32 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 33 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 34 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 35 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 36 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 37 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 38 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 39 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 40 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 41 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 42 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 43 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 44 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 45 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 65, 79, ),
        /* 46 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 79, ),
        /* 47 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 79, ),
        /* 48 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 79, ),
        /* 49 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 79, ),
        /* 50 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 79, ),
        /* 51 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 79, ),
        /* 52 */ array(18, 19, 20, 23, 24, 29, 33, 35, 37, 39, 42, 57, 58, 59, 60, 61, 64, 79, ),
        /* 53 */ array(1, 28, 30, 36, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 54 */ array(1, 3, 30, 36, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 55 */ array(1, 30, 36, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 56 */ array(1, 30, 36, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 57 */ array(1, 30, 36, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 58 */ array(1, 30, 36, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 59 */ array(1, 30, 36, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 60 */ array(1, 3, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 61 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 62 */ array(1, 25, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 63 */ array(1, 3, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 64 */ array(1, 3, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 65 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 66 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 80, ),
        /* 67 */ array(1, 31, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 68 */ array(1, 3, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 69 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 70 */ array(1, 2, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 71 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 72 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 73 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 74 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 75 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 76 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 77 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 78 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 79 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 80 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 81 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 82 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 83 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 84 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 85 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 86 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 87 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 88 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 89 */ array(1, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 90 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 91 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, ),
        /* 92 */ array(1, 3, 22, 30, 36, 39, 62, ),
        /* 93 */ array(1, 3, 30, 36, 55, ),
        /* 94 */ array(1, 30, 36, ),
        /* 95 */ array(4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 23, 24, 29, 33, 35, ),
        /* 96 */ array(11, 18, 23, 24, 29, 33, 35, 79, 80, 81, ),
        /* 97 */ array(18, 20, 30, 32, 36, ),
        /* 98 */ array(18, 20, 30, 32, 36, ),
        /* 99 */ array(1, 3, 30, 36, ),
        /* 100 */ array(18, 20, 30, 36, ),
        /* 101 */ array(1, 3, 30, 36, ),
        /* 102 */ array(18, 20, 30, 36, ),
        /* 103 */ array(1, 30, 36, ),
        /* 104 */ array(1, 30, 36, ),
        /* 105 */ array(22, 60, 65, ),
        /* 106 */ array(19, 20, 64, ),
        /* 107 */ array(1, 2, ),
        /* 108 */ array(19, 39, ),
        /* 109 */ array(11, 18, 23, 24, 29, 33, 35, 79, 80, 81, ),
        /* 110 */ array(5, 6, 7, 8, 9, 15, 16, 17, ),
        /* 111 */ array(1, 3, 30, 31, 36, 55, ),
        /* 112 */ array(1, 3, 30, 36, 55, ),
        /* 113 */ array(1, 3, 30, 36, 55, ),
        /* 114 */ array(18, 20, 21, 26, ),
        /* 115 */ array(18, 20, 21, 63, ),
        /* 116 */ array(18, 20, 63, ),
        /* 117 */ array(18, 20, 21, ),
        /* 118 */ array(1, 3, 55, ),
        /* 119 */ array(21, 22, 62, ),
        /* 120 */ array(1, 32, 55, ),
        /* 121 */ array(21, 22, 62, ),
        /* 122 */ array(19, 39, ),
        /* 123 */ array(22, 62, ),
        /* 124 */ array(18, 20, ),
        /* 125 */ array(30, 36, ),
        /* 126 */ array(30, 36, ),
        /* 127 */ array(19, 20, ),
        /* 128 */ array(18, 20, ),
        /* 129 */ array(1, 55, ),
        /* 130 */ array(18, 20, ),
        /* 131 */ array(18, 20, ),
        /* 132 */ array(18, 20, ),
        /* 133 */ array(30, 36, ),
        /* 134 */ array(18, 20, ),
        /* 135 */ array(18, 20, ),
        /* 136 */ array(18, 20, ),
        /* 137 */ array(19, 39, ),
        /* 138 */ array(18, 20, ),
        /* 139 */ array(18, 20, ),
        /* 140 */ array(1, 22, ),
        /* 141 */ array(18, 20, ),
        /* 142 */ array(18, 20, ),
        /* 143 */ array(18, 20, ),
        /* 144 */ array(18, 20, ),
        /* 145 */ array(19, 20, ),
        /* 146 */ array(1, ),
        /* 147 */ array(22, ),
        /* 148 */ array(22, ),
        /* 149 */ array(1, ),
        /* 150 */ array(1, ),
        /* 151 */ array(1, ),
        /* 152 */ array(1, ),
        /* 153 */ array(1, ),
        /* 154 */ array(1, ),
        /* 155 */ array(1, ),
        /* 156 */ array(1, ),
        /* 157 */ array(),
        /* 158 */ array(18, 19, 20, ),
        /* 159 */ array(18, 20, 63, ),
        /* 160 */ array(30, 36, ),
        /* 161 */ array(60, 65, ),
        /* 162 */ array(60, 65, ),
        /* 163 */ array(30, 36, ),
        /* 164 */ array(30, 36, ),
        /* 165 */ array(30, 36, ),
        /* 166 */ array(60, 65, ),
        /* 167 */ array(30, 36, ),
        /* 168 */ array(60, 65, ),
        /* 169 */ array(60, 65, ),
        /* 170 */ array(30, 36, ),
        /* 171 */ array(30, 36, ),
        /* 172 */ array(30, 36, ),
        /* 173 */ array(60, 65, ),
        /* 174 */ array(30, 36, ),
        /* 175 */ array(30, 36, ),
        /* 176 */ array(60, 65, ),
        /* 177 */ array(30, 36, ),
        /* 178 */ array(30, 36, ),
        /* 179 */ array(30, 36, ),
        /* 180 */ array(30, 36, ),
        /* 181 */ array(30, 36, ),
        /* 182 */ array(30, 36, ),
        /* 183 */ array(30, 36, ),
        /* 184 */ array(30, 36, ),
        /* 185 */ array(30, 36, ),
        /* 186 */ array(60, 65, ),
        /* 187 */ array(60, 65, ),
        /* 188 */ array(30, 36, ),
        /* 189 */ array(18, 39, ),
        /* 190 */ array(1, ),
        /* 191 */ array(1, ),
        /* 192 */ array(1, ),
        /* 193 */ array(2, ),
        /* 194 */ array(2, ),
        /* 195 */ array(1, ),
        /* 196 */ array(1, ),
        /* 197 */ array(22, ),
        /* 198 */ array(30, ),
        /* 199 */ array(30, ),
        /* 200 */ array(22, ),
        /* 201 */ array(16, ),
        /* 202 */ array(22, ),
        /* 203 */ array(39, ),
        /* 204 */ array(),
        /* 205 */ array(),
        /* 206 */ array(),
        /* 207 */ array(),
        /* 208 */ array(),
        /* 209 */ array(3, 25, 27, 28, 30, 31, 36, 38, 39, 40, 55, 62, 66, 80, ),
        /* 210 */ array(3, 21, 30, 36, 39, 62, ),
        /* 211 */ array(18, 19, 20, 37, ),
        /* 212 */ array(39, 60, 62, 66, ),
        /* 213 */ array(32, 39, 62, ),
        /* 214 */ array(2, 21, ),
        /* 215 */ array(38, 40, ),
        /* 216 */ array(21, 60, ),
        /* 217 */ array(3, 26, ),
        /* 218 */ array(38, 66, ),
        /* 219 */ array(20, 63, ),
        /* 220 */ array(25, 38, ),
        /* 221 */ array(38, 40, ),
        /* 222 */ array(26, 80, ),
        /* 223 */ array(38, 40, ),
        /* 224 */ array(39, 62, ),
        /* 225 */ array(39, 62, ),
        /* 226 */ array(39, ),
        /* 227 */ array(3, ),
        /* 228 */ array(64, ),
        /* 229 */ array(19, ),
        /* 230 */ array(3, ),
        /* 231 */ array(19, ),
        /* 232 */ array(40, ),
        /* 233 */ array(64, ),
        /* 234 */ array(27, ),
        /* 235 */ array(21, ),
        /* 236 */ array(20, ),
        /* 237 */ array(2, ),
        /* 238 */ array(20, ),
        /* 239 */ array(39, ),
        /* 240 */ array(37, ),
        /* 241 */ array(37, ),
        /* 242 */ array(20, ),
        /* 243 */ array(20, ),
        /* 244 */ array(19, ),
        /* 245 */ array(20, ),
        /* 246 */ array(3, ),
        /* 247 */ array(19, ),
        /* 248 */ array(20, ),
        /* 249 */ array(20, ),
        /* 250 */ array(60, ),
        /* 251 */ array(20, ),
        /* 252 */ array(20, ),
        /* 253 */ array(56, ),
        /* 254 */ array(2, ),
        /* 255 */ array(26, ),
        /* 256 */ array(20, ),
        /* 257 */ array(66, ),
        /* 258 */ array(19, ),
        /* 259 */ array(20, ),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
);
    static public $yy_default = array(
 /*     0 */   366,  551,  522,  568,  568,  568,  522,  522,  568,  568,
 /*    10 */   568,  568,  568,  568,  568,  568,  568,  568,  568,  568,
 /*    20 */   568,  568,  568,  568,  568,  568,  568,  568,  568,  568,
 /*    30 */   568,  568,  568,  568,  568,  568,  568,  568,  568,  568,
 /*    40 */   568,  568,  568,  568,  568,  568,  568,  568,  568,  568,
 /*    50 */   568,  568,  568,  428,  568,  405,  428,  428,  428,  397,
 /*    60 */   568,  568,  568,  568,  568,  568,  568,  433,  568,  568,
 /*    70 */   568,  553,  449,  520,  552,  457,  433,  452,  439,  462,
 /*    80 */   521,  461,  430,  435,  554,  438,  454,  453,  410,  458,
 /*    90 */   466,  465,  477,  441,  428,  363,  568,  428,  428,  485,
 /*   100 */   428,  448,  428,  428,  428,  534,  568,  419,  568,  568,
 /*   110 */   568,  441,  441,  441,  568,  495,  495,  495,  441,  486,
 /*   120 */   441,  486,  568,  486,  568,  428,  428,  568,  568,  441,
 /*   130 */   495,  568,  568,  407,  568,  568,  568,  568,  568,  568,
 /*   140 */   422,  568,  568,  568,  568,  568,  451,  486,  531,  464,
 /*   150 */   446,  445,  468,  444,  469,  470,  424,  529,  568,  496,
 /*   160 */   395,  489,  492,  412,  392,  406,  514,  409,  490,  491,
 /*   170 */   413,  394,  398,  513,  393,  408,  493,  400,  417,  402,
 /*   180 */   415,  404,  414,  418,  416,  403,  515,  512,  399,  495,
 /*   190 */   448,  420,  485,  523,  524,  423,  425,  532,  567,  567,
 /*   200 */   509,  383,  535,  495,  495,  528,  528,  528,  495,  443,
 /*   210 */   477,  568,  477,  477,  507,  568,  473,  467,  568,  568,
 /*   220 */   568,  568,  467,  568,  477,  463,  507,  568,  568,  568,
 /*   230 */   568,  568,  568,  568,  436,  568,  568,  507,  568,  533,
 /*   240 */   568,  475,  568,  568,  568,  568,  568,  568,  568,  568,
 /*   250 */   473,  568,  568,  479,  507,  467,  568,  568,  568,  568,
 /*   260 */   508,  429,  437,  364,  501,  519,  503,  440,  500,  479,
 /*   270 */   566,  516,  517,  502,  504,  518,  411,  530,  459,  506,
 /*   280 */   507,  527,  525,  427,  426,  388,  389,  390,  526,  471,
 /*   290 */   443,  487,  494,  497,  442,  482,  472,  474,  476,  387,
 /*   300 */   386,  371,  372,  373,  374,  370,  369,  365,  367,  368,
 /*   310 */   375,  376,  382,  384,  385,  381,  380,  377,  378,  379,
 /*   320 */   505,  498,  510,  421,  562,  555,  563,  447,  545,  546,
 /*   330 */   547,  556,  557,  558,  548,  550,  565,  564,  560,  559,
 /*   340 */   561,  544,  543,  450,  484,  488,  511,  483,  481,  499,
 /*   350 */   478,  480,  455,  456,  540,  541,  542,  539,  538,  460,
 /*   360 */   536,  537,  549,
);
    const YYNOCODE = 125;
    const YYSTACKDEPTH = 500;
    const YYNSTATE = 363;
    const YYNRULE = 205;
    const YYERRORSYMBOL = 82;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    public static $yyFallback = array(
    );
    public static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    public static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    public static $yyTraceFILE;
    public static $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array(
  '$',             'VERT',          'COLON',         'RDEL',        
  'COMMENT',       'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG', 
  'ASPENDTAG',     'FAKEPHPSTARTTAG',  'XMLTAG',        'TEXT',        
  'STRIPON',       'STRIPOFF',      'BLOCKSOURCE',   'LITERALSTART',
  'LITERALEND',    'LITERAL',       'LDEL',          'DOLLAR',      
  'ID',            'EQUAL',         'PTR',           'LDELIF',      
  'LDELFOR',       'SEMICOLON',     'INCDEC',        'TO',          
  'STEP',          'LDELFOREACH',   'SPACE',         'AS',          
  'APTR',          'LDELSETFILTER',  'SMARTYBLOCKCHILDPARENT',  'LDELSLASH',   
  'ATTR',          'INTEGER',       'COMMA',         'OPENP',       
  'CLOSEP',        'MATH',          'UNIMATH',       'ANDSYM',      
  'ISIN',          'ISDIVBY',       'ISNOTDIVBY',    'ISEVEN',      
  'ISNOTEVEN',     'ISEVENBY',      'ISNOTEVENBY',   'ISODD',       
  'ISNOTODD',      'ISODDBY',       'ISNOTODDBY',    'INSTANCEOF',  
  'QMARK',         'NOT',           'TYPECAST',      'HEX',         
  'DOT',           'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',          
  'HATCH',         'OPENB',         'CLOSEB',        'EQUALS',      
  'NOTEQUALS',     'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',
  'LESSEQUAL',     'IDENTITY',      'NONEIDENTITY',  'MOD',         
  'LAND',          'LOR',           'LXOR',          'QUOTE',       
  'BACKTICK',      'DOLLARID',      'error',         'start',       
  'template',      'template_element',  'smartytag',     'literal',     
  'literal_elements',  'literal_element',  'value',         'modifierlist',
  'attributes',    'expr',          'varindexed',    'statement',   
  'statements',    'optspace',      'varvar',        'foraction',   
  'modparameters',  'attribute',     'ternary',       'array',       
  'ifcond',        'lop',           'variable',      'function',    
  'doublequoted_with_quotes',  'static_class_access',  'object',        'arrayindex',  
  'indexdef',      'varvarele',     'objectchain',   'objectelement',
  'method',        'params',        'modifier',      'modparameter',
  'arrayelements',  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    public static $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag RDEL",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= TEXT",
 /*  14 */ "template_element ::= STRIPON",
 /*  15 */ "template_element ::= STRIPOFF",
 /*  16 */ "template_element ::= BLOCKSOURCE",
 /*  17 */ "literal ::= LITERALSTART LITERALEND",
 /*  18 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  19 */ "literal_elements ::= literal_elements literal_element",
 /*  20 */ "literal_elements ::=",
 /*  21 */ "literal_element ::= literal",
 /*  22 */ "literal_element ::= LITERAL",
 /*  23 */ "literal_element ::= PHPSTARTTAG",
 /*  24 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  25 */ "literal_element ::= PHPENDTAG",
 /*  26 */ "literal_element ::= ASPSTARTTAG",
 /*  27 */ "literal_element ::= ASPENDTAG",
 /*  28 */ "smartytag ::= LDEL value",
 /*  29 */ "smartytag ::= LDEL value modifierlist attributes",
 /*  30 */ "smartytag ::= LDEL value attributes",
 /*  31 */ "smartytag ::= LDEL expr modifierlist attributes",
 /*  32 */ "smartytag ::= LDEL expr attributes",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL value",
 /*  34 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr",
 /*  35 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes",
 /*  36 */ "smartytag ::= LDEL varindexed EQUAL expr attributes",
 /*  37 */ "smartytag ::= LDEL ID attributes",
 /*  38 */ "smartytag ::= LDEL ID",
 /*  39 */ "smartytag ::= LDEL ID PTR ID attributes",
 /*  40 */ "smartytag ::= LDEL ID modifierlist attributes",
 /*  41 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes",
 /*  42 */ "smartytag ::= LDELIF expr",
 /*  43 */ "smartytag ::= LDELIF expr attributes",
 /*  44 */ "smartytag ::= LDELIF statement",
 /*  45 */ "smartytag ::= LDELIF statement attributes",
 /*  46 */ "smartytag ::= LDELFOR statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction attributes",
 /*  47 */ "foraction ::= EQUAL expr",
 /*  48 */ "foraction ::= INCDEC",
 /*  49 */ "smartytag ::= LDELFOR statement TO expr attributes",
 /*  50 */ "smartytag ::= LDELFOR statement TO expr STEP expr attributes",
 /*  51 */ "smartytag ::= LDELFOREACH attributes",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar attributes",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar attributes",
 /*  54 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar attributes",
 /*  55 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar APTR DOLLAR varvar attributes",
 /*  56 */ "smartytag ::= LDELSETFILTER ID modparameters",
 /*  57 */ "smartytag ::= LDELSETFILTER ID modparameters modifierlist",
 /*  58 */ "smartytag ::= LDEL SMARTYBLOCKCHILDPARENT",
 /*  59 */ "smartytag ::= LDELSLASH ID",
 /*  60 */ "smartytag ::= LDELSLASH ID modifierlist",
 /*  61 */ "smartytag ::= LDELSLASH ID PTR ID",
 /*  62 */ "smartytag ::= LDELSLASH ID PTR ID modifierlist",
 /*  63 */ "attributes ::= attributes attribute",
 /*  64 */ "attributes ::= attribute",
 /*  65 */ "attributes ::=",
 /*  66 */ "attribute ::= SPACE ID EQUAL ID",
 /*  67 */ "attribute ::= ATTR expr",
 /*  68 */ "attribute ::= ATTR value",
 /*  69 */ "attribute ::= SPACE ID",
 /*  70 */ "attribute ::= SPACE expr",
 /*  71 */ "attribute ::= SPACE value",
 /*  72 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  73 */ "statements ::= statement",
 /*  74 */ "statements ::= statements COMMA statement",
 /*  75 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  76 */ "statement ::= varindexed EQUAL expr",
 /*  77 */ "statement ::= OPENP statement CLOSEP",
 /*  78 */ "expr ::= value",
 /*  79 */ "expr ::= ternary",
 /*  80 */ "expr ::= DOLLAR ID COLON ID",
 /*  81 */ "expr ::= expr MATH value",
 /*  82 */ "expr ::= expr UNIMATH value",
 /*  83 */ "expr ::= expr ANDSYM value",
 /*  84 */ "expr ::= array",
 /*  85 */ "expr ::= expr modifierlist",
 /*  86 */ "expr ::= expr ifcond expr",
 /*  87 */ "expr ::= expr ISIN array",
 /*  88 */ "expr ::= expr ISIN value",
 /*  89 */ "expr ::= expr lop expr",
 /*  90 */ "expr ::= expr ISDIVBY expr",
 /*  91 */ "expr ::= expr ISNOTDIVBY expr",
 /*  92 */ "expr ::= expr ISEVEN",
 /*  93 */ "expr ::= expr ISNOTEVEN",
 /*  94 */ "expr ::= expr ISEVENBY expr",
 /*  95 */ "expr ::= expr ISNOTEVENBY expr",
 /*  96 */ "expr ::= expr ISODD",
 /*  97 */ "expr ::= expr ISNOTODD",
 /*  98 */ "expr ::= expr ISODDBY expr",
 /*  99 */ "expr ::= expr ISNOTODDBY expr",
 /* 100 */ "expr ::= value INSTANCEOF ID",
 /* 101 */ "expr ::= value INSTANCEOF value",
 /* 102 */ "ternary ::= OPENP expr CLOSEP QMARK DOLLAR ID COLON expr",
 /* 103 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /* 104 */ "value ::= variable",
 /* 105 */ "value ::= UNIMATH value",
 /* 106 */ "value ::= NOT value",
 /* 107 */ "value ::= TYPECAST value",
 /* 108 */ "value ::= variable INCDEC",
 /* 109 */ "value ::= HEX",
 /* 110 */ "value ::= INTEGER",
 /* 111 */ "value ::= INTEGER DOT INTEGER",
 /* 112 */ "value ::= INTEGER DOT",
 /* 113 */ "value ::= DOT INTEGER",
 /* 114 */ "value ::= ID",
 /* 115 */ "value ::= function",
 /* 116 */ "value ::= OPENP expr CLOSEP",
 /* 117 */ "value ::= SINGLEQUOTESTRING",
 /* 118 */ "value ::= doublequoted_with_quotes",
 /* 119 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 120 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 121 */ "value ::= smartytag RDEL",
 /* 122 */ "value ::= value modifierlist",
 /* 123 */ "variable ::= varindexed",
 /* 124 */ "variable ::= DOLLAR varvar AT ID",
 /* 125 */ "variable ::= object",
 /* 126 */ "variable ::= HATCH ID HATCH",
 /* 127 */ "variable ::= HATCH ID HATCH arrayindex",
 /* 128 */ "variable ::= HATCH variable HATCH",
 /* 129 */ "variable ::= HATCH variable HATCH arrayindex",
 /* 130 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 131 */ "arrayindex ::= arrayindex indexdef",
 /* 132 */ "arrayindex ::=",
 /* 133 */ "indexdef ::= DOT DOLLAR varvar",
 /* 134 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 135 */ "indexdef ::= DOT ID",
 /* 136 */ "indexdef ::= DOT INTEGER",
 /* 137 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 138 */ "indexdef ::= OPENB ID CLOSEB",
 /* 139 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 140 */ "indexdef ::= OPENB expr CLOSEB",
 /* 141 */ "indexdef ::= OPENB CLOSEB",
 /* 142 */ "varvar ::= varvarele",
 /* 143 */ "varvar ::= varvar varvarele",
 /* 144 */ "varvarele ::= ID",
 /* 145 */ "varvarele ::= LDEL expr RDEL",
 /* 146 */ "object ::= varindexed objectchain",
 /* 147 */ "objectchain ::= objectelement",
 /* 148 */ "objectchain ::= objectchain objectelement",
 /* 149 */ "objectelement ::= PTR ID arrayindex",
 /* 150 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 151 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 152 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 153 */ "objectelement ::= PTR method",
 /* 154 */ "function ::= ID OPENP params CLOSEP",
 /* 155 */ "method ::= ID OPENP params CLOSEP",
 /* 156 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 157 */ "params ::= params COMMA expr",
 /* 158 */ "params ::= expr",
 /* 159 */ "params ::=",
 /* 160 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 161 */ "modifierlist ::= modifier modparameters",
 /* 162 */ "modifier ::= VERT AT ID",
 /* 163 */ "modifier ::= VERT ID",
 /* 164 */ "modparameters ::= modparameters modparameter",
 /* 165 */ "modparameters ::=",
 /* 166 */ "modparameter ::= COLON value",
 /* 167 */ "modparameter ::= COLON array",
 /* 168 */ "static_class_access ::= method",
 /* 169 */ "static_class_access ::= method objectchain",
 /* 170 */ "static_class_access ::= ID",
 /* 171 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 172 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 173 */ "ifcond ::= EQUALS",
 /* 174 */ "ifcond ::= NOTEQUALS",
 /* 175 */ "ifcond ::= GREATERTHAN",
 /* 176 */ "ifcond ::= LESSTHAN",
 /* 177 */ "ifcond ::= GREATEREQUAL",
 /* 178 */ "ifcond ::= LESSEQUAL",
 /* 179 */ "ifcond ::= IDENTITY",
 /* 180 */ "ifcond ::= NONEIDENTITY",
 /* 181 */ "ifcond ::= MOD",
 /* 182 */ "lop ::= LAND",
 /* 183 */ "lop ::= LOR",
 /* 184 */ "lop ::= LXOR",
 /* 185 */ "array ::= OPENB arrayelements CLOSEB",
 /* 186 */ "arrayelements ::= arrayelement",
 /* 187 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 188 */ "arrayelements ::=",
 /* 189 */ "arrayelement ::= value APTR expr",
 /* 190 */ "arrayelement ::= ID APTR expr",
 /* 191 */ "arrayelement ::= expr",
 /* 192 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 193 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 194 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 195 */ "doublequoted ::= doublequotedcontent",
 /* 196 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 197 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 198 */ "doublequotedcontent ::= DOLLARID",
 /* 199 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 200 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 201 */ "doublequotedcontent ::= smartytag RDEL",
 /* 202 */ "doublequotedcontent ::= TEXT",
 /* 203 */ "optspace ::= SPACE",
 /* 204 */ "optspace ::=",
    );

    public function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    public static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    public function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;

        return $yymajor;
    }

    public function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    public function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;

                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
    $this->yyidx = $yyidx;
    $this->yystack = $stack;

        return array_unique($expected);
    }

    public function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;

                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return true;
    }

   public function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }

                return $this->yy_find_shift_action($iFallback);
            }

            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    public function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    public function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 85 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1707 "smarty_internal_templateparser.php"

            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for ($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    public static $yyRuleInfo = array(
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 0 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 0 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 4 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 4 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 5 ),
  array( 'lhs' => 86, 'rhs' => 5 ),
  array( 'lhs' => 86, 'rhs' => 6 ),
  array( 'lhs' => 86, 'rhs' => 5 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 5 ),
  array( 'lhs' => 86, 'rhs' => 4 ),
  array( 'lhs' => 86, 'rhs' => 6 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 11 ),
  array( 'lhs' => 99, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 5 ),
  array( 'lhs' => 86, 'rhs' => 7 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 7 ),
  array( 'lhs' => 86, 'rhs' => 10 ),
  array( 'lhs' => 86, 'rhs' => 7 ),
  array( 'lhs' => 86, 'rhs' => 10 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 4 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 4 ),
  array( 'lhs' => 86, 'rhs' => 5 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 0 ),
  array( 'lhs' => 101, 'rhs' => 4 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 4 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 4 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 102, 'rhs' => 8 ),
  array( 'lhs' => 102, 'rhs' => 7 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 4 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 4 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 4 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 0 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 5 ),
  array( 'lhs' => 112, 'rhs' => 2 ),
  array( 'lhs' => 112, 'rhs' => 2 ),
  array( 'lhs' => 112, 'rhs' => 4 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 5 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 115, 'rhs' => 3 ),
  array( 'lhs' => 115, 'rhs' => 4 ),
  array( 'lhs' => 115, 'rhs' => 5 ),
  array( 'lhs' => 115, 'rhs' => 6 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 4 ),
  array( 'lhs' => 116, 'rhs' => 4 ),
  array( 'lhs' => 116, 'rhs' => 5 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 117, 'rhs' => 0 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 0 ),
  array( 'lhs' => 119, 'rhs' => 2 ),
  array( 'lhs' => 119, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 4 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 1 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 0 ),
  array( 'lhs' => 121, 'rhs' => 3 ),
  array( 'lhs' => 121, 'rhs' => 3 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 2 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 123, 'rhs' => 3 ),
  array( 'lhs' => 123, 'rhs' => 3 ),
  array( 'lhs' => 123, 'rhs' => 1 ),
  array( 'lhs' => 123, 'rhs' => 3 ),
  array( 'lhs' => 123, 'rhs' => 3 ),
  array( 'lhs' => 123, 'rhs' => 2 ),
  array( 'lhs' => 123, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 0 ),
    );

    public static $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        16 => 16,
        17 => 17,
        20 => 17,
        204 => 17,
        18 => 18,
        77 => 18,
        19 => 19,
        105 => 19,
        107 => 19,
        108 => 19,
        131 => 19,
        169 => 19,
        21 => 21,
        22 => 21,
        48 => 21,
        70 => 21,
        71 => 21,
        78 => 21,
        79 => 21,
        84 => 21,
        104 => 21,
        109 => 21,
        110 => 21,
        115 => 21,
        117 => 21,
        118 => 21,
        125 => 21,
        142 => 21,
        168 => 21,
        170 => 21,
        186 => 21,
        191 => 21,
        203 => 21,
        23 => 23,
        24 => 23,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 28,
        29 => 29,
        30 => 30,
        32 => 30,
        31 => 31,
        33 => 33,
        34 => 33,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        43 => 43,
        45 => 43,
        44 => 44,
        46 => 46,
        47 => 47,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        54 => 52,
        53 => 53,
        55 => 53,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        60 => 60,
        61 => 61,
        62 => 62,
        63 => 63,
        64 => 64,
        73 => 64,
        158 => 64,
        162 => 64,
        166 => 64,
        167 => 64,
        65 => 65,
        159 => 65,
        165 => 65,
        66 => 66,
        67 => 67,
        68 => 67,
        69 => 69,
        72 => 72,
        74 => 74,
        75 => 75,
        76 => 75,
        80 => 80,
        81 => 81,
        82 => 81,
        83 => 81,
        85 => 85,
        122 => 85,
        86 => 86,
        89 => 86,
        100 => 86,
        87 => 87,
        88 => 88,
        90 => 90,
        91 => 91,
        92 => 92,
        97 => 92,
        93 => 93,
        96 => 93,
        94 => 94,
        99 => 94,
        95 => 95,
        98 => 95,
        101 => 101,
        102 => 102,
        103 => 103,
        106 => 106,
        111 => 111,
        112 => 112,
        113 => 113,
        114 => 114,
        116 => 116,
        119 => 119,
        120 => 120,
        121 => 121,
        123 => 123,
        124 => 124,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        132 => 132,
        188 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        140 => 137,
        138 => 138,
        139 => 139,
        141 => 141,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        152 => 152,
        153 => 153,
        154 => 154,
        155 => 155,
        156 => 156,
        157 => 157,
        160 => 160,
        161 => 161,
        163 => 163,
        164 => 164,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        182 => 182,
        183 => 183,
        184 => 184,
        185 => 185,
        187 => 187,
        189 => 189,
        190 => 190,
        192 => 192,
        193 => 193,
        194 => 194,
        195 => 195,
        196 => 196,
        197 => 196,
        199 => 196,
        198 => 198,
        200 => 200,
        201 => 201,
        202 => 202,
    );
#line 96 "smarty_internal_templateparser.y"
    function yy_r0(){
    $this->_retvalue = $this->root_buffer->to_smarty_php();
    }
#line 2146 "smarty_internal_templateparser.php"
#line 104 "smarty_internal_templateparser.y"
    function yy_r1(){
    if ($this->yystack[$this->yyidx + 0]->minor != null) {
        $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);
    }
    }
#line 2153 "smarty_internal_templateparser.php"
#line 124 "smarty_internal_templateparser.y"
    function yy_r4(){
    if ($this->compiler->has_code) {
        $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
        $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + -1]->minor,true));
    } else { 
        $this->_retvalue = null;
    }  
    $this->compiler->has_variable_string = false;
    $this->block_nesting_level = count($this->compiler->_tag_stack);
    }
#line 2165 "smarty_internal_templateparser.php"
#line 136 "smarty_internal_templateparser.y"
    function yy_r5(){
    $this->_retvalue = null;
    }
#line 2170 "smarty_internal_templateparser.php"
#line 141 "smarty_internal_templateparser.y"
    function yy_r6(){
    $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 2175 "smarty_internal_templateparser.php"
#line 146 "smarty_internal_templateparser.y"
    function yy_r7(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if (!($this->smarty instanceof SmartyBC)) {
            $this->compiler->trigger_template_error (self::Err3);
        }
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<?php', true));
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        $this->_retvalue = null;
    }
    }
#line 2191 "smarty_internal_templateparser.php"
#line 162 "smarty_internal_templateparser.y"
    function yy_r8(){
    if ($this->is_xml) {
        $this->compiler->tag_nocache = true; 
        $this->is_xml = false;
        $save = $this->template->has_nocache_code; 
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '?>';?>\n", $this->compiler, true));
        $this->template->has_nocache_code = $save; 
    } elseif ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '?<?php ?>>');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars('?>', ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('?>', true));
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        $this->_retvalue = null;
    }
    }
#line 2210 "smarty_internal_templateparser.php"
#line 181 "smarty_internal_templateparser.y"
    function yy_r9(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if ($this->asp_tags) {
            if (!($this->smarty instanceof SmartyBC)) {
                $this->compiler->trigger_template_error (self::Err3);
            }
            $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<%', true));
        } else {
            $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
        }
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        if ($this->asp_tags) {
            $this->_retvalue = null;
        } else {
            $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
        }
    }
    }
#line 2234 "smarty_internal_templateparser.php"
#line 205 "smarty_internal_templateparser.y"
    function yy_r10(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars('%>', ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('%>', true));
        } else {
            $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
        }
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        if ($this->asp_tags) {
            $this->_retvalue = null;
        } else {
            $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
        }
    }
    }
#line 2255 "smarty_internal_templateparser.php"
#line 225 "smarty_internal_templateparser.y"
    function yy_r11(){
    if ($this->strip) {
        $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor))); 
    } else {
        $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));  
    }
    }
#line 2264 "smarty_internal_templateparser.php"
#line 234 "smarty_internal_templateparser.y"
    function yy_r12(){
    $this->compiler->tag_nocache = true;
    $this->is_xml = true; 
    $save = $this->template->has_nocache_code; 
    $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true));
    $this->template->has_nocache_code = $save;
    }
#line 2273 "smarty_internal_templateparser.php"
#line 243 "smarty_internal_templateparser.y"
    function yy_r13(){
        if ($this->strip) {
            $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));
        } else {
            $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
        }
    }
#line 2282 "smarty_internal_templateparser.php"
#line 252 "smarty_internal_templateparser.y"
    function yy_r14(){
    $this->strip = true;
    }
#line 2287 "smarty_internal_templateparser.php"
#line 256 "smarty_internal_templateparser.y"
    function yy_r15(){
    $this->strip = false;
    }
#line 2292 "smarty_internal_templateparser.php"
#line 260 "smarty_internal_templateparser.y"
    function yy_r16(){
        if ($this->strip) {
            SMARTY_INTERNAL_COMPILE_BLOCK::blockSource($this->compiler, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));
        } else {
            SMARTY_INTERNAL_COMPILE_BLOCK::blockSource($this->compiler, $this->yystack[$this->yyidx + 0]->minor);
        }
    }
#line 2301 "smarty_internal_templateparser.php"
#line 269 "smarty_internal_templateparser.y"
    function yy_r17(){
    $this->_retvalue = '';
    }
#line 2306 "smarty_internal_templateparser.php"
#line 273 "smarty_internal_templateparser.y"
    function yy_r18(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 2311 "smarty_internal_templateparser.php"
#line 277 "smarty_internal_templateparser.y"
    function yy_r19(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2316 "smarty_internal_templateparser.php"
#line 285 "smarty_internal_templateparser.y"
    function yy_r21(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2321 "smarty_internal_templateparser.php"
#line 293 "smarty_internal_templateparser.y"
    function yy_r23(){
    $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2326 "smarty_internal_templateparser.php"
#line 301 "smarty_internal_templateparser.y"
    function yy_r25(){
    $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2331 "smarty_internal_templateparser.php"
#line 305 "smarty_internal_templateparser.y"
    function yy_r26(){
    $this->_retvalue = '<<?php ?>%';
    }
#line 2336 "smarty_internal_templateparser.php"
#line 309 "smarty_internal_templateparser.y"
    function yy_r27(){
    $this->_retvalue = '%<?php ?>>';
    }
#line 2341 "smarty_internal_templateparser.php"
#line 318 "smarty_internal_templateparser.y"
    function yy_r28(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',array(),array('value'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2346 "smarty_internal_templateparser.php"
#line 322 "smarty_internal_templateparser.y"
    function yy_r29(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + 0]->minor,array('value'=>$this->yystack[$this->yyidx + -2]->minor, 'modifierlist'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2351 "smarty_internal_templateparser.php"
#line 326 "smarty_internal_templateparser.y"
    function yy_r30(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + 0]->minor,array('value'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2356 "smarty_internal_templateparser.php"
#line 330 "smarty_internal_templateparser.y"
    function yy_r31(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + 0]->minor,array('value'=>$this->yystack[$this->yyidx + -2]->minor,'modifierlist'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2361 "smarty_internal_templateparser.php"
#line 343 "smarty_internal_templateparser.y"
    function yy_r33(){
    $this->_retvalue = $this->compiler->compileTag('assign',array(array('value'=>$this->yystack[$this->yyidx + 0]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -2]->minor."'")));
    }
#line 2366 "smarty_internal_templateparser.php"
#line 351 "smarty_internal_templateparser.y"
    function yy_r35(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -1]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'")),$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2371 "smarty_internal_templateparser.php"
#line 355 "smarty_internal_templateparser.y"
    function yy_r36(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -1]->minor),array('var'=>$this->yystack[$this->yyidx + -3]->minor['var'])),$this->yystack[$this->yyidx + 0]->minor),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -3]->minor['smarty_internal_index']));
    }
#line 2376 "smarty_internal_templateparser.php"
#line 360 "smarty_internal_templateparser.y"
    function yy_r37(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2381 "smarty_internal_templateparser.php"
#line 364 "smarty_internal_templateparser.y"
    function yy_r38(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + 0]->minor,array());
    }
#line 2386 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r39(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + 0]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2391 "smarty_internal_templateparser.php"
#line 374 "smarty_internal_templateparser.y"
    function yy_r40(){
    $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + 0]->minor).'<?php echo ';
    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -1]->minor,'value'=>'ob_get_clean()')).'?>';
    }
#line 2397 "smarty_internal_templateparser.php"
#line 380 "smarty_internal_templateparser.y"
    function yy_r41(){
    $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + 0]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor)).'<?php echo ';
    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -1]->minor,'value'=>'ob_get_clean()')).'?>';
    }
#line 2403 "smarty_internal_templateparser.php"
#line 386 "smarty_internal_templateparser.y"
    function yy_r42(){
    $tag = trim(substr($this->yystack[$this->yyidx + -1]->minor,$this->lex->ldel_length)); 
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2409 "smarty_internal_templateparser.php"
#line 391 "smarty_internal_templateparser.y"
    function yy_r43(){
    $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + 0]->minor,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2415 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r44(){
    $tag = trim(substr($this->yystack[$this->yyidx + -1]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2421 "smarty_internal_templateparser.php"
#line 407 "smarty_internal_templateparser.y"
    function yy_r46(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('start'=>$this->yystack[$this->yyidx + -9]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -6]->minor),array('var'=>$this->yystack[$this->yyidx + -2]->minor),array('step'=>$this->yystack[$this->yyidx + -1]->minor))),1);
    }
#line 2426 "smarty_internal_templateparser.php"
#line 411 "smarty_internal_templateparser.y"
    function yy_r47(){
    $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2431 "smarty_internal_templateparser.php"
#line 419 "smarty_internal_templateparser.y"
    function yy_r49(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('start'=>$this->yystack[$this->yyidx + -3]->minor),array('to'=>$this->yystack[$this->yyidx + -1]->minor))),0);
    }
#line 2436 "smarty_internal_templateparser.php"
#line 423 "smarty_internal_templateparser.y"
    function yy_r50(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('start'=>$this->yystack[$this->yyidx + -5]->minor),array('to'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -1]->minor))),0);
    }
#line 2441 "smarty_internal_templateparser.php"
#line 428 "smarty_internal_templateparser.y"
    function yy_r51(){
    $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2446 "smarty_internal_templateparser.php"
#line 433 "smarty_internal_templateparser.y"
    function yy_r52(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('from'=>$this->yystack[$this->yyidx + -4]->minor),array('item'=>$this->yystack[$this->yyidx + -1]->minor))));
    }
#line 2451 "smarty_internal_templateparser.php"
#line 437 "smarty_internal_templateparser.y"
    function yy_r53(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('from'=>$this->yystack[$this->yyidx + -7]->minor),array('item'=>$this->yystack[$this->yyidx + -1]->minor),array('key'=>$this->yystack[$this->yyidx + -4]->minor))));
    }
#line 2456 "smarty_internal_templateparser.php"
#line 450 "smarty_internal_templateparser.y"
    function yy_r56(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array(array_merge(array($this->yystack[$this->yyidx + -1]->minor),$this->yystack[$this->yyidx + 0]->minor))));
    }
#line 2461 "smarty_internal_templateparser.php"
#line 454 "smarty_internal_templateparser.y"
    function yy_r57(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array_merge(array(array_merge(array($this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor)),$this->yystack[$this->yyidx + 0]->minor)));
    }
#line 2466 "smarty_internal_templateparser.php"
#line 459 "smarty_internal_templateparser.y"
    function yy_r58(){
    $j = strrpos($this->yystack[$this->yyidx + 0]->minor,'.');
    if ($this->yystack[$this->yyidx + 0]->minor[$j+1] == 'c') {
        // {$smarty.block.child}
        $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);
    } else {
        // {$smarty.block.parent}
        $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileParentBlock($this->compiler);
    }
    }
#line 2478 "smarty_internal_templateparser.php"
#line 472 "smarty_internal_templateparser.y"
    function yy_r59(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + 0]->minor.'close',array());
    }
#line 2483 "smarty_internal_templateparser.php"
#line 476 "smarty_internal_templateparser.y"
    function yy_r60(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array(),array('modifier_list'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2488 "smarty_internal_templateparser.php"
#line 481 "smarty_internal_templateparser.y"
    function yy_r61(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2493 "smarty_internal_templateparser.php"
#line 485 "smarty_internal_templateparser.y"
    function yy_r62(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor, 'modifier_list'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2498 "smarty_internal_templateparser.php"
#line 493 "smarty_internal_templateparser.y"
    function yy_r63(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2504 "smarty_internal_templateparser.php"
#line 499 "smarty_internal_templateparser.y"
    function yy_r64(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2509 "smarty_internal_templateparser.php"
#line 504 "smarty_internal_templateparser.y"
    function yy_r65(){
    $this->_retvalue = array();
    }
#line 2514 "smarty_internal_templateparser.php"
#line 509 "smarty_internal_templateparser.y"
    function yy_r66(){
    if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
    } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
    } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
    } else {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");
    }
    }
#line 2527 "smarty_internal_templateparser.php"
#line 521 "smarty_internal_templateparser.y"
    function yy_r67(){
    $this->_retvalue = array(trim($this->yystack[$this->yyidx + -1]->minor," =\n\r\t")=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2532 "smarty_internal_templateparser.php"
#line 529 "smarty_internal_templateparser.y"
    function yy_r69(){
    $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";
    }
#line 2537 "smarty_internal_templateparser.php"
#line 541 "smarty_internal_templateparser.y"
    function yy_r72(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2542 "smarty_internal_templateparser.php"
#line 554 "smarty_internal_templateparser.y"
    function yy_r74(){
    $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor;
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    }
#line 2548 "smarty_internal_templateparser.php"
#line 559 "smarty_internal_templateparser.y"
    function yy_r75(){
    $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2553 "smarty_internal_templateparser.php"
#line 587 "smarty_internal_templateparser.y"
    function yy_r80(){
    $this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';
    }
#line 2558 "smarty_internal_templateparser.php"
#line 592 "smarty_internal_templateparser.y"
    function yy_r81(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2563 "smarty_internal_templateparser.php"
#line 611 "smarty_internal_templateparser.y"
    function yy_r85(){
    $this->_retvalue = $this->compiler->compileTag('private_modifier',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor,'modifierlist'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2568 "smarty_internal_templateparser.php"
#line 617 "smarty_internal_templateparser.y"
    function yy_r86(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2573 "smarty_internal_templateparser.php"
#line 621 "smarty_internal_templateparser.y"
    function yy_r87(){
    $this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2578 "smarty_internal_templateparser.php"
#line 625 "smarty_internal_templateparser.y"
    function yy_r88(){
    $this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2583 "smarty_internal_templateparser.php"
#line 633 "smarty_internal_templateparser.y"
    function yy_r90(){
    $this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2588 "smarty_internal_templateparser.php"
#line 637 "smarty_internal_templateparser.y"
    function yy_r91(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2593 "smarty_internal_templateparser.php"
#line 641 "smarty_internal_templateparser.y"
    function yy_r92(){
    $this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2598 "smarty_internal_templateparser.php"
#line 645 "smarty_internal_templateparser.y"
    function yy_r93(){
    $this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2603 "smarty_internal_templateparser.php"
#line 649 "smarty_internal_templateparser.y"
    function yy_r94(){
    $this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2608 "smarty_internal_templateparser.php"
#line 653 "smarty_internal_templateparser.y"
    function yy_r95(){
    $this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2613 "smarty_internal_templateparser.php"
#line 677 "smarty_internal_templateparser.y"
    function yy_r101(){
    self::$prefix_number++;
    $this->compiler->prefix_code[] = '<?php $_tmp'.self::$prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>';
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.self::$prefix_number;
    }
#line 2620 "smarty_internal_templateparser.php"
#line 686 "smarty_internal_templateparser.y"
    function yy_r102(){
    $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.' ? '. $this->compileVariable("'".$this->yystack[$this->yyidx + -2]->minor."'") . ' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2625 "smarty_internal_templateparser.php"
#line 690 "smarty_internal_templateparser.y"
    function yy_r103(){
    $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2630 "smarty_internal_templateparser.php"
#line 705 "smarty_internal_templateparser.y"
    function yy_r106(){
    $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2635 "smarty_internal_templateparser.php"
#line 726 "smarty_internal_templateparser.y"
    function yy_r111(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2640 "smarty_internal_templateparser.php"
#line 730 "smarty_internal_templateparser.y"
    function yy_r112(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';
    }
#line 2645 "smarty_internal_templateparser.php"
#line 734 "smarty_internal_templateparser.y"
    function yy_r113(){
    $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2650 "smarty_internal_templateparser.php"
#line 739 "smarty_internal_templateparser.y"
    function yy_r114(){
    if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'true';
    } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'false';
    } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'null';
    } else {
        $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";
    }
    }
#line 2663 "smarty_internal_templateparser.php"
#line 757 "smarty_internal_templateparser.y"
    function yy_r116(){
    $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";
    }
#line 2668 "smarty_internal_templateparser.php"
#line 772 "smarty_internal_templateparser.y"
    function yy_r119(){
    if (!$this->security || isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor]) || $this->smarty->security_policy->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
        if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
            $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor;
        } else {
            $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;
        } 
    } else {
        $this->compiler->trigger_template_error ("static class '".$this->yystack[$this->yyidx + -2]->minor."' is undefined or not allowed by security setting");
    }
    }
#line 2681 "smarty_internal_templateparser.php"
#line 784 "smarty_internal_templateparser.y"
    function yy_r120(){
    if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') {
        $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + -2]->minor['var']).$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 2690 "smarty_internal_templateparser.php"
#line 793 "smarty_internal_templateparser.y"
    function yy_r121(){
    self::$prefix_number++;
    $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + -1]->minor.'<?php $_tmp'.self::$prefix_number.'=ob_get_clean();?>';
    $this->_retvalue = '$_tmp'.self::$prefix_number;
    }
#line 2697 "smarty_internal_templateparser.php"
#line 808 "smarty_internal_templateparser.y"
    function yy_r123(){
    if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') {
        $smarty_var = $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
        $this->_retvalue = $smarty_var;
    } else {
        // used for array reset,next,prev,end,current 
        $this->last_variable = $this->yystack[$this->yyidx + 0]->minor['var'];
        $this->last_index = $this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + 0]->minor['var']).$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
    }
    }
#line 2710 "smarty_internal_templateparser.php"
#line 821 "smarty_internal_templateparser.y"
    function yy_r124(){
    $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2715 "smarty_internal_templateparser.php"
#line 831 "smarty_internal_templateparser.y"
    function yy_r126(){
    $this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';
    }
#line 2720 "smarty_internal_templateparser.php"
#line 835 "smarty_internal_templateparser.y"
    function yy_r127(){
    $this->_retvalue = '(is_array($tmp = $_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'\')) ? $tmp'.$this->yystack[$this->yyidx + 0]->minor.' :null)';
    }
#line 2725 "smarty_internal_templateparser.php"
#line 839 "smarty_internal_templateparser.y"
    function yy_r128(){
    $this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';
    }
#line 2730 "smarty_internal_templateparser.php"
#line 843 "smarty_internal_templateparser.y"
    function yy_r129(){
    $this->_retvalue = '(is_array($tmp = $_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -2]->minor .')) ? $tmp'.$this->yystack[$this->yyidx + 0]->minor.' : null)';
    }
#line 2735 "smarty_internal_templateparser.php"
#line 847 "smarty_internal_templateparser.y"
    function yy_r130(){
    $this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2740 "smarty_internal_templateparser.php"
#line 860 "smarty_internal_templateparser.y"
    function yy_r132(){
    return;
    }
#line 2745 "smarty_internal_templateparser.php"
#line 866 "smarty_internal_templateparser.y"
    function yy_r133(){
    $this->_retvalue = '['.$this->compileVariable($this->yystack[$this->yyidx + 0]->minor).']';
    }
#line 2750 "smarty_internal_templateparser.php"
#line 870 "smarty_internal_templateparser.y"
    function yy_r134(){
    $this->_retvalue = '['.$this->compileVariable($this->yystack[$this->yyidx + -2]->minor).'->'.$this->yystack[$this->yyidx + 0]->minor.']';
    }
#line 2755 "smarty_internal_templateparser.php"
#line 874 "smarty_internal_templateparser.y"
    function yy_r135(){
    $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";
    }
#line 2760 "smarty_internal_templateparser.php"
#line 878 "smarty_internal_templateparser.y"
    function yy_r136(){
    $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";
    }
#line 2765 "smarty_internal_templateparser.php"
#line 882 "smarty_internal_templateparser.y"
    function yy_r137(){
    $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";
    }
#line 2770 "smarty_internal_templateparser.php"
#line 887 "smarty_internal_templateparser.y"
    function yy_r138(){
    $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';
    }
#line 2775 "smarty_internal_templateparser.php"
#line 891 "smarty_internal_templateparser.y"
    function yy_r139(){
    $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';
    }
#line 2780 "smarty_internal_templateparser.php"
#line 901 "smarty_internal_templateparser.y"
    function yy_r141(){
    $this->_retvalue = '[]';
    }
#line 2785 "smarty_internal_templateparser.php"
#line 914 "smarty_internal_templateparser.y"
    function yy_r143(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2790 "smarty_internal_templateparser.php"
#line 919 "smarty_internal_templateparser.y"
    function yy_r144(){
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';
    }
#line 2795 "smarty_internal_templateparser.php"
#line 924 "smarty_internal_templateparser.y"
    function yy_r145(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2800 "smarty_internal_templateparser.php"
#line 931 "smarty_internal_templateparser.y"
    function yy_r146(){
    if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') {
        $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + -1]->minor['var']).$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 2809 "smarty_internal_templateparser.php"
#line 940 "smarty_internal_templateparser.y"
    function yy_r147(){
    $this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2814 "smarty_internal_templateparser.php"
#line 945 "smarty_internal_templateparser.y"
    function yy_r148(){
    $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2819 "smarty_internal_templateparser.php"
#line 950 "smarty_internal_templateparser.y"
    function yy_r149(){
    if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '_') {
        $this->compiler->trigger_template_error (self::Err1);
    }
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2827 "smarty_internal_templateparser.php"
#line 957 "smarty_internal_templateparser.y"
    function yy_r150(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{'.$this->compileVariable($this->yystack[$this->yyidx + -1]->minor).$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2835 "smarty_internal_templateparser.php"
#line 964 "smarty_internal_templateparser.y"
    function yy_r151(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2843 "smarty_internal_templateparser.php"
#line 971 "smarty_internal_templateparser.y"
    function yy_r152(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2851 "smarty_internal_templateparser.php"
#line 979 "smarty_internal_templateparser.y"
    function yy_r153(){
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2856 "smarty_internal_templateparser.php"
#line 987 "smarty_internal_templateparser.y"
    function yy_r154(){
    if (!$this->security || $this->smarty->security_policy->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
        if (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'isset') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'empty') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'array') === 0 || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
            $func_name = strtolower($this->yystack[$this->yyidx + -3]->minor);
            if ($func_name == 'isset') {
                if (count($this->yystack[$this->yyidx + -1]->minor) == 0) {
                    $this->compiler->trigger_template_error ('Illegal number of paramer in "isset()"');
                }
                $par = implode(',',$this->yystack[$this->yyidx + -1]->minor);
                if (strncasecmp($par,'$_smarty_tpl->getConfigVariable',strlen('$_smarty_tpl->getConfigVariable')) === 0) {
                    self::$prefix_number++;
                    $this->compiler->prefix_code[] = '<?php $_tmp'.self::$prefix_number.'='.str_replace(')',', false)',$par).';?>';
                    $isset_par = '$_tmp'.self::$prefix_number;
                } else {
                    $isset_par=str_replace("')->value","',null,true,false)->value",$par);
                }
                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $isset_par .")";
            } elseif (in_array($func_name,array('empty','reset','current','end','prev','next'))){
                if (count($this->yystack[$this->yyidx + -1]->minor) != 1) {
                    $this->compiler->trigger_template_error ('Illegal number of paramer in "empty()"');
                }
                if ($func_name == 'empty') {
                    $this->_retvalue = $func_name.'('.str_replace("')->value","',null,true,false)->value",$this->yystack[$this->yyidx + -1]->minor[0]).')';
                } else {
                    $this->_retvalue = $func_name.'('.$this->yystack[$this->yyidx + -1]->minor[0].')';
                }
            } else {
                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
            }
        } else {
            $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
        }
    }
    }
#line 2892 "smarty_internal_templateparser.php"
#line 1025 "smarty_internal_templateparser.y"
    function yy_r155(){
    if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) == '_') {
        $this->compiler->trigger_template_error (self::Err1);
    }
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
    }
#line 2900 "smarty_internal_templateparser.php"
#line 1032 "smarty_internal_templateparser.y"
    function yy_r156(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    self::$prefix_number++;
    $this->compiler->prefix_code[] = '<?php $_tmp'.self::$prefix_number.'='.$this->compileVariable("'".$this->yystack[$this->yyidx + -3]->minor."'").';?>';
    $this->_retvalue = '$_tmp'.self::$prefix_number.'('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
    }
#line 2910 "smarty_internal_templateparser.php"
#line 1043 "smarty_internal_templateparser.y"
    function yy_r157(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + 0]->minor));
    }
#line 2915 "smarty_internal_templateparser.php"
#line 1060 "smarty_internal_templateparser.y"
    function yy_r160(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));
    }
#line 2920 "smarty_internal_templateparser.php"
#line 1064 "smarty_internal_templateparser.y"
    function yy_r161(){
    $this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2925 "smarty_internal_templateparser.php"
#line 1072 "smarty_internal_templateparser.y"
    function yy_r163(){
    $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2930 "smarty_internal_templateparser.php"
#line 1080 "smarty_internal_templateparser.y"
    function yy_r164(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2935 "smarty_internal_templateparser.php"
#line 1114 "smarty_internal_templateparser.y"
    function yy_r171(){
    $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2940 "smarty_internal_templateparser.php"
#line 1119 "smarty_internal_templateparser.y"
    function yy_r172(){
    $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2945 "smarty_internal_templateparser.php"
#line 1125 "smarty_internal_templateparser.y"
    function yy_r173(){
    $this->_retvalue = '==';
    }
#line 2950 "smarty_internal_templateparser.php"
#line 1129 "smarty_internal_templateparser.y"
    function yy_r174(){
    $this->_retvalue = '!=';
    }
#line 2955 "smarty_internal_templateparser.php"
#line 1133 "smarty_internal_templateparser.y"
    function yy_r175(){
    $this->_retvalue = '>';
    }
#line 2960 "smarty_internal_templateparser.php"
#line 1137 "smarty_internal_templateparser.y"
    function yy_r176(){
    $this->_retvalue = '<';
    }
#line 2965 "smarty_internal_templateparser.php"
#line 1141 "smarty_internal_templateparser.y"
    function yy_r177(){
    $this->_retvalue = '>=';
    }
#line 2970 "smarty_internal_templateparser.php"
#line 1145 "smarty_internal_templateparser.y"
    function yy_r178(){
    $this->_retvalue = '<=';
    }
#line 2975 "smarty_internal_templateparser.php"
#line 1149 "smarty_internal_templateparser.y"
    function yy_r179(){
    $this->_retvalue = '===';
    }
#line 2980 "smarty_internal_templateparser.php"
#line 1153 "smarty_internal_templateparser.y"
    function yy_r180(){
    $this->_retvalue = '!==';
    }
#line 2985 "smarty_internal_templateparser.php"
#line 1157 "smarty_internal_templateparser.y"
    function yy_r181(){
    $this->_retvalue = '%';
    }
#line 2990 "smarty_internal_templateparser.php"
#line 1161 "smarty_internal_templateparser.y"
    function yy_r182(){
    $this->_retvalue = '&&';
    }
#line 2995 "smarty_internal_templateparser.php"
#line 1165 "smarty_internal_templateparser.y"
    function yy_r183(){
    $this->_retvalue = '||';
    }
#line 3000 "smarty_internal_templateparser.php"
#line 1169 "smarty_internal_templateparser.y"
    function yy_r184(){
    $this->_retvalue = ' XOR ';
    }
#line 3005 "smarty_internal_templateparser.php"
#line 1176 "smarty_internal_templateparser.y"
    function yy_r185(){
    $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 3010 "smarty_internal_templateparser.php"
#line 1184 "smarty_internal_templateparser.y"
    function yy_r187(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3015 "smarty_internal_templateparser.php"
#line 1192 "smarty_internal_templateparser.y"
    function yy_r189(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3020 "smarty_internal_templateparser.php"
#line 1196 "smarty_internal_templateparser.y"
    function yy_r190(){ 
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3025 "smarty_internal_templateparser.php"
#line 1208 "smarty_internal_templateparser.y"
    function yy_r192(){
    $this->_retvalue = "''";
    }
#line 3030 "smarty_internal_templateparser.php"
#line 1212 "smarty_internal_templateparser.y"
    function yy_r193(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();
    }
#line 3035 "smarty_internal_templateparser.php"
#line 1217 "smarty_internal_templateparser.y"
    function yy_r194(){
    $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 3041 "smarty_internal_templateparser.php"
#line 1222 "smarty_internal_templateparser.y"
    function yy_r195(){
    $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3046 "smarty_internal_templateparser.php"
#line 1226 "smarty_internal_templateparser.y"
    function yy_r196(){
    $this->_retvalue = new _smarty_code($this, '(string)'.$this->yystack[$this->yyidx + -1]->minor);
    }
#line 3051 "smarty_internal_templateparser.php"
#line 1234 "smarty_internal_templateparser.y"
    function yy_r198(){
    $this->_retvalue = new _smarty_code($this, '(string)$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
    }
#line 3056 "smarty_internal_templateparser.php"
#line 1242 "smarty_internal_templateparser.y"
    function yy_r200(){
    $this->_retvalue = new _smarty_code($this, '(string)('.$this->yystack[$this->yyidx + -1]->minor.')');
    }
#line 3061 "smarty_internal_templateparser.php"
#line 1246 "smarty_internal_templateparser.y"
    function yy_r201(){
    $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 3066 "smarty_internal_templateparser.php"
#line 1250 "smarty_internal_templateparser.y"
    function yy_r202(){
    $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3071 "smarty_internal_templateparser.php"

    private $_retvalue;

    public function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for ($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    public function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        } while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    public function yy_syntax_error($yymajor, $TOKEN)
    {
#line 78 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 3133 "smarty_internal_templateparser.php"
    }

    public function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        } while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 70 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 3150 "smarty_internal_templateparser.php"
    }

    public function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);

        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit) {
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}