/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api.stream.support;

import org.red5.server.api.stream.IPlayItem;
import org.red5.server.messaging.IMessageInput;

public class DynamicPlayItem
implements IPlayItem {
    protected final String name;
    protected final long start;
    protected final long length;
    protected long size = -1L;
    protected double offset;
    protected IMessageInput msgInput;

    private DynamicPlayItem(String name, long start, long length) {
        this.name = name;
        this.start = start;
        this.length = length;
    }

    private DynamicPlayItem(String name, long start, long length, double offset) {
        this.name = name;
        this.start = start;
        this.length = length;
        this.offset = offset;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public IMessageInput getMessageInput() {
        return this.msgInput;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    public IMessageInput getMsgInput() {
        return this.msgInput;
    }

    public void setMsgInput(IMessageInput msgInput) {
        this.msgInput = msgInput;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicPlayItem other = (DynamicPlayItem)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return this.start == other.start;
    }

    public static DynamicPlayItem build(String name, long start, long length) {
        DynamicPlayItem playItem = new DynamicPlayItem(name, start, length);
        return playItem;
    }

    public static DynamicPlayItem build(String name, long start, long length, double offset) {
        DynamicPlayItem playItem = new DynamicPlayItem(name, start, length, offset);
        return playItem;
    }
}

