/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicInteger;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventListener;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.net.rtmp.message.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEvent
implements Constants,
IRTMPEvent,
Externalizable {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static final boolean allocationDebugging = false;
    private IEvent.Type type;
    protected byte sourceType;
    protected Object object;
    protected IEventListener source;
    protected int timestamp;
    protected Header header = null;
    protected AtomicInteger refcount = new AtomicInteger(1);

    public BaseEvent() {
        this(IEvent.Type.SERVER, null);
    }

    public BaseEvent(IEvent.Type type) {
        this(type, null);
    }

    public BaseEvent(IEvent.Type type, IEventListener source) {
        this.type = type;
        this.source = source;
    }

    @Override
    public IEvent.Type getType() {
        return this.type;
    }

    public void setType(IEvent.Type type) {
        this.type = type;
    }

    @Override
    public byte getSourceType() {
        return this.sourceType;
    }

    @Override
    public void setSourceType(byte sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(Header header) {
        this.header = header;
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    @Override
    public IEventListener getSource() {
        return this.source;
    }

    @Override
    public void setSource(IEventListener source) {
        this.source = source;
    }

    @Override
    public abstract byte getDataType();

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void retain() {
        int baseCount = this.refcount.getAndIncrement();
    }

    @Override
    public void release() {
        int baseCount = this.refcount.decrementAndGet();
        if (baseCount == 0) {
            this.releaseInternal();
        }
    }

    protected abstract void releaseInternal();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = IEvent.Type.valueOf(in.readUTF());
        this.sourceType = in.readByte();
        this.timestamp = in.readInt();
        if (this.log.isTraceEnabled()) {
            this.log.trace("readExternal - type: {} sourceType: {} timestamp: {}", new Object[]{this.type, this.sourceType, this.timestamp});
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("writeExternal - type: {} sourceType: {} timestamp: {}", new Object[]{this.type, this.sourceType, this.timestamp});
        }
        out.writeUTF(this.type.name());
        out.writeByte(this.sourceType);
        out.writeInt(this.timestamp);
    }
}

