/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.jmx.mxbeans.JDKSchedulingServiceMXBean;
import org.red5.server.scheduling.JDKSchedulingServiceJob;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(objectName="org.red5.server:name=schedulingService,type=JDKSchedulingService")
public class JDKSchedulingService
implements ISchedulingService,
JDKSchedulingServiceMXBean,
InitializingBean,
DisposableBean {
    private static Logger log = Red5LoggerFactory.getLogger(JDKSchedulingService.class);
    protected ScheduledExecutorService scheduler;
    protected int threadCount = Runtime.getRuntime().availableProcessors() * 2;
    protected ConcurrentMap<String, ScheduledFuture<?>> keyMap = new ConcurrentHashMap();
    protected AtomicInteger jobDetailCounter = new AtomicInteger();
    private boolean interruptOnRemove = true;

    public void afterPropertiesSet() throws Exception {
        log.debug("Initializing...");
        this.scheduler = Executors.newScheduledThreadPool(this.threadCount);
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    @Override
    public String addScheduledJob(int interval, IScheduledJob job) {
        String name = this.getJobName();
        HashMap<String, Object> jobData = new HashMap<String, Object>();
        jobData.put("scheduling_service", this);
        jobData.put("scheduled_job", job);
        JDKSchedulingServiceJob schedJob = new JDKSchedulingServiceJob(name, jobData, false);
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(schedJob, interval, interval, TimeUnit.MILLISECONDS);
        this.keyMap.put(name, future);
        return name;
    }

    @Override
    public String addScheduledOnceJob(Date date, IScheduledJob job) {
        String name = this.getJobName();
        HashMap<String, Object> jobData = new HashMap<String, Object>();
        jobData.put("scheduling_service", this);
        jobData.put("scheduled_job", job);
        JDKSchedulingServiceJob schedJob = new JDKSchedulingServiceJob(name, jobData);
        long delay = date.getTime() - System.currentTimeMillis();
        ScheduledFuture<?> future = this.scheduler.schedule(schedJob, delay, TimeUnit.MILLISECONDS);
        this.keyMap.put(name, future);
        return name;
    }

    @Override
    public String addScheduledOnceJob(long timeDelta, IScheduledJob job) {
        String name = this.getJobName();
        HashMap<String, Object> jobData = new HashMap<String, Object>();
        jobData.put("scheduling_service", this);
        jobData.put("scheduled_job", job);
        JDKSchedulingServiceJob schedJob = new JDKSchedulingServiceJob(name, jobData);
        ScheduledFuture<?> future = this.scheduler.schedule(schedJob, timeDelta, TimeUnit.MILLISECONDS);
        this.keyMap.put(name, future);
        return name;
    }

    @Override
    public String addScheduledJobAfterDelay(int interval, IScheduledJob job, int delay) {
        String name = this.getJobName();
        HashMap<String, Object> jobData = new HashMap<String, Object>();
        jobData.put("scheduling_service", this);
        jobData.put("scheduled_job", job);
        JDKSchedulingServiceJob schedJob = new JDKSchedulingServiceJob(name, jobData, false);
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(schedJob, delay, interval, TimeUnit.MILLISECONDS);
        this.keyMap.put(name, future);
        return name;
    }

    @Override
    public String getJobName() {
        return String.format("ScheduledJob_%d", this.jobDetailCounter.getAndIncrement());
    }

    @Override
    public List<String> getScheduledJobNames() {
        if (this.scheduler != null) {
            return new ArrayList<String>(this.keyMap.keySet());
        }
        log.warn("No scheduler is available");
        return Collections.emptyList();
    }

    @Override
    public void pauseScheduledJob(String name) {
        throw new RuntimeException("Pause is not supported for ScheduledFuture");
    }

    @Override
    public void resumeScheduledJob(String name) {
        throw new RuntimeException("Pause/resume is not supported for ScheduledFuture");
    }

    @Override
    public void removeScheduledJob(String name) {
        try {
            ScheduledFuture future = (ScheduledFuture)this.keyMap.remove(name);
            if (future != null && !future.isDone()) {
                future.cancel(this.interruptOnRemove);
            } else {
                log.debug("No key found for job: {} or the job was done", (Object)name);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void destroy() throws Exception {
        if (this.scheduler != null) {
            log.debug("Destroying...");
            this.scheduler.shutdownNow();
        }
        this.keyMap.clear();
    }

    public boolean isInterruptOnRemove() {
        return this.interruptOnRemove;
    }

    public void setInterruptOnRemove(boolean interruptOnRemove) {
        this.interruptOnRemove = interruptOnRemove;
    }
}

