/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AbstractAudio;
import org.red5.codec.AudioCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AACAudio
extends AbstractAudio {
    private static Logger log = LoggerFactory.getLogger(AACAudio.class);
    public static final int[] AAC_SAMPLERATES = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
    static final String CODEC_NAME = "AAC";
    private byte[] blockDataAACDCR;

    public AACAudio() {
        this.reset();
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public void reset() {
        this.blockDataAACDCR = null;
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        if (data.limit() == 0) {
            return false;
        }
        byte first = data.get();
        boolean result = (first & 0xF0) >> 4 == AudioCodec.AAC.getId();
        data.rewind();
        return result;
    }

    @Override
    public boolean addData(IoBuffer data) {
        if (data.hasRemaining()) {
            int start = data.position();
            data.rewind();
            byte frameType = data.get();
            log.trace("Frame type: {}", (Object)frameType);
            byte header = data.get();
            if (this.blockDataAACDCR == null && (frameType & 0xF0) >> 4 == AudioCodec.AAC.getId() && header == 0) {
                data.rewind();
                this.blockDataAACDCR = new byte[data.remaining()];
                data.get(this.blockDataAACDCR);
            }
            data.position(start);
        }
        return true;
    }

    @Override
    public IoBuffer getDecoderConfiguration() {
        if (this.blockDataAACDCR == null) {
            return null;
        }
        IoBuffer result = IoBuffer.allocate((int)4);
        result.setAutoExpand(true);
        result.put(this.blockDataAACDCR);
        result.rewind();
        return result;
    }

    private static long sample2TC(long time, int sampleRate) {
        return time * 1000L / (long)sampleRate;
    }
}

