/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

public final class LEB128 {
    public static final int SEVEN_LSB_BITMASK = 127;
    public static final int MSB_BITMASK = 128;

    public static int encode(int value) {
        int out = 0;
        while (true) {
            out |= value & 0x7F;
            if ((value >>= 7) == 0) break;
            out |= 0x80;
            out <<= 8;
        }
        return out;
    }

    public static int decode(int value) {
        int out = 0;
        while (true) {
            out |= value & 0x7F;
            if ((value >>= 8) == 0) break;
            out <<= 7;
        }
        return out;
    }

    public static void main(String[] args) {
        int[][] testData = new int[][]{{0, 0}, {5, 5}, {999999, 12551229}};
        for (int i = 0; i < testData.length; ++i) {
            int encoded = LEB128.encode(testData[i][0]);
            if (encoded != testData[i][1]) {
                System.out.printf("Encode failed: %d expected %d%n", encoded, testData[i][1]);
            } else {
                System.out.printf("Encode success: %d decoded: %d%n", encoded, testData[i][0]);
            }
            int decoded = LEB128.decode(encoded);
            if (decoded != testData[i][0]) {
                System.out.printf("Decode failed: %d expected %d%n", decoded, testData[i][0]);
                continue;
            }
            System.out.printf("Decode success: %d encoded: %d%n", decoded, testData[i][1]);
        }
    }
}

