/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AbstractAudio;
import org.red5.codec.AudioCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpusAudio
extends AbstractAudio {
    private static Logger log = LoggerFactory.getLogger(OpusAudio.class);
    public static final int[] OPUS_SAMPLERATES = new int[]{48000, 24000, 16000, 12000, 8000};
    static final String CODEC_NAME = "Opus";
    private int index = 0;
    private int channels = 2;
    private volatile boolean needConfig;

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        if (data.limit() == 0) {
            return false;
        }
        byte first = data.get();
        boolean result = (first & 0xF0) >> 4 == AudioCodec.OPUS.getId();
        data.rewind();
        return result;
    }

    @Override
    public boolean addData(IoBuffer data, int timestamp, boolean amf) {
        log.trace("addData timestamp: {} remaining: {} amf? {}", new Object[]{timestamp, data.remaining(), amf});
        if (data.hasRemaining()) {
            int start = data.position();
            if (!amf) {
                int remaining = data.remaining();
                IoBuffer slice = data.getSlice(start, remaining);
                data.put((byte)(AudioCodec.OPUS.getId() << 4));
                if (this.needConfig) {
                    data.expand(remaining + 4);
                    data.put(new byte[]{0, (byte)OPUS_SAMPLERATES[this.index], (byte)this.channels});
                    this.needConfig = false;
                } else {
                    data.expand(remaining + 2);
                    data.put((byte)1);
                }
                data.put(slice);
                data.flip();
                start = data.position();
                data.position(start);
            }
        }
        return true;
    }

    @Override
    public IoBuffer getDecoderConfiguration() {
        return IoBuffer.wrap((byte[])new byte[]{(byte)OPUS_SAMPLERATES[this.index], (byte)this.channels});
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public boolean isNeedConfig() {
        return this.needConfig;
    }

    public void setNeedConfig(boolean needConfig) {
        this.needConfig = needConfig;
    }
}

