/*
 * Decompiled with CFR 0.152.
 */
package org.red5.media.processor;

import java.io.File;
import java.util.Arrays;
import org.red5.io.ITag;
import org.red5.io.flv.impl.FLVReader;
import org.red5.media.processor.IPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericWriterPostProcessor
implements IPostProcessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private File file;

    @Override
    public void init(Object ... objs) {
        this.log.info("init: {}", (Object)Arrays.toString(objs));
        this.file = new File(objs[0].toString());
    }

    @Override
    public void run() {
        if (this.file != null) {
            try {
                FLVReader reader = new FLVReader(this.file);
                ITag tag = null;
                int audio = 0;
                int video = 0;
                int meta = 0;
                while (reader.hasMoreTags()) {
                    tag = reader.readTag();
                    if (tag == null) continue;
                    switch (tag.getDataType()) {
                        case 8: {
                            ++audio;
                            break;
                        }
                        case 9: {
                            ++video;
                            break;
                        }
                        case 18: {
                            ++meta;
                        }
                    }
                }
                reader.close();
                this.log.info("Data type counts - audio: {} video: {} metadata: {}", new Object[]{audio, video, meta});
            }
            catch (Exception e) {
                this.log.error("Exception reading: {}", (Object)this.file.getName(), (Object)e);
            }
        } else {
            this.log.warn("File for parsing was not found");
        }
    }
}

