/*
 * Decompiled with CFR 0.152.
 */
package org.red5.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Red5LoggerFactory {
    public static final String LOGGER_CONTEXT_ATTRIBUTE = "logger.context";
    private static boolean useLogback = true;
    public static boolean DEBUG = true;

    public static Logger getLogger(Class<?> clazz) {
        if (DEBUG) {
            System.out.printf("getLogger for: %s thread: %s%n", clazz.getName(), Thread.currentThread().getName());
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            System.out.printf("class loader: %s%n", cl);
        }
        Logger logger = null;
        if (useLogback) {
            String contextName = "default";
            String[] parts = Thread.currentThread().getName().split("Loader:/");
            if (parts.length > 1) {
                contextName = parts[1];
            }
            logger = Red5LoggerFactory.getLogger(clazz, contextName);
        }
        if (logger == null) {
            logger = LoggerFactory.getLogger(clazz);
        }
        return logger;
    }

    public static Logger getLogger(Class clazz, String contextName) {
        return Red5LoggerFactory.getLogger(clazz.getName(), contextName);
    }

    public static Logger getLogger(String name, String contextName) {
        if (DEBUG) {
            System.out.printf("getLogger for: %s in context: %s thread: %s%n", name, contextName, Thread.currentThread().getName());
        }
        Logger logger = null;
        if (useLogback) {
            if (contextName == null) {
                contextName = "default";
            }
            try {
                ContextSelector selector = Red5LoggerFactory.getContextSelector();
                LoggerContext context = selector.getLoggerContext(contextName);
                if (context == null) {
                    System.err.printf("No context named %s was found!!%n", contextName);
                }
                if (context != null) {
                    logger = context.getLogger(name);
                }
            }
            catch (Exception e) {
                System.err.printf("Exception %s%n", e.getMessage());
                e.printStackTrace();
            }
        }
        if (logger == null) {
            logger = LoggerFactory.getLogger((String)name);
        }
        return logger;
    }

    public static ContextSelector getContextSelector() {
        if (useLogback) {
            ContextSelectorStaticBinder contextSelectorBinder = ContextSelectorStaticBinder.getSingleton();
            ContextSelector selector = contextSelectorBinder.getContextSelector();
            if (selector == null) {
                if (DEBUG) {
                    System.err.println("Context selector was null, creating default context");
                }
                LoggerContext defaultLoggerContext = new LoggerContext();
                defaultLoggerContext.setName("default");
                try {
                    contextSelectorBinder.init(defaultLoggerContext, null);
                    selector = contextSelectorBinder.getContextSelector();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return selector;
        }
        return null;
    }

    public static void setUseLogback(boolean useLogback) {
        Red5LoggerFactory.useLogback = useLogback;
    }

    static {
        DEBUG = Boolean.valueOf(System.getProperty("logback.debug", "false"));
        try {
            Logger logger = LoggerFactory.getILoggerFactory().getLogger("ROOT");
            logger.debug("Red5LoggerFactory instanced by Thread: {}", (Object)Thread.currentThread().getName());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

