/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.messaging;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.red5.server.messaging.AbstractPipe;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IProvider;

public class PipeConnectionEvent
extends EventObject {
    private static final long serialVersionUID = 9078843765378168072L;
    private final transient IProvider provider;
    private final transient IConsumer consumer;
    private final EventType type;
    private final ConcurrentMap<String, Object> paramMap = new ConcurrentHashMap<String, Object>();
    private final LinkedList<Runnable> taskList = new LinkedList();

    private PipeConnectionEvent(AbstractPipe source, EventType type, IConsumer consumer, Map<String, Object> paramMap) {
        super(source);
        this.type = type;
        this.consumer = consumer;
        this.provider = null;
        this.setParamMap(paramMap);
    }

    private PipeConnectionEvent(AbstractPipe source, EventType type, IProvider provider, Map<String, Object> paramMap) {
        super(source);
        this.type = type;
        this.consumer = null;
        this.provider = provider;
        this.setParamMap(paramMap);
    }

    public IProvider getProvider() {
        return this.provider;
    }

    public IConsumer getConsumer() {
        return this.consumer;
    }

    public EventType getType() {
        return this.type;
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(Map<String, Object> paramMap) {
        if (paramMap != null && !paramMap.isEmpty()) {
            this.paramMap.putAll(paramMap);
        }
    }

    public void addTask(Runnable task) {
        this.taskList.add(task);
    }

    List<Runnable> getTaskList() {
        return this.taskList;
    }

    public static final PipeConnectionEvent build(AbstractPipe source, EventType type, IConsumer consumer, Map<String, Object> paramMap) {
        return new PipeConnectionEvent(source, type, consumer, paramMap);
    }

    public static final PipeConnectionEvent build(AbstractPipe source, EventType type, IProvider provider, Map<String, Object> paramMap) {
        return new PipeConnectionEvent(source, type, provider, paramMap);
    }

    public static enum EventType {
        PROVIDER_CONNECT_PULL,
        PROVIDER_CONNECT_PUSH,
        PROVIDER_DISCONNECT,
        CONSUMER_CONNECT_PULL,
        CONSUMER_CONNECT_PUSH,
        CONSUMER_DISCONNECT;

    }
}

