/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.red5.io.utils.ConversionUtils;
import org.red5.server.api.IConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Object[] nullReturn = new Object[]{null, null};

    public static Object[] findMethodWithExactParameters(Object service, String methodName, List<?> args) {
        Object[] arguments = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            arguments[i] = args.get(i);
        }
        return ReflectionUtils.findMethodWithExactParameters(service, methodName, arguments);
    }

    public static Object[] findMethodWithExactParameters(Object service, String methodName, Object[] args) {
        int numParams = args == null ? 0 : args.length;
        log.trace("Args / parameters count: {}", (Object)numParams);
        Method method = null;
        Object[] params = ConversionUtils.convertParams((Object[])args);
        if (log.isDebugEnabled()) {
            for (Class clazz : params) {
                log.debug("Parameter: {}", (Object)clazz);
            }
        }
        try {
            method = service.getClass().getMethod(methodName, (Class<?>[])params);
            log.debug("Exact method found, skipping list: {}", (Object)methodName);
            return new Object[]{method, args};
        }
        catch (NoSuchMethodException nsme) {
            int i;
            log.debug("Method not found using exact parameter types");
            List methods = ConversionUtils.findMethodsByNameAndNumParams((Object)service, (String)methodName, (int)numParams);
            log.debug("Found {} methods", (Object)methods.size());
            if (methods.isEmpty()) {
                return new Object[]{null, null};
            }
            if (methods.size() == 1 && args == null) {
                return new Object[]{methods.get(0), null};
            }
            if (methods.size() > 1) {
                log.debug("Multiple methods found with same name and parameter count; parameter conversion will be attempted in order.");
            }
            for (i = 0; i < methods.size(); ++i) {
                method = (Method)methods.get(i);
                boolean valid = true;
                Class<?>[] classArray = method.getParameterTypes();
                for (int j = 0; j < args.length; ++j) {
                    if ((args[j] != null || !classArray[j].isPrimitive()) && (args[j] == null || args[j].getClass().equals(classArray[j]))) continue;
                    valid = false;
                    break;
                }
                if (!valid) continue;
                return new Object[]{method, args};
            }
            for (i = 0; i < methods.size(); ++i) {
                try {
                    method = (Method)methods.get(i);
                    params = ConversionUtils.convertParams((Object[])args, (Class[])method.getParameterTypes());
                    if (args.length > 0 && args[0] instanceof IConnection && !(params[0] instanceof IConnection)) continue;
                    return new Object[]{method, params};
                }
                catch (Exception ex) {
                    log.debug("Parameter conversion failed for {}", (Object)method);
                }
            }
            return new Object[]{null, null};
        }
    }

    public static Object[] findMethodWithListParameters(Object service, String methodName, List<?> args) {
        Object[] arguments = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            arguments[i] = args.get(i);
        }
        return ReflectionUtils.findMethodWithListParameters(service, methodName, arguments);
    }

    public static Object[] findMethodWithListParameters(Object service, String methodName, Object[] args) {
        Method method = null;
        try {
            method = service.getClass().getMethod(methodName, ConversionUtils.convertParams((Object[])args));
            log.debug("Exact method found (skipping list): {}", (Object)methodName);
            return new Object[]{method, args};
        }
        catch (NoSuchMethodException nsme) {
            log.debug("Method not found using exact parameter types");
            List methods = ConversionUtils.findMethodsByNameAndNumParams((Object)service, (String)methodName, (int)1);
            log.debug("Found {} methods", (Object)methods.size());
            if (methods.isEmpty()) {
                return new Object[]{null, null};
            }
            if (methods.size() > 1) {
                log.debug("Multiple methods found with same name and parameter count; parameter conversion will be attempted in order.");
            }
            ArrayList<Object> argsList = new ArrayList<Object>();
            if (args != null) {
                for (Object element : args) {
                    argsList.add(element);
                }
            }
            args = new Object[]{argsList};
            Object[] params = null;
            for (int i = 0; i < methods.size(); ++i) {
                try {
                    method = (Method)methods.get(i);
                    params = ConversionUtils.convertParams((Object[])args, (Class[])method.getParameterTypes());
                    if (argsList.size() > 0 && argsList.get(0) instanceof IConnection && !(params[0] instanceof IConnection)) continue;
                    return new Object[]{method, params};
                }
                catch (Exception ex) {
                    log.debug("Parameter conversion failed", (Throwable)ex);
                }
            }
            return nullReturn;
        }
    }
}

