/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.consumer;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.red5.codec.VideoCodec;
import org.red5.io.ITag;
import org.red5.io.ITagWriter;
import org.red5.io.flv.impl.FLVWriter;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.server.api.stream.consumer.IFileConsumer;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.stream.DefaultStreamFilenameGenerator;
import org.red5.server.stream.IStreamData;
import org.red5.server.stream.consumer.ImmutableTag;
import org.red5.server.stream.consumer.QueuedMediaData;
import org.red5.server.stream.consumer.QueuedMediaDataComparator;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.ResetMessage;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class FileConsumer
implements Constants,
IPushableConsumer,
IPipeConnectionListener,
DisposableBean,
IFileConsumer {
    private static final Logger log = LoggerFactory.getLogger(FileConsumer.class);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private ExecutorService executor = Executors.newFixedThreadPool(1);
    private static QueuedMediaDataComparator comparator = new QueuedMediaDataComparator();
    private BlockingQueue<QueuedMediaData> queue;
    private IScope scope;
    private Path path;
    private ITagWriter writer;
    private String mode = "none";
    private int startTimestamp = -1;
    private ITag videoConfigurationTag;
    private ITag audioConfigurationTag;
    private volatile Future<?> writerFuture;
    private volatile boolean gotKeyFrame = false;
    private int queueThreshold = 240;
    private boolean waitForVideoKeyframe = true;
    private boolean usePriority = true;
    private long offerTimeout = 100L;

    public FileConsumer() {
    }

    public FileConsumer(IScope scope, File file) {
        this();
        this.scope = scope;
        this.path = file.toPath();
    }

    public FileConsumer(IScope scope, String fileName, String mode) {
        this();
        this.scope = scope;
        this.mode = mode;
        this.setupOutputPath(fileName);
    }

    @Override
    public void pushMessage(IPipe pipe, IMessage message) throws IOException {
        if (message instanceof RTMPMessage) {
            IRTMPEvent msg = ((RTMPMessage)message).getBody();
            if (this.queue == null) {
                if (this.usePriority) {
                    if (log.isTraceEnabled()) {
                        log.trace("Creating priority typed packet queue. queueThreshold={}", (Object)this.queueThreshold);
                    }
                    this.queue = new PriorityBlockingQueue<QueuedMediaData>(this.queueThreshold <= 0 ? 240 : this.queueThreshold, comparator);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("Creating non-priority typed packet queue");
                    }
                    this.queue = new LinkedBlockingQueue<QueuedMediaData>();
                }
            }
            if (msg instanceof IStreamData) {
                byte dataType = msg.getDataType();
                int timestamp = msg.getTimestamp();
                if (log.isTraceEnabled()) {
                    log.trace("Stream data, body saved, timestamp: {} data type: {} class type: {}", new Object[]{timestamp, dataType, msg.getClass().getName()});
                }
                if (this.startTimestamp == -1) {
                    this.startTimestamp = timestamp;
                    timestamp = 0;
                } else {
                    timestamp -= this.startTimestamp;
                }
                try {
                    QueuedMediaData queued = new QueuedMediaData(timestamp, dataType, (IStreamData)((Object)msg));
                    if (log.isTraceEnabled()) {
                        log.trace("Inserting packet into queue. timestamp: {} queue size: {}, codecId={}, isConfig={}", new Object[]{timestamp, this.queue.size(), queued.codecId, queued.config});
                    }
                    if (this.queue.size() > this.queueThreshold && this.queue.size() % 20 == 0) {
                        log.warn("Queue size is greater than threshold. queue size={} threshold={}", (Object)this.queue.size(), (Object)this.queueThreshold);
                    }
                    if (this.queue.size() < 2 * this.queueThreshold) {
                        this.queue.offer(queued, this.offerTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException e) {
                    log.warn("Stream data was not accepted by the queue - timestamp: {} data type: {}", new Object[]{timestamp, dataType, e});
                }
            }
            if (this.writer == null) {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("ProFileConsumer-" + FileConsumer.this.path.getFileName());
                        try {
                            if (log.isTraceEnabled()) {
                                log.trace("Running FileConsumer thread. queue size: {} initialized: {} writerNotNull={}", new Object[]{FileConsumer.this.queue.size(), FileConsumer.this.initialized, FileConsumer.this.writer != null});
                            }
                            FileConsumer.this.init();
                            while (FileConsumer.this.writer != null) {
                                if (log.isTraceEnabled()) {
                                    log.trace("Processing packet from queue. queue size: {}", (Object)FileConsumer.this.queue.size());
                                }
                                try {
                                    QueuedMediaData queued = FileConsumer.this.queue.take();
                                    if (queued != null) {
                                        byte dataType = queued.getDataType();
                                        int timestamp = queued.getTimestamp();
                                        ImmutableTag tag = queued.getData();
                                        if (queued.isVideo()) {
                                            if (log.isTraceEnabled()) {
                                                log.trace("pushMessage video - waitForKeyframe: {} gotKeyframe: {} timestamp: {}", new Object[]{FileConsumer.this.waitForVideoKeyframe, FileConsumer.this.gotKeyFrame, queued.getTimestamp()});
                                            }
                                            if (queued.codecId == VideoCodec.AVC.getId()) {
                                                if (queued.isConfig()) {
                                                    FileConsumer.this.videoConfigurationTag = tag;
                                                    FileConsumer.this.gotKeyFrame = true;
                                                }
                                                if (FileConsumer.this.videoConfigurationTag == null && FileConsumer.this.waitForVideoKeyframe) {
                                                    continue;
                                                }
                                            } else {
                                                if (queued.frameType == VideoData.FrameType.KEYFRAME) {
                                                    FileConsumer.this.gotKeyFrame = true;
                                                }
                                                if (FileConsumer.this.waitForVideoKeyframe && !FileConsumer.this.gotKeyFrame) {
                                                    continue;
                                                }
                                            }
                                        } else if (queued.isAudio() && queued.isConfig()) {
                                            FileConsumer.this.audioConfigurationTag = tag;
                                        }
                                        if (queued.isVideo() && log.isTraceEnabled()) {
                                            log.trace("Writing packet. frameType={} timestamp={}", (Object)queued.frameType, (Object)queued.getTimestamp());
                                        }
                                        FileConsumer.this.write(dataType, timestamp, tag);
                                        queued.dispose();
                                        continue;
                                    }
                                    if (!log.isTraceEnabled()) continue;
                                    log.trace("Queued media is null. queue size: {}", (Object)FileConsumer.this.queue.size());
                                }
                                catch (InterruptedException e) {
                                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                                }
                            }
                        }
                        catch (IOException e) {
                            log.warn("{}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                });
            }
        } else if (message instanceof ResetMessage) {
            this.startTimestamp = -1;
        } else if (log.isDebugEnabled()) {
            log.debug("Ignoring pushed message: {}", (Object)message);
        }
    }

    @Override
    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
    }

    @Override
    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case CONSUMER_CONNECT_PUSH: {
                Map<String, Object> paramMap;
                if (event.getConsumer() != this || (paramMap = event.getParamMap()) == null) break;
                this.mode = (String)paramMap.get("mode");
            }
        }
    }

    private void init() throws IOException {
        if (this.initialized.compareAndSet(false, true)) {
            log.debug("Init: {}", (Object)this.mode);
            if (this.path != null) {
                if (log.isDebugEnabled()) {
                    Path parent = this.path.getParent();
                    log.debug("Parent abs: {} dir: {}", (Object)parent.isAbsolute(), (Object)Files.isDirectory(parent, new LinkOption[0]));
                }
                if ("append".equals(this.mode)) {
                    if (Files.notExists(this.path, new LinkOption[0])) {
                        throw new IOException("File to be appended doesnt exist, verify the record mode");
                    }
                    log.debug("Path: {}\nRead: {} write: {} size: {}", new Object[]{this.path, Files.isReadable(this.path), Files.isWritable(this.path), Files.size(this.path)});
                    this.writer = new FLVWriter(this.path, true);
                } else if ("record".equals(this.mode)) {
                    try {
                        if (Files.deleteIfExists(this.path)) {
                            log.debug("File deleted");
                        }
                        Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                        this.path = Files.createFile(this.path, new FileAttribute[0]);
                    }
                    catch (IOException ioe) {
                        log.error("File creation error: {}", (Throwable)ioe);
                    }
                    if (!Files.isWritable(this.path)) {
                        throw new IOException("File is not writable");
                    }
                    log.debug("Path: {}\nRead: {} write: {}", new Object[]{this.path, Files.isReadable(this.path), Files.isWritable(this.path)});
                    this.writer = new FLVWriter(this.path, false);
                } else {
                    try {
                        if (Files.deleteIfExists(this.path)) {
                            log.debug("File deleted");
                        }
                    }
                    catch (IOException ioe) {
                        log.error("File creation error: {}", (Throwable)ioe);
                    }
                }
            } else {
                log.warn("Consumer is uninitialized");
            }
            log.debug("Init - complete");
        }
    }

    public void uninit() {
        if (this.initialized.get()) {
            log.debug("Uninit");
            if (this.writer != null) {
                if (this.writerFuture != null) {
                    try {
                        this.writerFuture.get();
                    }
                    catch (Exception e) {
                        log.warn("Exception waiting for write result on uninit", (Throwable)e);
                    }
                    if (this.writerFuture.cancel(false)) {
                        log.debug("Future completed");
                    }
                }
                this.writerFuture = null;
                this.queue.clear();
                this.queue = null;
                this.writer.close();
                this.writer = null;
            }
            this.path = null;
        }
    }

    private final void write(byte dataType, int timestamp, ITag tag) {
        block7: {
            if (tag != null && (tag.getBodySize() > 0 || dataType == 8)) {
                try {
                    if (timestamp >= 0) {
                        if (!this.writer.writeTag(tag)) {
                            log.warn("Tag was not written");
                        }
                    } else {
                        log.warn("Skipping message with negative timestamp");
                    }
                }
                catch (ClosedChannelException cce) {
                    log.error("The writer is no longer able to write to the file: {} writable: {}", (Object)this.path.getFileName(), (Object)this.path.toFile().canWrite());
                }
                catch (IOException e) {
                    log.warn("Error writing tag", (Throwable)e);
                    if (!(e.getCause() instanceof ClosedChannelException)) break block7;
                    log.error("The writer is no longer able to write to the file: {} writable: {}", (Object)this.path.getFileName(), (Object)this.path.toFile().canWrite());
                }
            }
        }
    }

    public void setupOutputPath(String name) {
        IStreamFilenameGenerator generator = (IStreamFilenameGenerator)ScopeUtils.getScopeService(this.scope, IStreamFilenameGenerator.class, DefaultStreamFilenameGenerator.class);
        String filePath = generator.generateFilename(this.scope, name, ".flv", IStreamFilenameGenerator.GenerationType.RECORD);
        this.path = generator.resolvesToAbsolutePath() ? Paths.get(filePath, new String[0]) : Paths.get(System.getProperty("red5.root"), "webapps", this.scope.getContextPath(), filePath);
        File appendee = this.getFile();
        if ("append".equals(this.mode) && !appendee.exists()) {
            try {
                if (appendee.createNewFile()) {
                    log.debug("New file created for appending");
                } else {
                    log.debug("Failure to create new file for appending");
                }
            }
            catch (IOException e) {
                log.warn("Exception creating replacement file for append", (Throwable)e);
            }
        }
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public void setFile(File file) {
        this.path = file.toPath();
    }

    public File getFile() {
        return this.path.toFile();
    }

    public void setQueueThreshold(int queueThreshold) {
        this.queueThreshold = queueThreshold;
    }

    @Deprecated
    public void setDelayWrite(boolean delayWrite) {
    }

    public void setWaitForVideoKeyframe(boolean waitForVideoKeyframe) {
        log.debug("setWaitForVideoKeyframe: {}", (Object)waitForVideoKeyframe);
        this.waitForVideoKeyframe = waitForVideoKeyframe;
    }

    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    public void setOfferTimeout(long offerTimeout) {
        this.offerTimeout = offerTimeout;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public void setAudioDecoderConfiguration(IRTMPEvent audioConfig) {
    }

    @Override
    public void setVideoDecoderConfiguration(IRTMPEvent videoConfig) {
    }

    public void destroy() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

