/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.red5.classloading.ClassLoaderBuilder;

public class Bootstrap {
    public static void main(String[] args) throws Exception {
        try {
            Bootstrap.getConfigurationRoot(Bootstrap.getRed5Root());
            Bootstrap.bootStrap();
            System.out.println("Bootstrap complete");
        }
        catch (Throwable t) {
            System.out.printf("Bootstrap exception: %s%n", t.getMessage());
            t.printStackTrace();
        }
        finally {
            System.out.println("Bootstrap exit");
        }
    }

    private static void bootStrap() throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String os;
        System.setProperty("red5.deployment.type", "bootstrap");
        System.setProperty("sun.lang.ClassLoader.allowArraySyntax", "true");
        String policyFile = System.getProperty("java.security.policy");
        if (policyFile == null) {
            System.setProperty("java.security.debug", "all");
            System.setProperty("java.security.policy", String.format("%s/red5.policy", System.getProperty("red5.config_root")));
        }
        if ((os = System.getProperty("os.name").toLowerCase()).contains("vista") || os.contains("windows 7")) {
            Object dir = System.getProperty("user.home");
            if (((String)dir).length() == 3) {
                File f = new File((String)(dir = (String)dir + "Users\\Default\\AppData\\Red5"));
                if (!f.exists()) {
                    f.mkdir();
                }
                f = null;
            } else {
                dir = (String)dir + "\\AppData\\localLow";
            }
            System.setProperty("java.io.tmpdir", (String)dir);
            System.out.printf("Setting temp directory to %s%n", System.getProperty("java.io.tmpdir"));
        }
        ClassLoader baseLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = ClassLoaderBuilder.build();
        Thread.currentThread().setContextClassLoader(loader);
        Object boot = Class.forName("org.red5.server.Launcher", true, loader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method m1 = boot.getClass().getMethod("launch", null);
        m1.invoke(boot, (Object[])null);
        Thread.currentThread().setContextClassLoader(baseLoader);
    }

    static Path getConfigurationRoot(Path root) {
        Path confDir = null;
        String conf = System.getProperty("red5.config_root");
        confDir = conf != null ? Paths.get(conf, new String[0]) : root.resolve("conf");
        System.setProperty("red5.config_root", confDir.toAbsolutePath().toString());
        System.out.printf("Configuation root: %s%n", System.getProperty("red5.config_root"));
        return confDir;
    }

    static Path getRed5Root() throws IOException {
        String root = System.getProperty("red5.root", System.getenv("RED5_HOME"));
        if (root == null) {
            root = System.getProperty("user.dir");
        }
        Path rootDir = Paths.get(root, new String[0]);
        System.setProperty("red5.root", rootDir.toAbsolutePath().toString());
        System.out.printf("Red5 root: %s%n", System.getProperty("red5.root"));
        return rootDir;
    }
}

