/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.apache.mina.core.buffer.IoBuffer;
import org.bouncycastle.util.BigIntegers;
import org.red5.server.api.Red5;
import org.red5.server.net.rtmp.RTMPHandshake;

public class InboundHandshake
extends RTMPHandshake {
    private byte[] s1;
    private byte[] c1;
    private int digestPosServer;
    private boolean unvalidatedConnectionAllowed;

    public InboundHandshake() {
        super((byte)3);
    }

    public InboundHandshake(byte handshakeType) {
        super(handshakeType);
    }

    public InboundHandshake(byte handshakeType, int algorithm) {
        this(handshakeType);
        this.algorithm = algorithm;
    }

    @Override
    public IoBuffer doHandshake(IoBuffer in) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("doHandshake: {}", (Object)in);
        }
        return this.decodeClientRequest1(in);
    }

    public IoBuffer decodeClientRequest1(IoBuffer in) {
        if (this.log.isTraceEnabled()) {
            this.log.debug("decodeClientRequest1: {}", (Object)Hex.encodeHexString(in.array()));
        }
        this.c1 = new byte[1536];
        in.get(this.c1);
        this.s1 = new byte[1536];
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flash player version {}", (Object)Hex.encodeHexString(Arrays.copyOfRange(this.c1, 4, 8)));
        }
        boolean bl = this.fp9Handshake = (this.c1[4] & 0xFF) != 0;
        if (!this.fp9Handshake) {
            return this.generateUnversionedHandshake(this.c1);
        }
        if (this.log.isTraceEnabled()) {
            this.log.debug("Server handshake bytes: {}", (Object)Hex.encodeHexString(this.handshakeBytes));
        }
        if (this.useEncryption()) {
            this.algorithm = 1;
            int clientDHOffset = this.getDHOffset(this.algorithm, this.c1, 0);
            this.log.trace("Incoming DH offset: {}", (Object)clientDHOffset);
            this.outgoingPublicKey = new byte[128];
            System.arraycopy(this.c1, clientDHOffset, this.outgoingPublicKey, 0, 128);
            this.log.debug("Client public key: {}", (Object)Hex.encodeHexString(this.outgoingPublicKey));
            int serverDHOffset = this.getDHOffset(this.algorithm, this.handshakeBytes, 0);
            this.log.trace("Outgoing DH offset: {}", (Object)serverDHOffset);
            KeyPair keys = this.generateKeyPair();
            this.incomingPublicKey = this.getPublicKey(keys);
            this.log.debug("Server public key: {}", (Object)Hex.encodeHexString(this.incomingPublicKey));
            System.arraycopy(this.incomingPublicKey, 0, this.handshakeBytes, serverDHOffset, 128);
            this.initRC4Encryption(this.getSharedSecret(this.outgoingPublicKey, this.keyAgreement));
        }
        this.digestPosServer = this.getDigestOffset(this.algorithm, this.handshakeBytes, 0);
        this.log.debug("Server digest position offset: {} algorithm: {}", (Object)this.digestPosServer, (Object)this.algorithm);
        System.arraycopy(this.handshakeBytes, 0, this.s1, 0, 1536);
        this.calculateDigest(this.digestPosServer, this.handshakeBytes, 0, GENUINE_FMS_KEY, 36, this.s1, this.digestPosServer);
        this.log.debug("Server digest: {}", (Object)Hex.encodeHexString(Arrays.copyOfRange(this.s1, this.digestPosServer, this.digestPosServer + 32)));
        this.log.trace("Trying algorithm: {}", (Object)this.algorithm);
        int digestPosClient = this.getDigestOffset(this.algorithm, this.c1, 0);
        this.log.debug("Client digest position offset: {}", (Object)digestPosClient);
        if (!this.verifyDigest(digestPosClient, this.c1, GENUINE_FP_KEY, 30)) {
            this.algorithm ^= 1;
            this.log.trace("Trying algorithm: {}", (Object)this.algorithm);
            digestPosClient = this.getDigestOffset(this.algorithm, this.c1, 0);
            this.log.debug("Client digest position offset: {}", (Object)digestPosClient);
            if (!this.verifyDigest(digestPosClient, this.c1, GENUINE_FP_KEY, 30)) {
                this.log.warn("Client digest verification failed");
                return null;
            }
        }
        this.log.debug("Client digest: {}", (Object)Hex.encodeHexString(Arrays.copyOfRange(this.c1, digestPosClient, digestPosClient + 32)));
        if (this.swfSize > 0) {
            byte[] swfHash = new byte[32];
            this.calculateSwfVerification(this.s1, swfHash, this.swfSize);
            this.log.debug("Swf digest: {}", (Object)Hex.encodeHexString(swfHash));
        }
        byte[] digestResp = new byte[32];
        byte[] signatureResponse = new byte[32];
        this.calculateHMAC_SHA256(this.c1, digestPosClient, 32, GENUINE_FMS_KEY, GENUINE_FMS_KEY.length, digestResp, 0);
        this.log.debug("Digest response (key): {}", (Object)Hex.encodeHexString(digestResp));
        this.calculateHMAC_SHA256(this.c1, 0, 1504, digestResp, 32, signatureResponse, 0);
        this.log.debug("Signature response: {}", (Object)Hex.encodeHexString(signatureResponse));
        if (this.useEncryption()) {
            switch (this.handshakeType) {
                case 6: {
                    this.log.debug("RTMPE type 6");
                    break;
                }
                case 8: {
                    int i;
                    this.log.debug("RTMPE type 8 XTEA");
                    for (i = 0; i < 32; i += 8) {
                        this.encryptXtea(signatureResponse, i, digestResp[i] % 15);
                    }
                    break;
                }
                case 9: {
                    int i;
                    this.log.debug("RTMPE type 9 Blowfish");
                    for (i = 0; i < 32; i += 8) {
                        this.encryptBlowfish(signatureResponse, i, digestResp[i] % 15);
                    }
                    break;
                }
            }
        }
        System.arraycopy(signatureResponse, 0, this.c1, 1504, 32);
        IoBuffer s0s1s2 = IoBuffer.allocate(3073);
        s0s1s2.put(this.handshakeType);
        s0s1s2.put(this.s1);
        s0s1s2.put(this.c1);
        s0s1s2.flip();
        this.handshakeBytes = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace("S0+S1+S2 size: {}", (Object)s0s1s2.limit());
        }
        return s0s1s2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeClientRequest2(IoBuffer in) {
        if (this.log.isTraceEnabled()) {
            this.log.debug("decodeClientRequest2: {}", (Object)Hex.encodeHexString(in.array()));
        }
        byte[] c2 = new byte[1536];
        in.get(c2);
        if (this.fp9Handshake) {
            byte[] digest = new byte[32];
            byte[] signature = new byte[32];
            this.log.debug("Client sent signature: {}", (Object)Hex.encodeHexString(Arrays.copyOfRange(c2, 1504, 1536)));
            this.calculateHMAC_SHA256(this.s1, this.digestPosServer, 32, GENUINE_FP_KEY, GENUINE_FP_KEY.length, digest, 0);
            this.calculateHMAC_SHA256(c2, 0, 1504, digest, 32, signature, 0);
            if (this.useEncryption()) {
                switch (this.handshakeType) {
                    case 6: {
                        this.log.debug("RTMPE type 6");
                        break;
                    }
                    case 8: {
                        int i;
                        this.log.debug("RTMPE type 8 XTEA");
                        for (i = 0; i < 32; i += 8) {
                            this.encryptXtea(signature, i, digest[i] % 15);
                        }
                        break;
                    }
                    case 9: {
                        int i;
                        this.log.debug("RTMPE type 9 Blowfish");
                        for (i = 0; i < 32; i += 8) {
                            this.encryptBlowfish(signature, i, digest[i] % 15);
                        }
                        break;
                    }
                }
                byte[] dummyBytes = new byte[1536];
                this.cipherIn.update(dummyBytes);
                this.cipherOut.update(dummyBytes);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Digest key: {}", (Object)Hex.encodeHexString(digest));
                this.log.debug("Signature calculated: {}", (Object)Hex.encodeHexString(signature));
            }
            byte[] sentSignature = Arrays.copyOfRange(c2, 1504, 1536);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Client sent signature: {}", (Object)Hex.encodeHexString(sentSignature));
            }
            if (!Arrays.equals(signature, sentSignature)) {
                this.log.warn("Client not compatible");
                if (!this.unvalidatedConnectionAllowed) return false;
                this.log.debug("Unvalidated client allowed to proceed");
                return true;
            } else {
                this.log.debug("Compatible client, handshake complete");
            }
            return true;
        } else {
            if (Arrays.equals(this.s1, c2)) return true;
            this.log.info("Client signature doesn't match!");
        }
        return true;
    }

    private IoBuffer generateUnversionedHandshake(byte[] input) {
        this.log.debug("Using old style (un-versioned) handshake");
        IoBuffer output = IoBuffer.allocate(3073);
        output.put((byte)3);
        output.putInt((int)Red5.getUpTime() / 1000);
        output.position(1537);
        output.put(input);
        output.flip();
        output.mark();
        output.position(1);
        output.get(this.s1);
        output.reset();
        return output;
    }

    @Override
    protected void createHandshakeBytes() {
        this.handshakeBytes = new byte[1536];
        int time = (int)(Red5.getUpTime() / 1000L);
        this.handshakeBytes[0] = (byte)(time >>> 24);
        this.handshakeBytes[1] = (byte)(time >>> 16);
        this.handshakeBytes[2] = (byte)(time >>> 8);
        this.handshakeBytes[3] = (byte)time;
        this.handshakeBytes[4] = 4;
        this.handshakeBytes[5] = 0;
        this.handshakeBytes[6] = 0;
        this.handshakeBytes[7] = 1;
        int randomHandshakeLength = 1528;
        BigInteger bi = new BigInteger(randomHandshakeLength * 8, random);
        byte[] rndBytes = BigIntegers.asUnsignedByteArray(bi);
        if (rndBytes.length == randomHandshakeLength) {
            System.arraycopy(rndBytes, 0, this.handshakeBytes, 8, randomHandshakeLength);
        } else {
            ByteBuffer b = ByteBuffer.allocate(randomHandshakeLength);
            b.put(rndBytes);
            b.put((byte)105);
            b.flip();
            System.arraycopy(b.array(), 0, this.handshakeBytes, 8, randomHandshakeLength);
        }
    }

    @Override
    public boolean validate(byte[] handshake) {
        if (this.validateScheme(handshake, 0)) {
            this.algorithm = 0;
            return true;
        }
        if (this.validateScheme(handshake, 1)) {
            this.algorithm = 1;
            return true;
        }
        this.log.error("Unable to validate client");
        return false;
    }

    private boolean validateScheme(byte[] handshake, int scheme) {
        int digestOffset = -1;
        switch (scheme) {
            case 0: {
                digestOffset = this.getDigestOffset1(handshake, 0);
                break;
            }
            case 1: {
                digestOffset = this.getDigestOffset2(handshake, 0);
                break;
            }
            default: {
                this.log.error("Unknown algorithm: {}", (Object)scheme);
            }
        }
        this.log.debug("Algorithm: {} digest offset: {}", (Object)scheme, (Object)digestOffset);
        byte[] tempBuffer = new byte[1504];
        System.arraycopy(handshake, 0, tempBuffer, 0, digestOffset);
        System.arraycopy(handshake, digestOffset + 32, tempBuffer, digestOffset, 1536 - digestOffset - 32);
        byte[] tempHash = new byte[32];
        this.calculateHMAC_SHA256(tempBuffer, 0, tempBuffer.length, GENUINE_FP_KEY, 30, tempHash, 0);
        this.log.debug("Hash: {}", (Object)Hex.encodeHexString(tempHash));
        boolean result = true;
        for (int i = 0; i < 32; ++i) {
            if (handshake[digestOffset + i] == tempHash[i]) continue;
            result = false;
            break;
        }
        return result;
    }

    private void encryptXtea(byte[] in, int index, int keyId) {
    }

    private void encryptBlowfish(byte[] in, int index, int keyId) {
        if (this.blowfish == null) {
            this.initBlowfishEncryption(keyId);
        }
        this.blowfish.processBlock(in, index, in, index);
    }

    public void setHandshakeBytes(byte[] handshake) {
        this.handshakeBytes = handshake;
    }

    public byte[] getHandshakeBytes() {
        return this.s1;
    }

    public void setUnvalidatedConnectionAllowed(boolean unvalidatedConnectionAllowed) {
        this.unvalidatedConnectionAllowed = unvalidatedConnectionAllowed;
    }
}

