/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmps;

import java.util.Optional;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.red5.server.net.rtmp.InboundHandshake;
import org.red5.server.net.rtmp.RTMPConnManager;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.ReadBuffer;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.codec.RTMPMinaCodecFactory;
import org.red5.server.net.rtmpe.RTMPEIoFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPSIoFilter
extends RTMPEIoFilter {
    private static final Logger log = LoggerFactory.getLogger(RTMPSIoFilter.class);

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object obj) throws Exception {
        log.trace("messageReceived nextFilter: {} session: {} message: {}", nextFilter, session, obj);
        if (obj instanceof SslFilter.SslFilterMessage || !session.isSecured()) {
            log.trace("Either ssl message or un-secured session: {}", (Object)session.isSecured());
            nextFilter.messageReceived(session, obj);
        } else {
            String sessionId = (String)session.getAttribute("rtmp.sessionid");
            if (sessionId != null) {
                log.info("RTMPS Session id: {}", (Object)sessionId);
                RTMPMinaConnection conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
                byte connectionState = conn.getStateCode();
                ReadBuffer buffer = Optional.ofNullable((ReadBuffer)session.getAttribute("rtmp.buffer")).orElseGet(() -> {
                    session.setAttribute("rtmp.buffer", new ReadBuffer());
                    return (ReadBuffer)session.getAttribute("rtmp.buffer");
                });
                buffer.addBuffer((IoBuffer)obj);
                InboundHandshake handshake = session.containsAttribute("rtmp.handshake") ? (InboundHandshake)session.getAttribute("rtmp.handshake") : null;
                switch (connectionState) {
                    case 0: {
                        int c0c1Size = buffer.getBufferSize();
                        log.trace("Incoming C0C1 size: {}", (Object)c0c1Size);
                        if (c0c1Size < 1537) break;
                        log.debug("decodeHandshakeC0C1");
                        byte[] dst = buffer.getBuffer(1537);
                        byte connectionType = dst[0];
                        if (connectionType == "P".getBytes()[0]) {
                            log.info("Non-native RTMPS connection requested for: {}", (Object)sessionId);
                            break;
                        }
                        handshake.setHandshakeType(connectionType);
                        log.trace("Incoming C0 connection type: {}", (Object)connectionType);
                        IoBuffer decBuffer = IoBuffer.wrap(dst);
                        decBuffer.get();
                        IoBuffer s1 = handshake.decodeClientRequest1(decBuffer);
                        if (s1 != null) {
                            conn.setStateCode((byte)1);
                            session.write(s1);
                            break;
                        }
                        log.warn("Client was rejected due to invalid handshake");
                        conn.close();
                        break;
                    }
                    case 1: {
                        int c2Size = buffer.getBufferSize();
                        log.trace("Incoming C2 size: {}", (Object)c2Size);
                        if (c2Size >= 1536) {
                            log.debug("decodeHandshakeC2");
                            byte[] dst = buffer.getBuffer(1536);
                            if (handshake.decodeClientRequest2(IoBuffer.wrap(dst))) {
                                log.debug("Connected, removing handshake data and adding rtmp protocol filter");
                                conn.setStateCode((byte)2);
                                session.removeAttribute("rtmp.handshake");
                                log.debug("Adding RTMP protocol filter");
                                session.getFilterChain().addAfter("rtmpsFilter", "protocolFilter", new ProtocolCodecFilter(new RTMPMinaCodecFactory()));
                            } else {
                                log.warn("Client was rejected due to invalid handshake");
                                conn.close();
                            }
                        }
                    }
                    case 2: {
                        IoBuffer message = buffer.getBufferAsIoBuffer();
                        nextFilter.messageReceived(session, message);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        log.debug("Nothing to do, connection state: {}", (Object)RTMP.states[connectionState]);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid RTMP state: " + connectionState);
                    }
                }
            }
        }
    }
}

