/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scope;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.InMemoryPushPushPipe;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.scope.BasicScope;
import org.red5.server.stream.IProviderService;

public class BroadcastScope
extends BasicScope
implements IBroadcastScope,
IPipeConnectionListener {
    private transient IClientBroadcastStream clientBroadcastStream;
    private final transient InMemoryPushPushPipe pipe;
    private AtomicInteger compCounter = new AtomicInteger(0);
    private volatile boolean removed;

    public BroadcastScope(IScope parent, String name) {
        super(parent, ScopeType.BROADCAST, name, false);
        this.pipe = new InMemoryPushPushPipe(this);
        this.keepOnDisconnect = true;
    }

    @Override
    public void addPipeConnectionListener(IPipeConnectionListener listener) {
        this.pipe.addPipeConnectionListener(listener);
    }

    @Override
    public void removePipeConnectionListener(IPipeConnectionListener listener) {
        this.pipe.removePipeConnectionListener(listener);
    }

    @Override
    public IMessage pullMessage() {
        return this.pipe.pullMessage();
    }

    @Override
    public IMessage pullMessage(long wait) {
        return this.pipe.pullMessage(wait);
    }

    @Override
    public boolean subscribe(IConsumer consumer, Map<String, Object> paramMap) {
        return !this.removed && this.pipe.subscribe(consumer, paramMap);
    }

    @Override
    public boolean unsubscribe(IConsumer consumer) {
        return this.pipe.unsubscribe(consumer);
    }

    @Override
    public List<IConsumer> getConsumers() {
        return this.pipe.getConsumers();
    }

    @Override
    public void sendOOBControlMessage(IConsumer consumer, OOBControlMessage oobCtrlMsg) {
        this.pipe.sendOOBControlMessage(consumer, oobCtrlMsg);
    }

    @Override
    public void pushMessage(IMessage message) throws IOException {
        this.pipe.pushMessage(message);
    }

    @Override
    public boolean subscribe(IProvider provider, Map<String, Object> paramMap) {
        return !this.removed && this.pipe.subscribe(provider, paramMap);
    }

    @Override
    public boolean unsubscribe(IProvider provider) {
        return this.pipe.unsubscribe(provider);
    }

    @Override
    public List<IProvider> getProviders() {
        return this.pipe.getProviders();
    }

    @Override
    public void sendOOBControlMessage(IProvider provider, OOBControlMessage oobCtrlMsg) {
        this.pipe.sendOOBControlMessage(provider, oobCtrlMsg);
    }

    @Override
    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case CONSUMER_CONNECT_PULL: 
            case CONSUMER_CONNECT_PUSH: 
            case PROVIDER_CONNECT_PULL: 
            case PROVIDER_CONNECT_PUSH: {
                this.compCounter.incrementAndGet();
                break;
            }
            case CONSUMER_DISCONNECT: 
            case PROVIDER_DISCONNECT: {
                if (this.compCounter.decrementAndGet() > 0) break;
                if (this.hasParent()) {
                    IScope parent = this.getParent();
                    IProviderService providerService = (IProviderService)parent.getContext().getBean("providerService");
                    this.removed = providerService.unregisterBroadcastStream(parent, this.getName());
                    break;
                }
                this.removed = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Event type not supported: " + event.getType());
            }
        }
    }

    @Override
    public IClientBroadcastStream getClientBroadcastStream() {
        return this.clientBroadcastStream;
    }

    @Override
    public void setClientBroadcastStream(IClientBroadcastStream clientBroadcastStream) {
        if (this.clientBroadcastStream != null) {
            log.debug("ClientBroadcastStream already exists: {} new: {}", (Object)this.clientBroadcastStream, (Object)clientBroadcastStream);
            if (this.clientBroadcastStream == clientBroadcastStream) {
                return;
            }
        }
        this.clientBroadcastStream = clientBroadcastStream;
    }

    public String toString() {
        return "BroadcastScope [clientBroadcastStream=" + this.clientBroadcastStream + ", compCounter=" + this.compCounter + ", removed=" + this.removed + "]";
    }
}

