/*
 * Decompiled with CFR 0.152.
 */
package org.red5.spring;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ExtendedPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static Logger logger = LoggerFactory.getLogger(ExtendedPropertyPlaceholderConfigurer.class);
    private static Properties globalPlaceholderProperties = new Properties();
    private Properties mergedProperties;

    @Override
    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        props.putAll((Map<?, ?>)ExtendedPropertyPlaceholderConfigurer.copyOfGlobalProperties());
        logger.debug("Placeholder props: {}", (Object)props.toString());
        this.mergedProperties = props;
        super.processProperties(beanFactoryToProcess, props);
    }

    public Properties getMergedProperties() {
        return this.mergedProperties;
    }

    public void setWildcardLocations(String[] locations) throws IOException {
        ArrayList resources = new ArrayList();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
        for (String location : locations) {
            logger.debug("Loading location {}", (Object)location);
            try {
                Resource[] configs = resolver.getResources(location);
                if (configs != null && configs.length > 0) {
                    ArrayList<Resource> resourceGroup = new ArrayList<Resource>();
                    for (Resource resource : configs) {
                        logger.debug("Loading {} for location {}", (Object)resource.getFilename(), (Object)location);
                        resourceGroup.add(resource);
                    }
                    Collections.sort(resourceGroup, new ResourceFilenameComparator());
                    resources.addAll(resourceGroup);
                    continue;
                }
                logger.info("Wildcard location does not exist: {}", (Object)location);
            }
            catch (IOException ioException) {
                logger.error("Failed to resolve location: {} - {}", (Object)location, (Object)ioException);
            }
        }
        this.setLocations(resources.toArray(new Resource[resources.size()]));
    }

    public static synchronized void addGlobalProperty(String key, String val) {
        globalPlaceholderProperties.setProperty(key, val);
    }

    private static synchronized Properties copyOfGlobalProperties() {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)globalPlaceholderProperties);
        return prop;
    }

    public static class ResourceFilenameComparator
    implements Comparator<Resource>,
    Serializable {
        private static final long serialVersionUID = -6365943736917478749L;

        @Override
        public int compare(Resource resource1, Resource resource2) {
            if (resource1 != null) {
                if (resource2 != null) {
                    return resource1.getFilename().compareTo(resource2.getFilename());
                }
                return 1;
            }
            if (resource2 == null) {
                return 0;
            }
            return -1;
        }
    }
}

