/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.samplegrouping;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.mp4parser.IsoFile;
import org.mp4parser.aj.lang.JoinPoint;
import org.mp4parser.aj.lang.Signature;
import org.mp4parser.aj.runtime.internal.Conversions;
import org.mp4parser.aj.runtime.reflect.Factory;
import org.mp4parser.boxes.iso14496.part15.StepwiseTemporalLayerEntry;
import org.mp4parser.boxes.iso14496.part15.SyncSampleEntry;
import org.mp4parser.boxes.iso14496.part15.TemporalLayerSampleGroup;
import org.mp4parser.boxes.iso14496.part15.TemporalSubLayerSampleGroup;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.boxes.samplegrouping.RateShareEntry;
import org.mp4parser.boxes.samplegrouping.RollRecoveryEntry;
import org.mp4parser.boxes.samplegrouping.TemporalLevelEntry;
import org.mp4parser.boxes.samplegrouping.UnknownEntry;
import org.mp4parser.boxes.samplegrouping.VisualRandomAccessEntry;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

public class SampleGroupDescriptionBox
extends AbstractFullBox {
    public static final String TYPE = "sgpd";
    private String groupingType;
    private int defaultLength;
    private List<GroupEntry> groupEntries = new LinkedList<GroupEntry>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    public SampleGroupDescriptionBox() {
        super(TYPE);
        this.setVersion(1);
    }

    public String getGroupingType() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.groupingType;
    }

    public void setGroupingType(String groupingType) {
        String string = groupingType;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.groupingType = groupingType;
    }

    @Override
    protected long getContentSize() {
        long size = 8L;
        if (this.getVersion() == 1) {
            size += 4L;
        }
        size += 4L;
        for (GroupEntry groupEntry : this.groupEntries) {
            if (this.getVersion() == 1 && this.defaultLength == 0) {
                size += 4L;
            }
            size += (long)(this.defaultLength == 0 ? groupEntry.size() : this.defaultLength);
        }
        return size;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(IsoFile.fourCCtoBytes(this.groupingType));
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.defaultLength);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.groupEntries.size());
        for (GroupEntry entry : this.groupEntries) {
            ByteBuffer data = entry.get();
            if (this.getVersion() == 1) {
                if (this.defaultLength == 0) {
                    IsoTypeWriter.writeUInt32(byteBuffer, data.limit());
                } else if (data.limit() > this.defaultLength) {
                    throw new RuntimeException(String.format("SampleGroupDescriptionBox entry size %d more than %d", data.limit(), this.defaultLength));
                }
            }
            byteBuffer.put(data);
            int deadBytes = this.defaultLength == 0 ? 0 : this.defaultLength - data.limit();
            while (deadBytes-- > 0) {
                byteBuffer.put((byte)0);
            }
        }
    }

    @Override
    protected void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.groupingType = IsoTypeReader.read4cc(content);
        if (this.getVersion() == 1) {
            this.defaultLength = CastUtils.l2i(IsoTypeReader.readUInt32(content));
        }
        long entryCount = IsoTypeReader.readUInt32(content);
        while (entryCount-- > 0L) {
            int length = this.defaultLength;
            if (this.getVersion() == 1) {
                if (this.defaultLength == 0) {
                    length = CastUtils.l2i(IsoTypeReader.readUInt32(content));
                }
            } else {
                length = content.limit() - content.position();
            }
            ByteBuffer parseMe = content.slice();
            parseMe.limit(length);
            this.groupEntries.add(this.parseGroupEntry(parseMe, this.groupingType));
            int parsedBytes = this.getVersion() == 1 ? length : parseMe.position();
            content.position(content.position() + parsedBytes);
        }
    }

    private GroupEntry parseGroupEntry(ByteBuffer content, String groupingType) {
        GroupEntry groupEntry;
        if ("roll".equals(groupingType)) {
            groupEntry = new RollRecoveryEntry();
        } else if ("rash".equals(groupingType)) {
            groupEntry = new RateShareEntry();
        } else if ("rap ".equals(groupingType)) {
            groupEntry = new VisualRandomAccessEntry();
        } else if ("tele".equals(groupingType)) {
            groupEntry = new TemporalLevelEntry();
        } else if ("sync".equals(groupingType)) {
            groupEntry = new SyncSampleEntry();
        } else if ("tscl".equals(groupingType)) {
            groupEntry = new TemporalLayerSampleGroup();
        } else if ("tsas".equals(groupingType)) {
            groupEntry = new TemporalSubLayerSampleGroup();
        } else if ("stsa".equals(groupingType)) {
            groupEntry = new StepwiseTemporalLayerEntry();
        } else {
            if (this.getVersion() == 0) {
                throw new RuntimeException("SampleGroupDescriptionBox with UnknownEntry are only supported in version 1");
            }
            groupEntry = new UnknownEntry(groupingType);
        }
        ((GroupEntry)groupEntry).parse(content);
        return groupEntry;
    }

    public int getDefaultLength() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.defaultLength;
    }

    public void setDefaultLength(int defaultLength) {
        int n = defaultLength;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.defaultLength = defaultLength;
    }

    public List<GroupEntry> getGroupEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.groupEntries;
    }

    public void setGroupEntries(List<GroupEntry> groupEntries) {
        List<GroupEntry> list = groupEntries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.groupEntries = groupEntries;
    }

    public boolean equals(Object o) {
        Object object = o;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, (Object)this, (Object)this, object);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampleGroupDescriptionBox that = (SampleGroupDescriptionBox)o;
        if (this.defaultLength != that.defaultLength) {
            return false;
        }
        return !(this.groupEntries != null ? !this.groupEntries.equals(that.groupEntries) : that.groupEntries != null);
    }

    public int hashCode() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        int result = 0;
        result = 31 * result + this.defaultLength;
        result = 31 * result + (this.groupEntries != null ? this.groupEntries.hashCode() : 0);
        return result;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return "SampleGroupDescriptionBox{groupingType='" + (this.groupEntries.size() > 0 ? this.groupEntries.get(0).getType() : "????") + '\'' + ", defaultLength=" + this.defaultLength + ", groupEntries=" + this.groupEntries + '}';
    }

    static {
        SampleGroupDescriptionBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SampleGroupDescriptionBox.java", SampleGroupDescriptionBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupingType", "org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox", "", "", "", "java.lang.String"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setGroupingType", "org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox", "java.lang.String", "groupingType", "", "void"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDefaultLength", "org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox", "", "", "", "int"), 163);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDefaultLength", "org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox", "int", "defaultLength", "", "void"), 167);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupEntries", "org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox", "", "", "", "java.util.List"), 171);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setGroupEntries", "org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox", "java.util.List", "groupEntries", "", "void"), 175);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox", "java.lang.Object", "o", "", "boolean"), 180);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox", "", "", "", "int"), 201);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox", "", "", "", "java.lang.String"), 209);
    }
}

