/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.stream.Stream;
import javax.websocket.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.websocket.WsSession;
import org.red5.net.websocket.WebSocketScope;
import org.red5.server.AttributeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
extends AttributeStore {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConnection.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private static final boolean isDebug = log.isDebugEnabled();
    private static boolean useAsync = !System.getProperty("os.name").contains("Windows");
    private static long sendTimeout = 20000L;
    private AtomicBoolean connected = new AtomicBoolean(false);
    private final WsSession wsSession;
    private String httpSessionId;
    private String host;
    private String path;
    private String origin;
    private String userAgent = "undefined";
    private Map<String, List<String>> headers;
    private Map<String, Object> extensions;
    private Map<String, Object> querystringParameters;
    private String protocol;
    private volatile long readBytes;
    private volatile long writtenBytes;
    private static final AtomicLongFieldUpdater<WebSocketConnection> readUpdater = AtomicLongFieldUpdater.newUpdater(WebSocketConnection.class, "readBytes");
    private static final AtomicLongFieldUpdater<WebSocketConnection> writeUpdater = AtomicLongFieldUpdater.newUpdater(WebSocketConnection.class, "writtenBytes");

    public WebSocketConnection(WebSocketScope scope, Session session) {
        this.path = scope.getPath();
        this.wsSession = (WsSession)session;
        this.httpSessionId = Optional.ofNullable(this.wsSession.getHttpSessionId()).orElse(this.wsSession.getId());
        this.wsSession.getNegotiatedExtensions().forEach(extension -> {
            if (this.extensions == null) {
                this.extensions = new HashMap<String, Object>();
            }
            this.extensions.put(extension.getName(), extension);
        });
        log.debug("extensions: {}", (Object)this.extensions);
        String queryString = this.wsSession.getQueryString();
        log.debug("queryString: {}", (Object)queryString);
        if (StringUtils.isNotBlank(queryString)) {
            String[] qsParams = queryString.split("&");
            this.querystringParameters = new HashMap<String, Object>();
            Stream.of(qsParams).forEach(qsParam -> {
                String[] parts = qsParam.split("=");
                if (parts.length == 2) {
                    this.querystringParameters.put(parts[0], parts[1]);
                } else {
                    this.querystringParameters.put(parts[0], null);
                }
            });
        }
        Map pathParameters = this.wsSession.getPathParameters();
        if (isDebug) {
            log.debug("pathParameters: {}", (Object)pathParameters);
        }
        Map userProps = this.wsSession.getUserProperties();
        if (isDebug) {
            log.debug("userProps: {}", (Object)userProps);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(String data) throws UnsupportedEncodingException, IOException {
        if (isDebug) {
            log.debug("send message: {}", (Object)data);
        }
        if (!StringUtils.isNotBlank(data)) throw new UnsupportedEncodingException("Cannot send a null string");
        if (!this.wsSession.isOpen()) throw new IOException("WS session closed");
        if (!this.isConnected()) throw new IOException("WS connection closed");
        try {
            int lengthToWrite = data.getBytes().length;
            if (useAsync) {
                Future sendFuture = this.wsSession.getAsyncRemote().sendText(data);
                sendFuture.get(sendTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.wsSession.getBasicRemote().sendText(data);
            }
            writeUpdater.addAndGet(this, lengthToWrite);
            return;
        }
        catch (TimeoutException e) {
            log.warn("Send timed out");
            return;
        }
        catch (Exception e) {
            log.warn("Send text exception", e);
        }
    }

    public void send(byte[] buf) throws IOException {
        if (isDebug) {
            log.debug("send binary: {}", (Object)Arrays.toString(buf));
        }
        if (this.wsSession.isOpen()) {
            try {
                if (useAsync) {
                    Future sendFuture = this.wsSession.getAsyncRemote().sendBinary(ByteBuffer.wrap(buf));
                    sendFuture.get(sendTimeout, TimeUnit.MILLISECONDS);
                } else {
                    this.wsSession.getBasicRemote().sendBinary(ByteBuffer.wrap(buf));
                }
                writeUpdater.addAndGet(this, buf.length);
            }
            catch (Exception e) {
                log.warn("Send bytes exception", e);
            }
        } else {
            throw new IOException("WS session closed");
        }
    }

    public void sendPing(byte[] buf) throws IllegalArgumentException, IOException {
        if (isTrace) {
            log.trace("send ping: {}", (Object)buf);
        }
        if (!this.wsSession.isOpen()) {
            throw new IOException("WS session closed");
        }
        this.wsSession.getBasicRemote().sendPing(ByteBuffer.wrap(buf));
        writeUpdater.addAndGet(this, buf.length);
    }

    public void sendPong(byte[] buf) throws IllegalArgumentException, IOException {
        if (isTrace) {
            log.trace("send pong: {}", (Object)buf);
        }
        if (!this.wsSession.isOpen()) {
            throw new IOException("WS session closed");
        }
        this.wsSession.getBasicRemote().sendPong(ByteBuffer.wrap(buf));
        writeUpdater.addAndGet(this, buf.length);
    }

    public void close() {
        if (this.connected.compareAndSet(true, false) && this.wsSession.isOpen()) {
            try {
                this.wsSession.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public void updateReadBytes(long read) {
        readUpdater.addAndGet(this, read);
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public void setConnected() {
        boolean connectSuccess = this.connected.compareAndSet(false, true);
        log.debug("Connect success: {}", (Object)connectSuccess);
    }

    public String getHost() {
        return String.format("%s://%s%s", this.isSecure() ? "wss" : "ws", this.host, this.path);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean isSecure() {
        return this.wsSession != null ? this.wsSession.isSecure() : false;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path.charAt(path.length() - 1) == '/' ? path.substring(0, path.length() - 1) : path;
    }

    public String getSessionId() {
        return this.wsSession.getId();
    }

    public void setHttpSessionId(String httpSessionId) {
        this.httpSessionId = httpSessionId;
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        if (headers != null && !headers.isEmpty()) {
            Optional<List<String>> protocolHeader;
            List<String> originHeader;
            List<String> hostHeader;
            List<String> userAgentHeader = Optional.ofNullable(headers.get("User-Agent")).orElse(headers.get("User-Agent".toLowerCase()));
            if (userAgentHeader != null && !userAgentHeader.isEmpty()) {
                this.userAgent = userAgentHeader.get(0);
            }
            if ((hostHeader = Optional.ofNullable(headers.get("Host")).orElse(headers.get("Host".toLowerCase()))) != null && !hostHeader.isEmpty()) {
                this.host = hostHeader.get(0);
            }
            if ((originHeader = Optional.ofNullable(headers.get("Origin")).orElse(headers.get("Origin".toLowerCase()))) != null && !originHeader.isEmpty()) {
                this.origin = originHeader.get(0);
            }
            if ((protocolHeader = Optional.ofNullable(headers.get("Sec-WebSocket-Protocol"))).isPresent()) {
                if (isDebug) {
                    log.debug("Protocol header(s) exist: {}", (Object)protocolHeader.get());
                }
                this.protocol = protocolHeader.get().get(0);
            }
            if (isDebug) {
                log.debug("Set from headers - user-agent: {} host: {} origin: {}", this.userAgent, this.host, this.origin);
            }
            this.headers = headers;
        } else {
            this.headers = Collections.emptyMap();
        }
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getQuerystringParameters() {
        return this.querystringParameters;
    }

    public void setQuerystringParameters(Map<String, Object> querystringParameters) {
        if (this.querystringParameters == null) {
            this.querystringParameters = new ConcurrentHashMap<String, Object>();
        }
        this.querystringParameters.putAll(querystringParameters);
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public String getExtensionsAsString() {
        String extensionsList = null;
        if (this.extensions != null) {
            StringBuilder sb = new StringBuilder();
            for (String key : this.extensions.keySet()) {
                sb.append(key);
                sb.append("; ");
            }
            extensionsList = sb.toString().trim();
        }
        return extensionsList;
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public static long getSendTimeout() {
        return sendTimeout;
    }

    public static void setSendTimeout(long sendTimeout) {
        WebSocketConnection.sendTimeout = sendTimeout;
    }

    public void setWsSessionTimeout(long idleTimeout) {
        this.wsSession.setMaxIdleTimeout(idleTimeout);
    }

    public WsSession getWsSession() {
        return this.wsSession;
    }

    public String toString() {
        if (this.wsSession != null && this.connected.get()) {
            return "WebSocketConnection [wsId=" + this.wsSession.getId() + ", sessionId=" + this.httpSessionId + ", host=" + this.host + ", origin=" + this.origin + ", path=" + this.path + ", secure=" + this.isSecure() + ", connected=" + this.connected + "]";
        }
        if (this.wsSession == null) {
            return "WebSocketConnection [wsId=not-set, sessionId=not-set, host=" + this.host + ", origin=" + this.origin + ", path=" + this.path + ", secure=not-set, connected=" + this.connected + "]";
        }
        return "WebSocketConnection [host=" + this.host + ", origin=" + this.origin + ", path=" + this.path + " connected=false]";
    }
}

