/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.listener.IWebSocketDataListener;
import org.red5.net.websocket.model.WSMessage;
import org.red5.server.api.scope.IScope;
import org.red5.server.plugin.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class WebSocketScope
implements InitializingBean,
DisposableBean {
    private static Logger log = LoggerFactory.getLogger(WebSocketScope.class);
    protected CopyOnWriteArraySet<WebSocketConnection> conns = new CopyOnWriteArraySet();
    protected CopyOnWriteArraySet<IWebSocketDataListener> listeners = new CopyOnWriteArraySet();
    protected IScope scope;
    protected String path = "default";

    public WebSocketScope() {
    }

    public WebSocketScope(IScope scope) {
        log.debug("Creating WebSocket scope for: {}", (Object)scope);
        this.setScope(scope);
        this.setPath(String.format("/%s", scope.getName()));
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.register();
    }

    @Override
    public void destroy() throws Exception {
        this.unregister();
    }

    public void register() {
        log.info("Application scope: {}", (Object)this.scope);
        WebSocketScopeManager manager = ((WebSocketPlugin)PluginRegistry.getPlugin("WebSocketPlugin")).getManager(this.scope);
        if (manager.setApplication(this.scope)) {
            log.info("WebSocket app added: {}", (Object)this.scope.getName());
        }
        if (manager.addWebSocketScope(this)) {
            log.info("WebSocket scope added");
        }
    }

    public void unregister() {
        this.conns.forEach(conn -> conn.close());
        this.conns.clear();
        this.listeners.forEach(listener -> listener.stop());
        this.listeners.clear();
    }

    public WebSocketConnection getConnectionBySessionId(String id) {
        Optional<WebSocketConnection> opt = this.conns.stream().filter(conn -> id.equals(conn.getHttpSessionId())).findFirst();
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    public Set<WebSocketConnection> getConns() {
        return this.conns;
    }

    public IScope getScope() {
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
        this.scope.setAttribute("ws.scope", this);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void addConnection(WebSocketConnection conn) {
        if (this.conns.add(conn)) {
            for (IWebSocketDataListener listener : this.listeners) {
                listener.onWSConnect(conn);
            }
        } else {
            log.warn("Add connection failed for: {}", (Object)conn);
        }
    }

    public void removeConnection(WebSocketConnection conn) {
        if (this.conns.remove(conn)) {
            for (IWebSocketDataListener listener : this.listeners) {
                listener.onWSDisconnect(conn);
            }
        } else {
            log.warn("Remove connection failed for: {}", (Object)conn);
        }
    }

    public void addListener(IWebSocketDataListener listener) {
        log.info("addListener: {}", (Object)listener);
        this.listeners.add(listener);
    }

    public void removeListener(IWebSocketDataListener listener) {
        log.info("removeListener: {}", (Object)listener);
        this.listeners.remove(listener);
    }

    public void setListeners(Collection<IWebSocketDataListener> listeners) {
        log.trace("setListeners: {}", (Object)listeners);
        this.listeners.addAll(listeners);
    }

    public Set<IWebSocketDataListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public boolean hasListener(Class<?> clazz) {
        return this.listeners.stream().filter(listener -> listener.getClass().isInstance(clazz)).findFirst().isPresent();
    }

    public boolean isValid() {
        return this.conns.size() + this.listeners.size() > 0;
    }

    public void onMessage(WSMessage message) {
        log.trace("Listeners: {}", (Object)this.listeners.size());
        this.listeners.forEach(listener -> {
            try {
                listener.onWSMessage(message);
            }
            catch (Exception e) {
                log.warn("onMessage exception", e);
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketScope other = (WebSocketScope)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return "WebSocketScope [path=" + this.path + ", listeners=" + this.listeners.size() + ", connections=" + this.conns.size() + "]";
    }
}

