/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.listener;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.net.websocket.WebSocketScope;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.listener.WebSocketDataListener;
import org.red5.net.websocket.model.WSMessage;
import org.red5.server.plugin.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebSocketDataListener
extends WebSocketDataListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSocketDataListener.class);

    @Override
    public void onWSConnect(WebSocketConnection conn) {
        log.info("Connect: {}", (Object)conn);
    }

    @Override
    public void onWSDisconnect(WebSocketConnection conn) {
        log.info("Disconnect: {}", (Object)conn);
    }

    @Override
    public void onWSMessage(WSMessage message) {
        String msg = new String(message.getPayload().array());
        log.info("onWSMessage: {}", (Object)msg);
        String path = message.getPath();
        WebSocketScopeManager manager = ((WebSocketPlugin)PluginRegistry.getPlugin("WebSocketPlugin")).getManager(path);
        if (manager != null) {
            WebSocketScope wsScope = manager.getScope(path);
            Set<WebSocketConnection> conns = wsScope.getConns();
            for (WebSocketConnection conn : conns) {
                log.debug("Echoing to {}", (Object)conn);
                try {
                    conn.send(msg);
                }
                catch (UnsupportedEncodingException e) {
                    log.warn("Encoding issue with the message data: {}", (Object)message, (Object)e);
                }
                catch (IOException e) {
                    log.warn("IO exception", e);
                }
            }
        } else {
            log.info("No manager found for path: {}", (Object)path);
        }
    }

    @Override
    public void stop() {
        log.info("Stop");
    }
}

