/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketScope;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.model.WSMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebSocketEndpoint
extends Endpoint {
    private final Logger log = LoggerFactory.getLogger(DefaultWebSocketEndpoint.class);
    private WebSocketScopeManager manager;
    private WebSocketScope scope;
    private ThreadLocal<WebSocketConnection> connectionLocal = new ThreadLocal();
    private final MessageHandler.Whole<String> stringHandler = new MessageHandler.Whole<String>(){

        public void onMessage(String message) {
            if (DefaultWebSocketEndpoint.this.log.isTraceEnabled()) {
                DefaultWebSocketEndpoint.this.log.trace("Message received {}", (Object)message);
            }
            WebSocketConnection conn = DefaultWebSocketEndpoint.this.connectionLocal.get();
            try {
                conn.updateReadBytes(message.getBytes().length);
                WSMessage wsMessage = new WSMessage(message);
                wsMessage.setConnection(conn);
                DefaultWebSocketEndpoint.this.scope.onMessage(wsMessage);
            }
            catch (UnsupportedEncodingException e) {
                DefaultWebSocketEndpoint.this.log.warn("Exception on message", e);
            }
        }
    };
    private final MessageHandler.Whole<ByteBuffer> binaryHandler = new MessageHandler.Whole<ByteBuffer>(){

        public void onMessage(ByteBuffer message) {
            if (DefaultWebSocketEndpoint.this.log.isTraceEnabled()) {
                DefaultWebSocketEndpoint.this.log.trace("Message received {}", (Object)message);
            }
            WebSocketConnection conn = DefaultWebSocketEndpoint.this.connectionLocal.get();
            conn.updateReadBytes(message.limit());
            WSMessage wsMessage = new WSMessage();
            wsMessage.setPayload(IoBuffer.wrap(message));
            wsMessage.setConnection(conn);
            DefaultWebSocketEndpoint.this.scope.onMessage(wsMessage);
        }
    };
    private final MessageHandler.Whole<PongMessage> pongHandler = new MessageHandler.Whole<PongMessage>(){

        public void onMessage(PongMessage message) {
            if (DefaultWebSocketEndpoint.this.log.isTraceEnabled()) {
                DefaultWebSocketEndpoint.this.log.trace("Pong received {}", (Object)message);
            }
            DefaultWebSocketEndpoint.this.connectionLocal.get().updateReadBytes(1L);
        }
    };

    public void onOpen(Session session, EndpointConfig config) {
        this.log.trace("Session {} opened", (Object)session.getId());
        session.setMaxTextMessageBufferSize(10000);
        session.addMessageHandler(this.stringHandler);
        session.addMessageHandler(this.binaryHandler);
        session.addMessageHandler(this.pongHandler);
        this.manager = (WebSocketScopeManager)config.getUserProperties().get("ws.manager");
        this.scope = (WebSocketScope)config.getUserProperties().get("ws.scope");
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.log.trace("Session {} closed", (Object)session.getId());
        WebSocketConnection conn = Optional.ofNullable(this.scope.getConnectionBySessionId(session.getId())).orElse((WebSocketConnection)session.getUserProperties().get("ws.connection"));
        if (conn != null) {
            conn.close();
            this.manager.removeConnection(conn);
        } else {
            this.log.debug("Connection for id: {} was not found in the scope: {}", (Object)session.getId(), (Object)this.scope.getPath());
        }
    }

    public void onError(Session session, Throwable t) {
        Throwable root = t;
        for (int count = 0; root.getCause() != null && count < 20; ++count) {
            root = root.getCause();
        }
        if (root instanceof EOFException) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("EOF exception", root);
            }
        } else if (!session.isOpen() && root instanceof IOException) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("IO exception when not opened", root);
            }
        } else {
            this.log.warn("onError: {}", (Object)t.toString(), (Object)t);
            this.onClose(session, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, t.getMessage()));
        }
    }

    public WebSocketConnection getConnectionLocal() {
        return this.connectionLocal.get();
    }

    public void setConnectionLocal(WebSocketConnection connection) {
        this.connectionLocal.set(connection);
    }
}

