/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import org.red5.server.Client;
import org.red5.server.ClientRegistry;
import org.red5.server.api.IClient;
import org.red5.server.api.IClientRegistry;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeHandler;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.jmx.mxbeans.CoreHandlerMXBean;
import org.red5.server.net.IConnectionManager;
import org.red5.server.net.rtmp.RTMPConnManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmpt.RTMPTConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreHandler
implements IScopeHandler,
CoreHandlerMXBean {
    protected static Logger log = LoggerFactory.getLogger(CoreHandler.class);

    @Override
    public boolean addChildScope(IBasicScope scope) {
        return true;
    }

    @Override
    public boolean connect(IConnection conn, IScope scope) {
        return this.connect(conn, scope, null);
    }

    @Override
    public boolean connect(IConnection conn, IScope scope, Object[] params) {
        log.debug("connect - conn: {} scope: {}", (Object)conn, (Object)scope);
        boolean connect = false;
        String id = conn.getSessionId();
        log.trace("Session id: {}", (Object)id);
        IScope connectionScope = conn.getScope();
        log.debug("Connection scope: {}", (Object)(connectionScope == null ? "is null" : "not null"));
        if (connectionScope != null) {
            IClientRegistry clientRegistry = connectionScope.getContext().getClientRegistry();
            log.debug("Client registry: {}", (Object)(clientRegistry == null ? "is null" : "not null"));
            if (clientRegistry != null) {
                IClient client = conn.getClient();
                if (client == null) {
                    if (!clientRegistry.hasClient(id)) {
                        if (conn instanceof RTMPTConnection) {
                            log.debug("Creating new client for RTMPT connection");
                            client = new Client(id, (ClientRegistry)clientRegistry);
                            clientRegistry.addClient(client);
                            conn.setClient(client);
                        } else if (conn instanceof RTMPConnection) {
                            log.debug("Creating new client for RTMP connection");
                            client = clientRegistry.newClient(params);
                            conn.setClient(client);
                        }
                    } else {
                        client = clientRegistry.lookupClient(id);
                        conn.setClient(client);
                    }
                } else {
                    conn.setClient(client);
                }
                IConnectionManager<RTMPConnection> connManager = RTMPConnManager.getInstance();
                if (conn instanceof RTMPTConnection) {
                    connManager.setConnection((RTMPTConnection)conn);
                } else if (conn instanceof RTMPConnection) {
                    connManager.setConnection((RTMPConnection)conn);
                } else {
                    log.warn("Connection was not added to manager: {}", (Object)conn);
                }
                conn.initialize(client);
                connect = true;
            } else {
                log.error("No client registry was found, clients cannot be looked-up or created");
            }
        } else {
            log.error("No connection scope was found");
        }
        return connect;
    }

    @Override
    public void disconnect(IConnection conn, IScope scope) {
    }

    @Override
    public boolean join(IClient client, IScope scope) {
        return true;
    }

    @Override
    public void leave(IClient client, IScope scope) {
    }

    @Override
    public void removeChildScope(IBasicScope scope) {
    }

    @Override
    public boolean serviceCall(IConnection conn, IServiceCall call) {
        IContext context = conn.getScope().getContext();
        if (call.getServiceName() != null) {
            context.getServiceInvoker().invoke(call, context);
        } else {
            context.getServiceInvoker().invoke(call, conn.getScope().getHandler());
        }
        return true;
    }

    @Override
    public boolean start(IScope scope) {
        return true;
    }

    @Override
    public void stop(IScope scope) {
    }

    @Override
    public boolean handleEvent(IEvent event) {
        return false;
    }
}

