/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.Red5;
import org.slf4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Launcher {
    public void launch() throws Exception {
        System.out.printf("Root: %s%nDeploy type: %s%n", System.getProperty("red5.root"), System.getProperty("red5.deployment.type"));
        boolean useLogback = Boolean.valueOf(System.getProperty("useLogback", "true"));
        if (useLogback && System.getProperty("logback.ContextSelector") == null) {
            System.setProperty("logback.ContextSelector", "org.red5.logging.LoggingContextSelector");
        }
        Red5LoggerFactory.setUseLogback(useLogback);
        SLF4JBridgeHandler.install();
        Logger log = Red5LoggerFactory.getLogger(Launcher.class);
        log.info("{} (https://github.com/Red5)", (Object)Red5.getVersion());
        if (log.isDebugEnabled()) {
            log.debug("fmsVer: {}", (Object)Red5.getFMSVersion());
        }
        FileSystemXmlApplicationContext root = new FileSystemXmlApplicationContext(new String[]{"classpath:/red5.xml"}, false);
        root.setClassLoader(Thread.currentThread().getContextClassLoader());
        root.setId("red5.root");
        root.setBeanName("red5.root");
        log.trace("Refreshing root server context");
        root.refresh();
        log.trace("Root server context refreshed");
        log.debug("Launcher exit");
    }
}

