/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api.stream.support;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IServerStream;
import org.red5.server.stream.ServerStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtils.class);
    private static volatile ConcurrentMap<String, IServerStream> serverStreamMap = new ConcurrentHashMap<String, IServerStream>(16, 0.75f, 4);

    public static IServerStream createServerStream(IScope scope, String name) {
        logger.debug("Creating server stream: {} scope: {}", (Object)name, (Object)scope);
        ServerStream stream = new ServerStream();
        stream.setScope(scope);
        stream.setName(name);
        stream.setPublishedName(name);
        String key = scope.getName() + "/" + name;
        serverStreamMap.put(key, stream);
        return stream;
    }

    public static IServerStream getServerStream(IScope scope, String name) {
        logger.debug("Looking up server stream: {} scope: {}", (Object)name, (Object)scope);
        String key = scope.getName() + "/" + name;
        if (serverStreamMap.containsKey(key)) {
            return (IServerStream)serverStreamMap.get(key);
        }
        logger.warn("Server stream not found with key: {}", (Object)key);
        return null;
    }

    public static void putServerStream(IScope scope, String name, IServerStream stream) {
        logger.debug("Putting server stream in the map - name: {} scope: {} stream: {}", name, scope, stream);
        String key = scope.getName() + "/" + name;
        if (!serverStreamMap.containsKey(key)) {
            serverStreamMap.put(key, stream);
        } else {
            logger.warn("Server stream already exists in the map with key: {}", (Object)key);
        }
    }

    public static void removeServerStream(IScope scope, String name) {
        logger.debug("Removing server stream from the map - name: {} scope: {}", (Object)name, (Object)scope);
        String key = scope.getName() + "/" + name;
        if (serverStreamMap.containsKey(key)) {
            serverStreamMap.remove(key);
        } else {
            logger.warn("Server stream did not exist in the map with key: {}", (Object)key);
        }
    }
}

