/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.proxy;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFilter
extends IoFilterAdapter {
    public static final String FORWARD_KEY = "proxy_forward_key";
    protected static Logger log = LoggerFactory.getLogger(ProxyFilter.class);
    protected String name;

    public ProxyFilter(String name) {
        this.name = name;
    }

    @Override
    public void messageReceived(IoFilter.NextFilter next, IoSession session, Object message) throws Exception {
        IoSession forward = (IoSession)session.getAttribute(FORWARD_KEY);
        if (forward != null && forward.isConnected() && message instanceof IoBuffer) {
            IoBuffer buf = (IoBuffer)message;
            if (log.isDebugEnabled()) {
                log.debug("[{}] RAW >> {}", (Object)this.name, (Object)buf.getHexDump());
            }
            IoBuffer copy = IoBuffer.allocate(buf.limit());
            int limit = buf.limit();
            copy.put(buf);
            copy.flip();
            forward.write(copy);
            buf.flip();
            buf.position(0);
            buf.limit(limit);
        }
        next.messageReceived(session, message);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter next, IoSession session) throws Exception {
        IoSession forward = (IoSession)session.getAttribute(FORWARD_KEY);
        if (forward != null && forward.isConnected() && !forward.isClosing()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Closing: {}", (Object)this.name, (Object)forward);
            }
            forward.close(true);
        }
        next.sessionClosed(session);
    }
}

