/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.net.servlet.ServletUtils;
import org.red5.server.util.HttpConnectionUtil;
import org.slf4j.Logger;

public class AMFTunnelServlet
extends HttpServlet {
    private static final long serialVersionUID = -35436145164322090L;
    protected Logger log = Red5LoggerFactory.getLogger(AMFTunnelServlet.class);
    private static final String REQUEST_TYPE = "application/x-amf";
    private static String postAcceptorURL = "http://localhost:8080/gateway";
    private static int connectionTimeout = 30000;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config.getInitParameter("tunnel.acceptor.url") != null) {
            postAcceptorURL = config.getInitParameter("tunnel.acceptor.url");
        }
        this.log.debug("POST acceptor URL: {}", (Object)postAcceptorURL);
        if (config.getInitParameter("tunnel.timeout") != null) {
            connectionTimeout = Integer.valueOf(config.getInitParameter("tunnel.timeout"));
        }
        this.log.debug("POST connection timeout: {}", (Object)postAcceptorURL);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block9: {
            HttpClient client = HttpConnectionUtil.getClient(connectionTimeout);
            HttpPost post = null;
            try {
                post = new HttpPost(postAcceptorURL);
                Object path = req.getContextPath();
                if (path == null) {
                    path = "";
                }
                this.log.debug("Path: {}", path);
                if (req.getPathInfo() != null) {
                    path = (String)path + req.getPathInfo();
                }
                this.log.debug("Path 2: {}", path);
                int reqContentLength = req.getContentLength();
                if (reqContentLength > 0) {
                    this.log.debug("Request content length: {}", (Object)reqContentLength);
                    IoBuffer reqBuffer = IoBuffer.allocate(reqContentLength);
                    ServletUtils.copy(req, reqBuffer.asOutputStream());
                    reqBuffer.flip();
                    post.setEntity(new InputStreamEntity(reqBuffer.asInputStream(), reqContentLength));
                    post.addHeader("Content-Type", REQUEST_TYPE);
                    post.addHeader("Tunnel-request", (String)path);
                    HttpResponse response = client.execute(post);
                    int code = response.getStatusLine().getStatusCode();
                    this.log.debug("HTTP response code: {}", (Object)code);
                    if (code == 200) {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            resp.setContentType(REQUEST_TYPE);
                            byte[] bytes = EntityUtils.toByteArray(entity);
                            IoBuffer resultBuffer = IoBuffer.wrap(bytes);
                            resultBuffer.flip();
                            ServletUtils.copy(resultBuffer.asInputStream(), (OutputStream)resp.getOutputStream());
                            resp.flushBuffer();
                        }
                    } else {
                        resp.sendError(code);
                    }
                } else {
                    resp.sendError(400);
                }
            }
            catch (Exception ex) {
                this.log.error("", ex);
                if (post == null) break block9;
                post.abort();
            }
        }
    }
}

