/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.filter;

import org.red5.server.messaging.IFilter;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamBandwidthController
implements IFilter,
IPipeConnectionListener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(StreamBandwidthController.class);
    public static final String KEY = StreamBandwidthController.class.getName();
    private IPipe providerPipe;
    private IPipe consumerPipe;
    private Thread puller;
    private volatile boolean isStarted;

    @Override
    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case PROVIDER_CONNECT_PULL: {
                if (event.getProvider() == this || this.providerPipe != null) break;
                this.providerPipe = (IPipe)event.getSource();
                break;
            }
            case PROVIDER_DISCONNECT: {
                if (event.getSource() != this.providerPipe) break;
                this.providerPipe = null;
                break;
            }
            case CONSUMER_CONNECT_PUSH: {
                if (event.getConsumer() == this || this.consumerPipe != null) break;
                this.consumerPipe = (IPipe)event.getSource();
                break;
            }
            case CONSUMER_DISCONNECT: {
                if (event.getSource() != this.consumerPipe) break;
                this.consumerPipe = null;
                break;
            }
        }
    }

    @Override
    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
    }

    @Override
    public void run() {
        while (this.isStarted && this.providerPipe != null && this.consumerPipe != null) {
            try {
                IMessage message = this.providerPipe.pullMessage();
                if (log.isDebugEnabled()) {
                    log.debug("got message: {}", (Object)message);
                }
                this.consumerPipe.pushMessage(message);
            }
            catch (Exception e) {
                log.warn("Exception in pull and push", e);
                break;
            }
        }
        this.isStarted = false;
    }

    public void start() {
        this.startThread();
    }

    public void close() {
        this.isStarted = false;
    }

    private void startThread() {
        if (!this.isStarted && this.providerPipe != null && this.consumerPipe != null) {
            this.puller = new Thread((Runnable)this, KEY);
            this.puller.setDaemon(true);
            this.isStarted = true;
            this.puller.start();
        }
    }
}

