/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadBuffer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(1536);

    public int getBufferSize() {
        return this.buffer.size();
    }

    public void addBuffer(byte[] in) {
        this.log.debug("Adding buffer - first: {} length: {}", (Object)in[0], (Object)in.length);
        this.buffer.writeBytes(in);
    }

    public void addBuffer(IoBuffer in) {
        byte[] tmp = new byte[in.remaining()];
        in.get(tmp);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding buffer - first: {} length: {} total buffered: {}", new Object[]{tmp[0], tmp.length, this.buffer.size()});
        }
        this.buffer.writeBytes(tmp);
    }

    public IoBuffer getBufferAsIoBuffer() {
        byte[] arr = this.buffer.toByteArray();
        this.buffer.reset();
        return IoBuffer.wrap((byte[])arr);
    }

    public byte[] getBuffer() {
        byte[] arr = this.buffer.toByteArray();
        this.buffer.reset();
        return arr;
    }

    public byte[] getBuffer(int length) {
        ByteBuffer buf = ByteBuffer.wrap(this.buffer.toByteArray());
        this.buffer.reset();
        byte[] slice = new byte[length];
        buf.get(slice);
        byte[] remaining = new byte[buf.remaining()];
        buf.get(remaining);
        this.buffer.writeBytes(remaining);
        return slice;
    }

    public void clearBuffer() {
        this.buffer.reset();
    }
}

