/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventListener;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.red5.server.so.SharedObjectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedObjectMessage
extends BaseEvent
implements ISharedObjectMessage {
    private static Logger log = LoggerFactory.getLogger(SharedObjectMessage.class);
    private static final long serialVersionUID = -8128704039659990049L;
    private String name;
    private ConcurrentSkipListSet<ISharedObjectEvent> events = new ConcurrentSkipListSet();
    private volatile int version;
    private boolean persistent;

    public SharedObjectMessage() {
    }

    public SharedObjectMessage(String name, int version, boolean persistent) {
        this(null, name, version, persistent);
    }

    public SharedObjectMessage(IEventListener source, String name, int version, boolean persistent) {
        super(IEvent.Type.SHARED_OBJECT, source);
        this.name = name;
        this.version = version;
        this.persistent = persistent;
    }

    public void reset() {
        this.version = 0;
        this.events.clear();
    }

    @Override
    public byte getDataType() {
        return 19;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    protected void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public boolean addEvent(ISharedObjectEvent.Type type, String key, Object value) {
        return this.events.add(new SharedObjectEvent(type, key, value));
    }

    @Override
    public boolean addEvent(ISharedObjectEvent event) {
        return this.events.add(event);
    }

    public void addEvents(List<ISharedObjectEvent> events) {
        this.events.addAll(events);
    }

    public void addEvents(Queue<ISharedObjectEvent> events) {
        this.events.addAll(events);
    }

    public void addEvents(Set<ISharedObjectEvent> events) {
        this.events.addAll(events);
    }

    @Override
    public Set<ISharedObjectEvent> getEvents() {
        return this.events;
    }

    @Override
    public void clear() {
        this.events.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public IEvent.Type getType() {
        return IEvent.Type.SHARED_OBJECT;
    }

    @Override
    public Object getObject() {
        return this.getEvents();
    }

    @Override
    protected void releaseInternal() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(": ").append(this.name).append(" v=").append(this.version).append(" persistent=").append(this.persistent).append(" { ");
        for (ISharedObjectEvent event : this.events) {
            sb.append(event);
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.name = in.readUTF();
        this.version = in.readInt();
        this.persistent = in.readBoolean();
        Object o = in.readObject();
        if (o != null) {
            log.trace("events type: {}", (Object)o.getClass().getName());
            if (o instanceof ConcurrentSkipListSet) {
                this.events = (ConcurrentSkipListSet)o;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("readExternal: {}", (Object)this.toString());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (log.isTraceEnabled()) {
            log.trace("writeExternal: {}", (Object)this.toString());
        }
        out.writeUTF(this.name);
        out.writeInt(this.version);
        out.writeBoolean(this.persistent);
        out.writeObject(this.events);
    }
}

