/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.consumer;

import java.util.Comparator;
import org.red5.codec.AudioCodec;
import org.red5.codec.VideoCodec;
import org.red5.server.stream.consumer.QueuedMediaData;

public class QueuedMediaDataComparator
implements Comparator<QueuedMediaData> {
    @Override
    public int compare(QueuedMediaData o1, QueuedMediaData o2) {
        byte type2;
        int result = 0;
        byte type1 = o1.tag.getDataType();
        if (type1 == (type2 = o2.tag.getDataType())) {
            byte[] buf1 = o1.tag.getBody().array();
            byte[] buf2 = o2.tag.getBody().array();
            if (type1 == 8) {
                if (buf1.length > 0 && buf2.length > 0 && (buf1[0] & 0xFF & 0xF0) >> 4 == AudioCodec.AAC.getId()) {
                    if (buf1[1] == 0 && buf2[1] != 0) {
                        result = -1;
                    } else if (buf1[1] != 0 && buf2[1] == 0) {
                        result = 1;
                    }
                }
            } else if (type1 == 9 && (buf1[0] & 0xFF & 0xF) == VideoCodec.AVC.getId()) {
                if (buf1[1] == 0 && buf2[1] != 0) {
                    result = -1;
                } else if (buf1[1] != 0 && buf2[1] == 0) {
                    result = 1;
                }
            }
            if (o1.tag.getTimestamp() > o2.tag.getTimestamp()) {
                ++result;
            } else if (o1.tag.getTimestamp() < o2.tag.getTimestamp()) {
                --result;
            }
        } else if (o1.tag.getTimestamp() > o2.tag.getTimestamp()) {
            result = 1;
        } else if (o1.tag.getTimestamp() < o2.tag.getTimestamp()) {
            result = -1;
        }
        return result;
    }
}

