/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum AudioCodec {
    PCM(0),
    ADPCM(1),
    MP3(2),
    PCM_LE(3),
    NELLY_MOSER_16K(4),
    NELLY_MOSER_8K(5),
    NELLY_MOSER(6),
    PCM_ALAW(7),
    PCM_MULAW(8),
    RESERVED(9),
    AAC(10),
    SPEEX(11),
    MP2(12),
    OPUS(13),
    MP3_8K(14),
    DEVICE_SPECIFIC(15);

    private static final EnumSet<AudioCodec> configured;
    private static final Map<Byte, AudioCodec> map;
    private byte id;

    private AudioCodec(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static AudioCodec valueOfById(int id) {
        return map.get((byte)id);
    }

    public static EnumSet<AudioCodec> getConfigured() {
        return configured;
    }

    static {
        configured = EnumSet.of(AAC, OPUS);
        map = new HashMap<Byte, AudioCodec>();
        for (AudioCodec codec : AudioCodec.values()) {
            map.put(codec.id, codec);
        }
    }
}

