/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.red5.io.matroska.ParserUtils;
import org.red5.io.matroska.VINT;
import org.red5.io.matroska.dtd.Tag;

public class BinaryTag
extends Tag {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private byte[] value;

    public BinaryTag(String name, VINT id) throws IOException {
        super(name, id);
    }

    public BinaryTag(String name, VINT id, VINT size, InputStream inputStream) throws IOException {
        super(name, id, size, inputStream);
    }

    @Override
    public void parse(InputStream inputStream) throws IOException {
        this.value = ParserUtils.parseBinary(inputStream, (int)this.getSize());
    }

    @Override
    protected void putValue(ByteBuffer bb) throws IOException {
        bb.put(this.value);
    }

    public byte[] getValue() {
        return this.value;
    }

    public BinaryTag setValue(byte[] value) {
        this.value = value;
        this.size = VINT.fromValue(value.length);
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + " = binary " + (int)this.getSize();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

