/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.rtp;

import java.util.LinkedList;
import org.bouncycastle.util.Arrays;
import org.red5.io.utils.LEB128;

public class AV1Packet {
    private static final byte zMask = -128;
    private static final byte zBitshift = 7;
    private static final byte yMask = 64;
    private static final byte yBitshift = 6;
    private static final byte wMask = 48;
    private static final byte wBitshift = 4;
    private static final byte nMask = 8;
    private static final byte nBitshift = 3;
    private static final int av1PayloaderHeadersize = 1;
    public boolean Z;
    public boolean Y;
    public int W;
    public boolean N;
    public LinkedList<byte[]> OBUElements = new LinkedList();

    public static LinkedList<byte[]> marshal(int mtu, byte[] payload) {
        LinkedList<byte[]> payloads = new LinkedList<byte[]>();
        int maxFragmentSize = mtu - 1 - 2;
        int payloadDataRemaining = payload.length;
        int payloadDataIndex = 0;
        if (Math.min(maxFragmentSize, payloadDataRemaining) > 0) {
            while (payloadDataRemaining > 0) {
                int currentFragmentSize = Math.min(maxFragmentSize, payloadDataRemaining);
                int leb128Size = 1;
                if (currentFragmentSize >= 127) {
                    leb128Size = 2;
                }
                byte[] out = new byte[1 + leb128Size + currentFragmentSize];
                int leb128Value = LEB128.encode(currentFragmentSize);
                if (leb128Size == 1) {
                    out[1] = (byte)leb128Value;
                } else {
                    out[1] = (byte)(leb128Value >> 8);
                    out[2] = (byte)leb128Value;
                }
                System.arraycopy(payload, payloadDataIndex, out, 1 + leb128Size, currentFragmentSize);
                payloads.add(out);
                payloadDataRemaining -= currentFragmentSize;
                payloadDataIndex += currentFragmentSize;
                if (payloads.size() > 1) {
                    out[0] = (byte)(out[0] ^ 0xFFFFFF80);
                }
                if (payloadDataRemaining == 0) continue;
                out[0] = (byte)(out[0] ^ 0x40);
            }
        }
        return payloads;
    }

    public boolean unmarshal(byte[] payload) {
        System.out.printf("Payload length: %d%n", payload.length);
        if (payload != null && payload.length > 1) {
            this.Z = (payload[0] & 0xFFFFFF80) >> 7 != 0;
            this.Y = (payload[0] & 0x40) >> 6 != 0;
            this.N = (payload[0] & 8) >> 3 != 0;
            this.W = (payload[0] & 0x30) >> 4;
            System.out.printf("Payload Z: %b Y: %b N: %b W: %d%n", this.Z, this.Y, this.N, this.W);
            if (!this.Z && !this.N) {
                int currentIndex = 1;
                int bytesRead = 0;
                int obuElementLength = (payload[currentIndex] & 0x3F) << 8 | payload[currentIndex + 1];
                bytesRead = 2;
                System.out.printf("Index: %d and obu element length: %d bytes read: %d%n", currentIndex, obuElementLength, bytesRead);
                int i = 1;
                while (currentIndex < payload.length) {
                    if (i == this.W) {
                        bytesRead = 0;
                        obuElementLength = payload.length - currentIndex;
                    } else {
                        int encodedLength = 0;
                        while (currentIndex < payload.length) {
                            encodedLength |= payload[currentIndex] & 0xFF;
                            if ((payload[currentIndex] & 0x80) == 0) {
                                obuElementLength = LEB128.decode(encodedLength);
                                bytesRead = currentIndex + 1;
                                break;
                            }
                            encodedLength <<= 8;
                            ++currentIndex;
                        }
                    }
                    if ((currentIndex += bytesRead) + obuElementLength > payload.length) {
                        System.out.println("Index and obu element length exceed payload size");
                        return false;
                    }
                    this.OBUElements.add(Arrays.copyOfRange((byte[])payload, (int)currentIndex, (int)(currentIndex + obuElementLength)));
                    System.out.println("OBU element added");
                    currentIndex += obuElementLength;
                    ++i;
                }
                return true;
            }
            System.out.println("Non-fragment, non-keyframe");
        }
        return false;
    }

    public LinkedList<byte[]> getOBUElements() {
        return this.OBUElements;
    }

    public static void main(String[] args) {
        int mtu = 5;
        byte[] in = new byte[]{1};
        byte[][] out = new byte[][]{{0, 1, 1}};
        LinkedList<byte[]> outList1 = AV1Packet.marshal(mtu, in);
        System.out.printf("Equal? %b%n", Arrays.areEqual((byte[])out[0], (byte[])outList1.get(0)));
        byte[] in2 = new byte[]{0, 1, 2, 3, 4, 4, 5};
        byte[][] out2 = new byte[][]{{64, 2, 0, 1}, {-64, 2, 2, 3}, {-64, 2, 4, 4}, {-128, 1, 5}};
        LinkedList<byte[]> outList2 = AV1Packet.marshal(mtu, in2);
        System.out.printf("Marshaled entries: %d%n", outList2.size());
        System.out.printf("Equal? %b%n", Arrays.areEqual((byte[])out2[0], (byte[])outList2.get(0)));
        System.out.printf("Equal? %b%n", Arrays.areEqual((byte[])out2[1], (byte[])outList2.get(1)));
        System.out.printf("Equal? %b%n", Arrays.areEqual((byte[])out2[2], (byte[])outList2.get(2)));
        System.out.printf("Equal? %b%n", Arrays.areEqual((byte[])out2[3], (byte[])outList2.get(3)));
        AV1Packet p = new AV1Packet();
        byte[] marshaled = new byte[]{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};
        System.out.printf("Unmarshaled: %b%n", p.unmarshal(marshaled));
        System.out.println("Depacketized payload: " + p.getOBUElements());
        if (!p.Z && p.Y && p.N && p.W == 2) {
            System.out.println("Unmarshaled flags are correct");
        }
    }
}

