/*
 * Decompiled with CFR 0.152.
 */
package org.red5.daemon;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.red5.server.Bootstrap;
import org.red5.server.Shutdown;

public class EngineLauncher
implements Daemon {
    private static EngineLauncher engineLauncherInstance = new EngineLauncher();
    private static AtomicBoolean stopped = new AtomicBoolean(false);
    private static String[] commandLineArgs;

    public static void main(String[] args) {
        System.out.printf("Args: %s%n", Arrays.toString(args));
        commandLineArgs = args;
        engineLauncherInstance.initialize();
        Scanner sc = new Scanner(System.in);
        System.out.printf("Enter 'stop' to halt: ", new Object[0]);
        while (!sc.nextLine().toLowerCase().equals("stop")) {
        }
        if (!stopped.get()) {
            engineLauncherInstance.terminate();
        }
        sc.close();
    }

    public static void windowsService(String[] args) {
        String cmd = "start";
        if (args.length > 0) {
            cmd = args[0];
        }
        if ("start".equals(cmd)) {
            engineLauncherInstance.windowsStart();
        } else {
            commandLineArgs = args;
            engineLauncherInstance.windowsStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowsStart() {
        System.out.println("windowsStart called");
        this.initialize();
        while (!stopped.get()) {
            EngineLauncher engineLauncher = this;
            synchronized (engineLauncher) {
                try {
                    this.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowsStop() {
        System.out.println("windowsStop called");
        this.terminate();
        EngineLauncher engineLauncher = this;
        synchronized (engineLauncher) {
            this.notify();
        }
    }

    public void init(DaemonContext ctx) throws Exception {
        System.out.println("Daemon init");
        commandLineArgs = ctx.getArguments();
        System.out.printf("Args: %s%n", Arrays.toString(commandLineArgs));
    }

    public void start() {
        System.out.println("Daemon start");
        this.initialize();
    }

    public void stop() {
        System.out.println("Daemon stop");
        this.terminate();
    }

    public void destroy() {
        System.out.println("Daemon destroy");
    }

    private void initialize() {
        if (!stopped.get()) {
            System.out.printf("Starting Red5 with args: %s%n", Arrays.toString(commandLineArgs));
            try {
                Bootstrap.main(commandLineArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void terminate() {
        if (stopped.compareAndSet(false, true)) {
            System.out.printf("Stopping Red5 with args: %s%n", Arrays.toString(commandLineArgs));
            if (commandLineArgs == null || commandLineArgs.length < 2) {
                String port = "9999";
                if (commandLineArgs.length >= 1) {
                    port = commandLineArgs[0];
                }
                String token = "cafebeef";
                try {
                    File tokenFile = Paths.get("shutdown.token", new String[0]).toFile();
                    RandomAccessFile raf = new RandomAccessFile(tokenFile, "r");
                    byte[] buf = new byte[36];
                    raf.readFully(buf);
                    token = new String(buf);
                    System.out.printf("Token loaded: %s%n", token);
                    raf.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                commandLineArgs = new String[]{port, token};
            }
            Shutdown.main(commandLineArgs);
            System.out.println("Red5 stopped");
        }
    }
}

