/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.openmbean.CompositeData;
import org.red5.io.utils.ConversionUtils;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.ICastingAttributeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeStore
implements ICastingAttributeStore {
    protected static Logger log = LoggerFactory.getLogger(AttributeStore.class);
    protected Map<String, Object> attributes = new ConcurrentHashMap<String, Object>(1, 0.5f, Runtime.getRuntime().availableProcessors());

    public AttributeStore() {
    }

    public AttributeStore(Map<String, Object> values) {
        this.setAttributes(values);
    }

    public AttributeStore(IAttributeStore values) {
        this.setAttributes(values);
    }

    protected Map<String, Object> filterNull(Map<String, Object> values) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        values.forEach((key, value) -> {
            if (key != null && value != null) {
                result.put((String)key, value);
            }
        });
        return result;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (name == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    @Override
    public boolean hasAttribute(Enum<?> enm) {
        return this.hasAttribute(enm.name());
    }

    @Override
    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Object getAttribute(Enum<?> enm) {
        return this.getAttribute(enm.name());
    }

    @Override
    public Object getAttribute(String name, Object defaultValue) {
        if (name == null) {
            return null;
        }
        if (defaultValue == null) {
            throw new NullPointerException("the default value may not be null");
        }
        Object result = this.attributes.put(name, defaultValue);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public boolean setAttribute(String name, Object value) {
        log.trace("setAttribute({}, {})", (Object)name, value);
        boolean result = false;
        if (name != null && value != null) {
            Object previous = this.attributes.putIfAbsent(name, value);
            if (previous != null) {
                if (value instanceof Collection) {
                    Collection prevCollection = (Collection)previous;
                    Collection newCollection = (Collection)value;
                    for (Object newCollectionEntry : newCollection) {
                        int freq = Collections.frequency(prevCollection, newCollectionEntry);
                        if (freq != 0) continue;
                        result = true;
                        break;
                    }
                } else if (value instanceof Map) {
                    Map prevMap = (Map)previous;
                    Map newMap = (Map)value;
                    if (!prevMap.keySet().containsAll(newMap.keySet())) {
                        result = true;
                    } else {
                        for (Map.Entry newMapEntry : newMap.entrySet()) {
                            Object prevValue = prevMap.get(newMapEntry.getKey());
                            if (prevValue == null) {
                                result = true;
                            } else {
                                if (prevValue.equals(newMapEntry.getValue())) continue;
                                result = true;
                            }
                            break;
                        }
                    }
                } else {
                    boolean bl = result = !value.equals(previous);
                    if (log.isTraceEnabled()) {
                        log.trace("Equality check - modified: {} previous: {} new: {}", new Object[]{result, previous, value});
                        log.trace("Class: {} {}", previous.getClass(), value.getClass());
                    }
                    if (result && ConversionUtils.isBaseTypeOrArray((Object)previous)) {
                        if (this.attributes.replace(name, previous, value)) {
                            log.trace("Value replaced");
                        } else {
                            log.trace("Value replacement failed");
                        }
                    }
                }
            } else {
                result = true;
            }
            if (log.isTraceEnabled()) {
                log.trace("{}", this.attributes);
            }
        }
        return result;
    }

    @Override
    public boolean setAttribute(Enum<?> enm, Object value) {
        return this.setAttribute(enm.name(), value);
    }

    @Override
    public boolean setAttributes(Map<String, Object> values) {
        this.attributes.putAll(this.filterNull(values));
        return true;
    }

    @Override
    public boolean setAttributes(IAttributeStore values) {
        return this.setAttributes(values.getAttributes());
    }

    @Override
    public boolean removeAttribute(String name) {
        if (name != null) {
            return this.attributes.remove(name) != null;
        }
        return false;
    }

    @Override
    public boolean removeAttribute(Enum<?> enm) {
        return this.removeAttribute(enm.name());
    }

    @Override
    public void removeAttributes() {
        this.attributes.clear();
    }

    @Override
    public int size() {
        return this.attributes != null ? this.attributes.size() : 0;
    }

    @Override
    public Boolean getBoolAttribute(String name) {
        return (Boolean)this.getAttribute(name);
    }

    @Override
    public Byte getByteAttribute(String name) {
        return (Byte)this.getAttribute(name);
    }

    @Override
    public Double getDoubleAttribute(String name) {
        return (Double)this.getAttribute(name);
    }

    @Override
    public Integer getIntAttribute(String name) {
        return (Integer)this.getAttribute(name);
    }

    @Override
    public List<?> getListAttribute(String name) {
        return (List)this.getAttribute(name);
    }

    @Override
    public Long getLongAttribute(String name) {
        return (Long)this.getAttribute(name);
    }

    @Override
    public Map<?, ?> getMapAttribute(String name) {
        return (Map)this.getAttribute(name);
    }

    @Override
    public Set<?> getSetAttribute(String name) {
        return (Set)this.getAttribute(name);
    }

    @Override
    public Short getShortAttribute(String name) {
        return (Short)this.getAttribute(name);
    }

    @Override
    public String getStringAttribute(String name) {
        return (String)this.getAttribute(name);
    }

    public static AttributeStore from(CompositeData cd) {
        AttributeStore instance = null;
        if (cd.containsKey("attributes")) {
            Object cn = cd.get("attributes");
            if (cn != null) {
                if (cn instanceof IAttributeStore) {
                    instance = new AttributeStore((IAttributeStore)cn);
                } else if (cn instanceof Map) {
                    instance = new AttributeStore((Map)cn);
                }
            } else {
                instance = new AttributeStore();
            }
        } else {
            instance = new AttributeStore();
        }
        return instance;
    }
}

