/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.codec;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.red5.server.api.IConnection;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;

public class RTMP {
    public static final String[] states = new String[]{"connect", "handshake", "connected", "error", "disconnecting", "disconnected"};
    public static final byte STATE_CONNECT = 0;
    public static final byte STATE_HANDSHAKE = 1;
    public static final byte STATE_CONNECTED = 2;
    public static final byte STATE_ERROR = 3;
    public static final byte STATE_DISCONNECTING = 4;
    public static final byte STATE_DISCONNECTED = 5;
    public static final byte STATE_EDGE_CONNECT_ORIGIN_SENT = 17;
    public static final byte STATE_ORIGIN_CONNECT_FORWARDED = 18;
    public static final byte STATE_EDGE_DISCONNECTING = 19;
    private volatile byte state = 0;
    private boolean encrypted = false;
    private final transient ConcurrentMap<Integer, ChannelInfo> channels = new ConcurrentHashMap<Integer, ChannelInfo>(3, 0.9f, 1);
    private int readChunkSize = 128;
    private int writeChunkSize = 128;
    private IConnection.Encoding encoding = IConnection.Encoding.AMF0;

    private ChannelInfo getChannelInfo(int channelId) {
        ChannelInfo info = this.channels.putIfAbsent(channelId, new ChannelInfo());
        if (info == null) {
            info = (ChannelInfo)this.channels.get(channelId);
        }
        return info;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public byte getState() {
        return this.state;
    }

    private void freePacket(Packet packet) {
        if (packet != null && packet.getData() != null) {
            packet.clearData();
        }
    }

    private void freeChannels() {
        for (ChannelInfo info : this.channels.values()) {
            this.freePacket(info.getReadPacket());
            this.freePacket(info.getWritePacket());
        }
        this.channels.clear();
    }

    public void setState(byte state) {
        this.state = state;
        if (state == 5) {
            this.freeChannels();
        }
    }

    public void setLastReadHeader(int channelId, Header header) {
        this.getChannelInfo(channelId).setReadHeader(header);
    }

    public Header getLastReadHeader(int channelId) {
        return this.getChannelInfo(channelId).getReadHeader();
    }

    public void setLastWriteHeader(int channelId, Header header) {
        this.getChannelInfo(channelId).setWriteHeader(header);
    }

    public Header getLastWriteHeader(int channelId) {
        return this.getChannelInfo(channelId).getWriteHeader();
    }

    public void setLastReadPacket(int channelId, Packet packet) {
        ChannelInfo info = this.getChannelInfo(channelId);
        Packet prevPacket = info.getReadPacket();
        info.setReadPacket(packet);
        this.freePacket(prevPacket);
    }

    public Packet getLastReadPacket(int channelId) {
        return this.getChannelInfo(channelId).getReadPacket();
    }

    public void setLastWritePacket(int channelId, Packet packet) {
    }

    public Packet getLastWritePacket(int channelId) {
        return this.getChannelInfo(channelId).getWritePacket();
    }

    public int getReadChunkSize() {
        return this.readChunkSize;
    }

    public void setReadChunkSize(int readChunkSize) {
        this.readChunkSize = readChunkSize;
    }

    public int getWriteChunkSize() {
        return this.writeChunkSize;
    }

    public void setWriteChunkSize(int writeChunkSize) {
        this.writeChunkSize = writeChunkSize;
    }

    public IConnection.Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(IConnection.Encoding encoding) {
        this.encoding = encoding;
    }

    public void setLastFullTimestampWritten(int channelId, int timer) {
        this.getChannelInfo(channelId).setWriteTimestamp(timer);
    }

    public int getLastFullTimestampWritten(int channelId) {
        return this.getChannelInfo(channelId).getWriteTimestamp();
    }

    public void setLastReadPacketHeader(int channelId, Header header) {
        this.getChannelInfo(channelId).setReadPacketHeader(header);
    }

    public Header getLastReadPacketHeader(int channelId) {
        return this.getChannelInfo(channelId).getReadPacketHeader();
    }

    LiveTimestampMapping getLastTimestampMapping(int channelId) {
        return this.getChannelInfo(channelId).getLiveTimestamp();
    }

    void setLastTimestampMapping(int channelId, LiveTimestampMapping mapping) {
        this.getChannelInfo(channelId).setLiveTimestamp(mapping);
    }

    void clearLastTimestampMapping(int ... channelIds) {
        for (int channelId : channelIds) {
            this.getChannelInfo(channelId).setLiveTimestamp(null);
        }
    }

    public String toString() {
        return "RTMP [state=" + states[this.state] + ", encrypted=" + this.encrypted + ", readChunkSize=" + this.readChunkSize + ", writeChunkSize=" + this.writeChunkSize + ", encoding=" + this.encoding + "]";
    }

    private final class ChannelInfo {
        private Header readHeader;
        private Header writeHeader;
        private Header readPacketHeader;
        private Packet readPacket;
        private Packet writePacket;
        private int writeTimestamp;
        private LiveTimestampMapping liveTimestamp;

        private ChannelInfo() {
        }

        public Header getReadHeader() {
            return this.readHeader;
        }

        public void setReadHeader(Header readHeader) {
            this.readHeader = readHeader;
        }

        public Header getWriteHeader() {
            return this.writeHeader;
        }

        public void setWriteHeader(Header writeHeader) {
            this.writeHeader = writeHeader;
        }

        public Header getReadPacketHeader() {
            return this.readPacketHeader;
        }

        public void setReadPacketHeader(Header readPacketHeader) {
            this.readPacketHeader = readPacketHeader;
        }

        public Packet getReadPacket() {
            return this.readPacket;
        }

        public void setReadPacket(Packet readPacket) {
            this.readPacket = readPacket;
        }

        public Packet getWritePacket() {
            return this.writePacket;
        }

        public void setWritePacket(Packet writePacket) {
            this.writePacket = writePacket;
        }

        public int getWriteTimestamp() {
            return this.writeTimestamp;
        }

        public void setWriteTimestamp(int writeTimestamp) {
            this.writeTimestamp = writeTimestamp;
        }

        public LiveTimestampMapping getLiveTimestamp() {
            return this.liveTimestamp;
        }

        public void setLiveTimestamp(LiveTimestampMapping liveTimestamp) {
            this.liveTimestamp = liveTimestamp;
        }
    }

    final class LiveTimestampMapping {
        private final long clockStartTime;
        private final long streamStartTime;
        private boolean keyFrameNeeded;
        private long lastStreamTime;

        public LiveTimestampMapping(long clockStartTime, long streamStartTime) {
            this.clockStartTime = clockStartTime;
            this.streamStartTime = streamStartTime;
            this.keyFrameNeeded = true;
            this.lastStreamTime = streamStartTime;
        }

        public long getStreamStartTime() {
            return this.streamStartTime;
        }

        public long getClockStartTime() {
            return this.clockStartTime;
        }

        public void setKeyFrameNeeded(boolean keyFrameNeeded) {
            this.keyFrameNeeded = keyFrameNeeded;
        }

        public boolean isKeyFrameNeeded() {
            return this.keyFrameNeeded;
        }

        public long getLastStreamTime() {
            return this.lastStreamTime;
        }

        public void setLastStreamTime(long lastStreamTime) {
            this.lastStreamTime = lastStreamTime;
        }
    }
}

