/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.plugin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.plugin.IRed5Plugin;
import org.slf4j.Logger;

public class PluginRegistry {
    private static Logger log = Red5LoggerFactory.getLogger(PluginRegistry.class, "plugins");
    private static volatile ConcurrentMap<String, IRed5Plugin> plugins = new ConcurrentHashMap<String, IRed5Plugin>(3, 0.9f, 1);
    private static final ReadWriteLock pluginLock = new ReentrantReadWriteLock();
    private static final Lock pluginReadLock = pluginLock.readLock();
    private static final Lock pluginWriteLock = pluginLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(IRed5Plugin plugin) {
        block6: {
            log.debug("Register plugin: {}", (Object)plugin);
            String pluginName = plugin.getName();
            pluginWriteLock.lock();
            try {
                if (plugins.containsKey(pluginName)) {
                    IRed5Plugin oldPlugin = (IRed5Plugin)plugins.get(pluginName);
                    if (plugin.equals(oldPlugin)) break block6;
                    try {
                        oldPlugin.doStop();
                    }
                    catch (Exception e) {
                        log.warn("Exception caused when stopping old plugin", (Throwable)e);
                    }
                    plugins.replace(pluginName, plugin);
                    break block6;
                }
                plugins.put(pluginName, plugin);
            }
            finally {
                pluginWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(IRed5Plugin plugin) {
        log.debug("Unregister plugin: {}", (Object)plugin);
        pluginWriteLock.lock();
        try {
            if (plugins.containsValue(plugin)) {
                boolean removed = false;
                for (Map.Entry f : plugins.entrySet()) {
                    if (plugin.equals(f.getValue())) {
                        log.debug("Removing {}", (Object)plugin);
                        plugins.remove(f.getKey());
                        removed = true;
                        break;
                    }
                    log.debug("Not equal - {} {}", (Object)plugin, f.getValue());
                }
                if (!removed) {
                    log.debug("Last try to remove the plugin");
                    plugins.remove(plugin.getName());
                }
            } else {
                log.warn("Plugin is not registered {}", (Object)plugin);
            }
        }
        finally {
            pluginWriteLock.unlock();
        }
    }

    public static IRed5Plugin getPlugin(String pluginName) {
        IRed5Plugin plugin = null;
        pluginReadLock.lock();
        try {
            plugin = (IRed5Plugin)plugins.get(pluginName);
        }
        finally {
            pluginReadLock.unlock();
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() throws Exception {
        log.info("Destroying and cleaning up {} plugins", (Object)plugins.size());
        pluginReadLock.lock();
        try {
            for (Map.Entry pluginEntry : plugins.entrySet()) {
                IRed5Plugin plugin = (IRed5Plugin)pluginEntry.getValue();
                try {
                    plugin.doStop();
                }
                catch (Exception ex) {
                    if (plugin != null) {
                        log.warn("Plugin stop failed for: {}", (Object)plugin.getName(), (Object)ex);
                        continue;
                    }
                    log.warn("Plugin stop failed", (Throwable)ex);
                }
            }
        }
        finally {
            pluginReadLock.unlock();
        }
        plugins.clear();
    }
}

