/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.IVideoStreamCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoCodecFactory {
    public static final String KEY = "videoCodecFactory";
    private static Logger log = LoggerFactory.getLogger(VideoCodecFactory.class);
    private static List<IVideoStreamCodec> codecs = new ArrayList<IVideoStreamCodec>(3);

    public void setCodecs(List<IVideoStreamCodec> codecs) {
        VideoCodecFactory.codecs = codecs;
    }

    public static IVideoStreamCodec getVideoCodec(IoBuffer data) {
        IVideoStreamCodec result = null;
        int codecId = data.get() & 0xF;
        try {
            switch (codecId) {
                case 2: {
                    result = (IVideoStreamCodec)Class.forName("org.red5.codec.SorensonVideo").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 3: {
                    result = (IVideoStreamCodec)Class.forName("org.red5.codec.ScreenVideo").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 6: {
                    result = (IVideoStreamCodec)Class.forName("org.red5.codec.ScreenVideo2").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 7: {
                    result = (IVideoStreamCodec)Class.forName("org.red5.codec.AVCVideo").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 8: {
                    result = (IVideoStreamCodec)Class.forName("org.red5.codec.VP8Video").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 9: {
                    result = (IVideoStreamCodec)Class.forName("org.red5.codec.VP9Video").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 10: {
                    result = (IVideoStreamCodec)Class.forName("org.red5.codec.AV1Video").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 11: {
                    result = (IVideoStreamCodec)Class.forName("org.red5.codec.MPEG1Video").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 12: {
                    result = (IVideoStreamCodec)Class.forName("org.red5.codec.HEVCVideo").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            log.error("Error creating codec instance", (Throwable)ex);
        }
        data.rewind();
        if (result == null) {
            for (IVideoStreamCodec storedCodec : codecs) {
                IVideoStreamCodec codec;
                try {
                    codec = (IVideoStreamCodec)storedCodec.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    log.error("Could not create video codec instance", (Throwable)e);
                    continue;
                }
                if (!codec.canHandleData(data)) continue;
                result = codec;
                break;
            }
        }
        return result;
    }
}

