/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketScope;
import org.red5.net.websocket.listener.DefaultWebSocketDataListener;
import org.red5.net.websocket.listener.IWebSocketDataListener;
import org.red5.net.websocket.listener.IWebSocketScopeListener;
import org.red5.net.websocket.model.WebSocketEvent;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketScopeManager {
    private static final Logger log = LoggerFactory.getLogger(WebSocketScopeManager.class);
    private static final byte[] PING_BYTES = "PING!".getBytes();
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private Future<?> pingFuture;
    private IScope appScope;
    private ConcurrentMap<String, WebSocketScope> scopes = new ConcurrentHashMap<String, WebSocketScope>();
    private CopyOnWriteArraySet<IWebSocketScopeListener> scopeListeners = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> activeRooms = new CopyOnWriteArraySet();
    protected boolean copyListeners = true;
    public static long websocketPingInterval = 5000L;

    public void addListener(IWebSocketScopeListener listener) {
        this.scopeListeners.add(listener);
    }

    public void removeListener(IWebSocketScopeListener listener) {
        this.scopeListeners.remove(listener);
    }

    public boolean isEnabled(String path) {
        if (path.startsWith("/")) {
            int roomSlashPos = path.indexOf(47, 1);
            path = roomSlashPos == -1 ? path.substring(1) : path.substring(1, roomSlashPos);
        }
        boolean enabled = this.activeRooms.contains(path);
        log.debug("Enabled check on path: {} enabled: {}", (Object)path, (Object)enabled);
        return enabled;
    }

    public void addScope(IScope scope) {
        String app = scope.getName();
        this.activeRooms.add(app);
        IContext ctx = scope.getContext();
        if (ctx != null && ctx.hasBean("webSocketScopeDefault")) {
            log.debug("WebSocket scope found in context");
            WebSocketScope wsScope = (WebSocketScope)scope.getContext().getBean("webSocketScopeDefault");
            if (wsScope != null) {
                log.trace("Default WebSocketScope has {} listeners", (Object)wsScope.getListeners().size());
            }
            this.scopes.put(String.format("/%s", app), wsScope);
        } else {
            log.debug("Creating a new scope");
            WebSocketScope wsScope = new WebSocketScope();
            wsScope.setScope(scope);
            wsScope.setPath(String.format("/%s", app));
            if (wsScope.getListeners().isEmpty()) {
                log.debug("adding default listener");
                wsScope.addListener(new DefaultWebSocketDataListener());
            }
            this.notifyListeners(WebSocketEvent.SCOPE_CREATED, wsScope, null);
            this.addWebSocketScope(wsScope);
        }
    }

    public void removeApplication(IScope scope) {
        this.activeRooms.remove(scope.getName());
    }

    public boolean addWebSocketScope(WebSocketScope webSocketScope) {
        String path = webSocketScope.getPath();
        if (this.scopes.putIfAbsent(path, webSocketScope) == null) {
            log.info("addWebSocketScope: {}", (Object)webSocketScope);
            this.notifyListeners(WebSocketEvent.SCOPE_ADDED, webSocketScope, null);
            if (this.pingFuture == null || this.pingFuture.isDone()) {
                String appScopeName = this.appScope != null ? this.appScope.getName() : "default";
                this.pingFuture = this.executor.submit(() -> {
                    String oldName = Thread.currentThread().getName();
                    Thread.currentThread().setName(String.format("WebSocketPinger@%s", appScopeName));
                    do {
                        this.scopes.forEach((sName, wsScope) -> {
                            log.trace("start pinging scope: {}", sName);
                            wsScope.getConns().forEach(wsConn -> {
                                try {
                                    if (wsConn.isConnected()) {
                                        log.debug("pinging ws: {} on scope: {}", (Object)wsConn.getWsSessionId(), sName);
                                        try {
                                            wsConn.sendPing(PING_BYTES);
                                        }
                                        catch (Exception e) {
                                            log.debug("Exception pinging connection: {} connection will be closed", (Object)wsConn.getSessionId(), (Object)e);
                                            wsScope.removeConnection((WebSocketConnection)wsConn);
                                            wsConn.close();
                                        }
                                    } else {
                                        log.debug("Removing unconnected connection: {} during ping loop", (Object)wsConn.getSessionId());
                                        wsScope.removeConnection((WebSocketConnection)wsConn);
                                    }
                                }
                                catch (Exception e) {
                                    log.warn("Exception in WS pinger", e);
                                }
                            });
                            log.trace("finished pinging scope: {}", sName);
                        });
                        try {
                            Thread.sleep(websocketPingInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!this.scopes.isEmpty());
                    this.pingFuture = null;
                    Thread.currentThread().setName(oldName);
                });
            }
            return true;
        }
        return false;
    }

    public boolean removeWebSocketScope(WebSocketScope webSocketScope) {
        log.info("removeWebSocketScope: {}", (Object)webSocketScope);
        WebSocketScope wsScope = (WebSocketScope)this.scopes.remove(webSocketScope.getPath());
        if (wsScope != null) {
            this.notifyListeners(WebSocketEvent.SCOPE_REMOVED, wsScope, null);
            return true;
        }
        return false;
    }

    public void addConnection(WebSocketConnection conn) {
        WebSocketScope scope = this.getScope(conn);
        if (scope != null) {
            scope.addConnection(conn);
            this.notifyListeners(WebSocketEvent.CONNECTION_ADDED, scope, conn);
            if (this.pingFuture == null) {
                log.debug("Pinger is absent for {}", (Object)this.appScope);
            }
        }
    }

    public void removeConnection(WebSocketConnection conn) {
        WebSocketScope scope;
        if (conn != null && (scope = this.getScope(conn)) != null) {
            scope.removeConnection(conn);
            this.notifyListeners(WebSocketEvent.CONNECTION_REMOVED, scope, conn);
            if (!scope.isValid()) {
                this.removeWebSocketScope(scope);
            }
        }
    }

    public void addListener(IWebSocketDataListener listener, String path) {
        log.trace("addListener: {}", (Object)listener);
        WebSocketScope scope = this.getScope(path);
        if (scope != null) {
            scope.addListener(listener);
        } else {
            log.info("Scope not found for path: {}", (Object)path);
        }
    }

    public void removeListener(IWebSocketDataListener listener, String path) {
        log.trace("removeListener: {}", (Object)listener);
        WebSocketScope scope = this.getScope(path);
        if (scope != null) {
            scope.removeListener(listener);
            if (!scope.isValid()) {
                this.removeWebSocketScope(scope);
            }
        } else {
            log.info("Scope not found for path: {}", (Object)path);
        }
    }

    public void makeScope(String path) {
        log.debug("makeScope: {}", (Object)path);
        WebSocketScope wsScope = null;
        if (!this.scopes.containsKey(path)) {
            wsScope = new WebSocketScope();
            wsScope.setPath(path);
            this.notifyListeners(WebSocketEvent.SCOPE_CREATED, wsScope, null);
            this.addWebSocketScope(wsScope);
            log.debug("Use the IWebSocketScopeListener interface to be notified of new scopes");
        } else {
            log.debug("Scope already exists: {}", (Object)path);
        }
    }

    public void makeScope(IScope scope) {
        log.debug("makeScope: {}", (Object)scope);
        String path = scope.getContextPath();
        WebSocketScope wsScope = null;
        if (!this.scopes.containsKey(path)) {
            this.activeRooms.add(scope.getName());
            wsScope = new WebSocketScope();
            wsScope.setPath(path);
            wsScope.setScope(scope);
            this.notifyListeners(WebSocketEvent.SCOPE_CREATED, wsScope, null);
            this.addWebSocketScope(wsScope);
            log.debug("Use the IWebSocketScopeListener interface to be notified of new scopes");
        } else {
            log.debug("Scope already exists: {}", (Object)path);
        }
    }

    public WebSocketScope getScope(String path) {
        log.debug("getScope: {}", (Object)path);
        WebSocketScope scope = (WebSocketScope)this.scopes.get(path);
        if (scope == null) {
            scope = (WebSocketScope)this.scopes.get("default");
        }
        log.debug("Returning: {}", (Object)scope);
        return scope;
    }

    private void notifyListeners(WebSocketEvent event, WebSocketScope wsScope, WebSocketConnection wsConn) {
        this.executor.execute(() -> this.scopeListeners.forEach(listener -> {
            switch (event) {
                case SCOPE_CREATED: {
                    listener.scopeCreated(wsScope);
                    break;
                }
                case SCOPE_ADDED: {
                    listener.scopeAdded(wsScope);
                    break;
                }
                case SCOPE_REMOVED: {
                    listener.scopeRemoved(wsScope);
                    break;
                }
                case CONNECTION_ADDED: {
                    listener.connectionAdded(wsScope, wsConn);
                    break;
                }
                case CONNECTION_REMOVED: {
                    listener.connectionRemoved(wsScope, wsConn);
                }
            }
        }));
    }

    private WebSocketScope getScope(WebSocketConnection conn) {
        if (log.isTraceEnabled()) {
            log.trace("Scopes: {}", (Object)this.scopes);
        }
        log.debug("getScope: {}", (Object)conn);
        String path = conn.getPath();
        if (!this.scopes.containsKey(path)) {
            if (!this.scopes.containsKey("default")) {
                WebSocketScope defaultWSScope = new WebSocketScope();
                defaultWSScope.setPath(path);
                this.notifyListeners(WebSocketEvent.SCOPE_CREATED, defaultWSScope, null);
                this.addWebSocketScope(defaultWSScope);
            } else {
                path = "default";
            }
        }
        WebSocketScope wsScope = Optional.ofNullable(conn.getScope()).orElse((WebSocketScope)this.scopes.get(path));
        log.debug("Returning: {}", (Object)wsScope);
        return wsScope;
    }

    public void stop() {
        if (this.pingFuture != null && !this.pingFuture.isCancelled()) {
            this.pingFuture.cancel(true);
        }
        for (WebSocketScope scope : this.scopes.values()) {
            scope.unregister();
        }
    }

    public boolean setApplication(IScope appScope) {
        log.debug("Application scope: {}", (Object)appScope);
        this.appScope = appScope;
        return this.activeRooms.add(appScope.getName());
    }

    public void setCopyListeners(boolean copy) {
        this.copyListeners = copy;
    }

    public static void setWebsocketPingInterval(long websocketPingInterval) {
        WebSocketScopeManager.websocketPingInterval = websocketPingInterval;
    }

    public String toString() {
        return String.format("App scope: %s%nActive rooms: %s%nWS scopes: %s%nWS listeners: %s%n", this.appScope, this.activeRooms, this.scopes, this.scopeListeners);
    }
}

