/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scope;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeResolver;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.exception.ScopeException;
import org.red5.server.exception.ScopeNotFoundException;
import org.red5.server.exception.ScopeShuttingDownException;
import org.red5.server.scope.WebScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeResolver
implements IScopeResolver {
    protected static Logger log = LoggerFactory.getLogger(ScopeResolver.class);
    protected IGlobalScope globalScope;

    @Override
    public IGlobalScope getGlobalScope() {
        return this.globalScope;
    }

    public void setGlobalScope(IGlobalScope root) {
        this.globalScope = root;
    }

    @Override
    public IScope resolveScope(String path) {
        return this.resolveScope(this.globalScope, path);
    }

    @Override
    public IScope resolveScope(IScope root, String path) {
        log.debug("resolveScope - root: {} path: {}", (Object)root, (Object)path);
        if (root == null) {
            throw new ScopeException("Null root scope");
        }
        IScope scope = root;
        if (StringUtils.isNotEmpty(path)) {
            Object[] parts = path.split("/");
            log.debug("Split path: {}", (Object)Arrays.toString(parts));
            for (Object child : parts) {
                if (StringUtils.isEmpty((CharSequence)child)) continue;
                if (!scope.hasChildScope((String)child) && !scope.equals(root)) {
                    scope.createChildScope((String)child);
                }
                if ((scope = scope.getScope((String)child)) == null) {
                    throw new ScopeNotFoundException(scope, (String)child);
                }
                if (!(scope instanceof IScope) || !scope.getType().equals((Object)ScopeType.APPLICATION) || !((WebScope)scope).isShuttingDown()) continue;
                throw new ScopeShuttingDownException(scope);
            }
        }
        return scope;
    }
}

