/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.ContextLoader;
import org.red5.server.LoaderBase;
import org.red5.server.plugin.PluginRegistry;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class ShutdownServer
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private Logger log = Red5LoggerFactory.getLogger(ShutdownServer.class);
    private int port = 9999;
    private int shutdownDelay = 30;
    private String shutdownTokenFileName = "shutdown.token";
    private ApplicationContext applicationContext;
    private ApplicationContext coreContext;
    private ApplicationContext commonContext;
    private ContextLoader contextLoader;
    private final String token = UUID.randomUUID().toString();
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future<?> future;
    private LoaderBase jeeServer;

    @Override
    public void afterPropertiesSet() throws Exception {
        try {
            this.jeeServer = this.applicationContext.getBean(LoaderBase.class);
            if (this.jeeServer == null) {
                this.log.info("JEE server was not found");
            } else {
                this.log.info("JEE server was found: {}", (Object)this.jeeServer.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ShutdownServer.this.start();
            }
        });
    }

    @Override
    public void destroy() throws Exception {
        this.shutdownOrderly();
        this.future.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.log.info("Shutdown server start");
        System.out.printf("Token: %s%n", this.token);
        try {
            Files.deleteIfExists(Paths.get(this.shutdownTokenFileName, new String[0]));
            Path path = Files.createFile(Paths.get(this.shutdownTokenFileName, new String[0]), new FileAttribute[0]);
            File tokenFile = path.toFile();
            RandomAccessFile raf = new RandomAccessFile(tokenFile, "rws");
            raf.write(this.token.getBytes());
            raf.close();
        }
        catch (Exception e) {
            this.log.warn("Exception handling token file", e);
        }
        InetAddress loopbackAddr = InetAddress.getLoopbackAddress();
        String localAddr = loopbackAddr.getHostAddress();
        int pos = localAddr.indexOf(47);
        String localIPAddr = pos >= 0 ? localAddr.substring(pos) : localAddr;
        this.log.info("Starting socket server on {}:{}", (Object)localIPAddr, (Object)this.port);
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port, 8, loopbackAddr);
            while (!this.shutdown.get()) {
                try {
                    Socket clientSocket = serverSocket.accept();
                    PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                    BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    this.log.info("Connected - local: {} remote: {}", (Object)clientSocket.getLocalSocketAddress(), (Object)clientSocket.getRemoteSocketAddress());
                    String remoteAddr = clientSocket.getRemoteSocketAddress().toString();
                    String remoteIPAddr = remoteAddr.substring(1, remoteAddr.indexOf(58));
                    this.log.info("IP addresses - local: {} remote: {}", (Object)localIPAddr, (Object)remoteIPAddr);
                    if (localIPAddr.equals(remoteIPAddr)) {
                        String inputLine = in.readLine();
                        if (inputLine != null && this.token.equals(inputLine)) {
                            this.log.info("Shutdown request validated using token");
                            out.println("Ok");
                            this.shutdownOrderly();
                        } else {
                            out.println("Invalid input");
                        }
                    } else {
                        out.println("Invalid requester");
                    }
                    clientSocket.close();
                }
                catch (Throwable t) {
                    this.log.warn("Exception caught when trying to listen on port {} or listening for a connection", (Object)this.port, (Object)t);
                }
            }
        }
        catch (Exception be) {
            this.log.error("Cannot bind to port: {}, ensure no other instances are bound or choose another port", (Object)this.port, (Object)be);
            this.shutdownOrderly();
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException ioe) {
                    this.log.warn("IOException at close", ioe);
                }
            }
        }
    }

    private void shutdownOrderly() {
        this.shutdown.compareAndSet(false, true);
        try {
            this.log.debug("Attempting to shutdown plugin registry");
            PluginRegistry.shutdown();
        }
        catch (Exception e) {
            this.log.warn("Exception shutting down plugin registry", e);
        }
        if (this.contextLoader != null) {
            this.log.debug("Attempting to shutdown context loader");
            this.contextLoader.shutdown();
            this.contextLoader = null;
        }
        if (this.jeeServer != null) {
            this.jeeServer = null;
        }
        final CountDownLatch latch = new CountDownLatch(3);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ShutdownServer.this.log.debug("Attempting to close core context");
                    ((ConfigurableApplicationContext)ShutdownServer.this.coreContext).close();
                    latch.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ShutdownServer.this.log.debug("Attempting to close common context");
                    ((ConfigurableApplicationContext)ShutdownServer.this.commonContext).close();
                    latch.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ShutdownServer.this.log.debug("Attempting to close app context");
                    ((ConfigurableApplicationContext)ShutdownServer.this.applicationContext).close();
                    latch.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        try {
            if (latch.await(this.shutdownDelay, TimeUnit.SECONDS)) {
                this.log.info("Application contexts are closed");
            } else {
                this.log.info("One or more contexts didn't close in the allotted time");
            }
        }
        catch (InterruptedException e) {
            this.log.error("Exception attempting to close app contexts", e);
        }
        System.exit(0);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setShutdownDelay(int shutdownDelay) {
        this.shutdownDelay = shutdownDelay;
    }

    public void setShutdownTokenFileName(String shutdownTokenFileName) {
        this.shutdownTokenFileName = shutdownTokenFileName;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setCoreContext(ApplicationContext coreContext) {
        this.coreContext = coreContext;
    }

    public void setCommonContext(ApplicationContext commonContext) {
        this.commonContext = commonContext;
    }

    public void setContextLoader(ContextLoader contextLoader) {
        this.contextLoader = contextLoader;
    }
}

