/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.m4a.impl;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.mina.core.buffer.IoBuffer;
import org.mp4parser.Container;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.apple.AppleWaveBox;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.AudioSpecificConfig;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderConfigDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderSpecificInfo;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ESDescriptor;
import org.mp4parser.boxes.iso14496.part12.AbstractMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.ChunkOffset64BitBox;
import org.mp4parser.boxes.iso14496.part12.ChunkOffsetBox;
import org.mp4parser.boxes.iso14496.part12.HandlerBox;
import org.mp4parser.boxes.iso14496.part12.MediaBox;
import org.mp4parser.boxes.iso14496.part12.MediaDataBox;
import org.mp4parser.boxes.iso14496.part12.MediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MediaInformationBox;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.boxes.iso14496.part12.MovieHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SampleSizeBox;
import org.mp4parser.boxes.iso14496.part12.SampleTableBox;
import org.mp4parser.boxes.iso14496.part12.SampleToChunkBox;
import org.mp4parser.boxes.iso14496.part12.SoundMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.TimeToSampleBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.iso14496.part12.TrackHeaderBox;
import org.mp4parser.boxes.iso14496.part14.ESDescriptorBox;
import org.mp4parser.boxes.sampleentry.AbstractSampleEntry;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.IoConstants;
import org.red5.io.amf.Output;
import org.red5.io.flv.impl.Tag;
import org.red5.io.mp4.MP4Frame;
import org.red5.io.mp4.impl.MP4Reader;
import org.red5.io.utils.HexDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M4AReader
implements IoConstants,
ITagReader {
    private static Logger log = LoggerFactory.getLogger(M4AReader.class);
    private SeekableByteChannel dataSource;
    private IsoFile isoFile;
    private String audioCodecId = "mp4a";
    private byte[] audioDecoderBytes;
    private long duration;
    private long timeScale;
    private double audioTimeScale;
    private int audioChannels;
    private int audioCodecType = 1;
    private String formattedDuration;
    private List<SampleToChunkBox.Entry> audioSamplesToChunks;
    private long[] audioSamples;
    private long audioSampleSize;
    private long[] audioChunkOffsets;
    private long audioSampleDuration = 1024L;
    private int currentFrame = 1;
    private int prevFrameSize = 0;
    private List<MP4Frame> frames = new ArrayList<MP4Frame>();
    private LinkedList<ITag> firstTags = new LinkedList();
    private final Semaphore lock = new Semaphore(1, true);

    M4AReader() {
    }

    public M4AReader(File f) throws IOException {
        String fileName;
        if (null == f) {
            log.warn("Reader was passed a null file");
            log.debug("{}", (Object)ToStringBuilder.reflectionToString((Object)this));
        }
        if ((fileName = f.getName()).endsWith("m4a") || fileName.endsWith("mp4")) {
            this.dataSource = Files.newByteChannel(Paths.get(f.toURI()), new OpenOption[0]);
            this.isoFile = new IsoFile((ReadableByteChannel)this.dataSource);
            this.decodeHeader();
            this.analyzeFrames();
            this.firstTags.add(this.createFileMeta());
            this.createPreStreamingTags();
        } else {
            log.info("Unsupported file extension: {}", (Object)fileName);
        }
    }

    @Override
    public void decodeHeader() {
        try {
            MovieBox moov = (MovieBox)this.isoFile.getBoxes(MovieBox.class).get(0);
            if (log.isDebugEnabled()) {
                log.debug("moov children: {}", (Object)moov.getBoxes().size());
                MP4Reader.dumpBox((Container)moov);
            }
            MovieHeaderBox mvhd = moov.getMovieHeaderBox();
            this.timeScale = mvhd.getTimescale();
            this.duration = mvhd.getDuration();
            log.debug("Time scale {} Duration {}", (Object)this.timeScale, (Object)this.duration);
            double lengthInSeconds = (double)this.duration / (double)this.timeScale;
            log.debug("Seconds {}", (Object)lengthInSeconds);
            log.debug("Tracks: {}", (Object)moov.getTrackCount());
            List tracks = moov.getBoxes(TrackBox.class);
            for (TrackBox trak : tracks) {
                SampleDescriptionBox stsd;
                SampleTableBox stbl;
                if (log.isDebugEnabled()) {
                    log.debug("trak children: {}", (Object)trak.getBoxes().size());
                    MP4Reader.dumpBox((Container)trak);
                }
                TrackHeaderBox tkhd = trak.getTrackHeaderBox();
                log.debug("Track id: {}", (Object)tkhd.getTrackId());
                MediaBox mdia = trak.getMediaBox();
                long scale = 0L;
                if (mdia != null) {
                    MediaInformationBox minf;
                    HandlerBox hdlr;
                    MediaHeaderBox mdhd;
                    if (log.isDebugEnabled()) {
                        log.debug("mdia children: {}", (Object)mdia.getBoxes().size());
                        MP4Reader.dumpBox((Container)mdia);
                    }
                    if ((mdhd = mdia.getMediaHeaderBox()) != null) {
                        log.debug("Media data header atom found");
                        scale = mdhd.getTimescale();
                        log.debug("Time scale {}", (Object)scale);
                    }
                    if ((hdlr = mdia.getHandlerBox()) != null) {
                        String hdlrType = hdlr.getHandlerType();
                        if ("soun".equals(hdlrType)) {
                            if (scale > 0L) {
                                this.audioTimeScale = (double)scale * 1.0;
                                log.debug("Audio time scale: {}", (Object)this.audioTimeScale);
                            }
                        } else {
                            log.debug("Unhandled handler type: {}", (Object)hdlrType);
                        }
                    }
                    if ((minf = mdia.getMediaInformationBox()) != null) {
                        AbstractMediaHeaderBox abs;
                        if (log.isDebugEnabled()) {
                            log.debug("minf children: {}", (Object)minf.getBoxes().size());
                            MP4Reader.dumpBox((Container)minf);
                        }
                        if ((abs = minf.getMediaHeaderBox()) instanceof SoundMediaHeaderBox) {
                            log.debug("Sound header atom found");
                        } else {
                            log.debug("Unhandled media header box: {}", (Object)abs.getType());
                        }
                    }
                }
                if ((stbl = trak.getSampleTableBox()) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("stbl children: {}", (Object)stbl.getBoxes().size());
                    MP4Reader.dumpBox((Container)stbl);
                }
                if ((stsd = stbl.getSampleDescriptionBox()) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("stsd children: {}", (Object)stsd.getBoxes().size());
                    MP4Reader.dumpBox((Container)stsd);
                }
                AbstractSampleEntry entry = stsd.getSampleEntry();
                log.debug("Sample entry type: {}", (Object)entry.getType());
                if (!(entry instanceof AudioSampleEntry)) continue;
                this.processAudioBox(stbl, (AudioSampleEntry)entry, scale);
            }
            StringBuilder sb = new StringBuilder();
            double videoTime = (double)this.duration / (double)this.timeScale;
            log.debug("Video time: {}", (Object)videoTime);
            int minutes = (int)(videoTime / 60.0);
            if (minutes > 0) {
                sb.append(minutes);
                sb.append('.');
            }
            NumberFormat df = DecimalFormat.getInstance();
            df.setMaximumFractionDigits(2);
            sb.append(df.format(videoTime % 60.0));
            this.formattedDuration = sb.toString();
            log.debug("Time: {}", (Object)this.formattedDuration);
            List mdats = this.isoFile.getBoxes(MediaDataBox.class);
            if (mdats != null && !mdats.isEmpty()) {
                log.debug("mdat count: {}", (Object)mdats.size());
            }
        }
        catch (Exception e) {
            log.error("Exception decoding header / atoms", (Throwable)e);
        }
    }

    private void processAudioBox(SampleTableBox stbl, AudioSampleEntry ase, long scale) {
        SampleDependencyTypeBox sdtp;
        ChunkOffsetBox stco;
        SampleSizeBox stsz;
        String codecName = ase.getType();
        this.setAudioCodecId(codecName);
        log.debug("Sample size: {}", (Object)ase.getSampleSize());
        long ats = ase.getSampleRate();
        if (ats > 0L) {
            this.audioTimeScale = (double)ats * 1.0;
        }
        log.debug("Sample rate (audio time scale): {}", (Object)this.audioTimeScale);
        this.audioChannels = ase.getChannelCount();
        log.debug("Channels: {}", (Object)this.audioChannels);
        if (ase.getBoxes(ESDescriptorBox.class).size() > 0) {
            ESDescriptorBox esds = (ESDescriptorBox)ase.getBoxes(ESDescriptorBox.class).get(0);
            if (esds == null) {
                log.debug("esds not found in default path");
                AppleWaveBox wave = (AppleWaveBox)ase.getBoxes(AppleWaveBox.class).get(0);
                if (wave != null) {
                    log.debug("wave atom found");
                    esds = (ESDescriptorBox)wave.getBoxes(ESDescriptorBox.class).get(0);
                    if (esds == null) {
                        log.debug("esds not found in wave");
                    }
                }
            }
            if (esds != null) {
                ESDescriptor descriptor = esds.getEsDescriptor();
                if (descriptor != null) {
                    DecoderConfigDescriptor configDescriptor = descriptor.getDecoderConfigDescriptor();
                    AudioSpecificConfig audioInfo = configDescriptor.getAudioSpecificInfo();
                    if (audioInfo != null) {
                        this.audioDecoderBytes = audioInfo.getConfigBytes();
                        byte audioCoderType = this.audioDecoderBytes[0];
                        switch (audioCoderType) {
                            case 2: {
                                log.debug("Audio type AAC LC");
                            }
                            case 17: {
                                log.debug("Audio type ER AAC LC");
                            }
                            default: {
                                this.audioCodecType = 1;
                                break;
                            }
                            case 1: {
                                log.debug("Audio type AAC Main");
                                this.audioCodecType = 0;
                                break;
                            }
                            case 3: {
                                log.debug("Audio type AAC SBR");
                                this.audioCodecType = 2;
                                break;
                            }
                            case 5: 
                            case 29: {
                                log.debug("Audio type AAC HE");
                                this.audioCodecType = 3;
                                break;
                            }
                            case 32: 
                            case 33: 
                            case 34: {
                                log.debug("Audio type MP3");
                                this.audioCodecType = 33;
                                this.audioCodecId = "mp3";
                            }
                        }
                        log.debug("Audio coder type: {} {} id: {}", new Object[]{audioCoderType, Integer.toBinaryString(audioCoderType), this.audioCodecId});
                    } else {
                        log.debug("Audio specific config was not found");
                        DecoderSpecificInfo info = configDescriptor.getDecoderSpecificInfo();
                        if (info != null) {
                            log.debug("Decoder info found: {}", (Object)info.getTag());
                        }
                    }
                } else {
                    log.debug("No ES descriptor found");
                }
            }
        } else {
            log.debug("Audio sample entry had no descriptor");
        }
        SampleToChunkBox stsc = stbl.getSampleToChunkBox();
        if (stsc != null) {
            log.debug("Sample to chunk atom found");
            this.audioSamplesToChunks = stsc.getEntries();
            log.debug("Audio samples to chunks: {}", (Object)this.audioSamplesToChunks.size());
        }
        if ((stsz = stbl.getSampleSizeBox()) != null) {
            log.debug("Sample size atom found");
            this.audioSamples = stsz.getSampleSizes();
            log.debug("Samples: {}", (Object)this.audioSamples.length);
            this.audioSampleSize = stsz.getSampleSize();
            log.debug("Sample size: {}", (Object)this.audioSampleSize);
            long audioSampleCount = stsz.getSampleCount();
            log.debug("Sample count: {}", (Object)audioSampleCount);
        }
        if ((stco = stbl.getChunkOffsetBox()) != null) {
            log.debug("Chunk offset atom found");
            this.audioChunkOffsets = stco.getChunkOffsets();
            log.debug("Chunk count: {}", (Object)this.audioChunkOffsets.length);
        } else {
            ChunkOffset64BitBox co64 = (ChunkOffset64BitBox)stbl.getBoxes(ChunkOffset64BitBox.class).get(0);
            if (co64 != null) {
                log.debug("Chunk offset (64) atom found");
                this.audioChunkOffsets = co64.getChunkOffsets();
                log.debug("Chunk count: {}", (Object)this.audioChunkOffsets.length);
            }
        }
        TimeToSampleBox stts = stbl.getTimeToSampleBox();
        if (stts != null) {
            log.debug("Time to sample atom found");
            List records = stts.getEntries();
            log.debug("Audio time to samples: {}", (Object)records.size());
            if (records.size() > 0) {
                TimeToSampleBox.Entry rec = (TimeToSampleBox.Entry)records.get(0);
                log.debug("Samples = {} delta = {}", (Object)rec.getCount(), (Object)rec.getDelta());
                this.audioSampleDuration = rec.getDelta();
            }
        }
        if ((sdtp = stbl.getSampleDependencyTypeBox()) != null) {
            log.debug("Independent and disposable samples atom found");
            List recs = sdtp.getEntries();
            for (SampleDependencyTypeBox.Entry rec : recs) {
                log.debug("{}", (Object)rec);
            }
        }
    }

    @Override
    public long getTotalBytes() {
        try {
            return this.dataSource.size();
        }
        catch (Exception e) {
            log.error("Error getTotalBytes", (Throwable)e);
            return 0L;
        }
    }

    private long getCurrentPosition() {
        try {
            return this.dataSource.position();
        }
        catch (Exception e) {
            log.error("Error getCurrentPosition", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public boolean hasVideo() {
        return false;
    }

    public IoBuffer getFileData() {
        return null;
    }

    @Override
    public IStreamableFile getFile() {
        return null;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public long getBytesRead() {
        return this.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public String getAudioCodecId() {
        return this.audioCodecId;
    }

    @Override
    public boolean hasMoreTags() {
        return this.currentFrame < this.frames.size();
    }

    ITag createFileMeta() {
        log.debug("Creating onMetaData");
        IoBuffer buf = IoBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        props.put("duration", (double)this.duration / (double)this.timeScale);
        props.put("audiocodecid", this.audioCodecId);
        props.put("aacaot", this.audioCodecType);
        props.put("audiosamplerate", this.audioTimeScale);
        props.put("audiochannels", this.audioChannels);
        props.put("canSeekToEnd", false);
        out.writeMap(props);
        buf.flip();
        this.duration = Math.round((double)this.duration * 1000.0);
        Tag result = new Tag(18, 0, buf.limit(), null, 0);
        result.setBody(buf);
        return result;
    }

    private void createPreStreamingTags() {
        log.debug("Creating pre-streaming tags");
        if (this.audioDecoderBytes != null) {
            IoBuffer body = IoBuffer.allocate((int)(this.audioDecoderBytes.length + 3));
            body.put(new byte[]{-81, 0});
            if (log.isDebugEnabled()) {
                log.debug("Audio decoder bytes: {}", (Object)HexDump.byteArrayToHexString(this.audioDecoderBytes));
            }
            body.put(this.audioDecoderBytes);
            body.put((byte)6);
            Tag tag = new Tag(8, 0, body.position(), null, this.prevFrameSize);
            body.flip();
            tag.setBody(body);
            this.firstTags.add(tag);
        } else {
            log.warn("Audio decoder bytes were not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITag readTag() {
        Tag tag = null;
        try {
            this.lock.acquire();
            if (!this.firstTags.isEmpty()) {
                log.debug("Returning pre-tag");
                ITag iTag = this.firstTags.removeFirst();
                return iTag;
            }
            MP4Frame frame = this.frames.get(this.currentFrame);
            log.debug("Playback {}", (Object)frame);
            int sampleSize = frame.getSize();
            int time = (int)Math.round(frame.getTime() * 1000.0);
            long samplePos = frame.getOffset();
            byte type = frame.getType();
            ByteBuffer data = ByteBuffer.allocate(sampleSize + 2);
            try {
                data.put(MP4Reader.PREFIX_AUDIO_FRAME);
                this.dataSource.position(samplePos);
                this.dataSource.read(data);
            }
            catch (IOException e) {
                log.error("Error on channel position / read", (Throwable)e);
            }
            IoBuffer payload = IoBuffer.wrap((byte[])data.array());
            tag = new Tag(type, time, payload.limit(), payload, this.prevFrameSize);
            ++this.currentFrame;
            this.prevFrameSize = tag.getBodySize();
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
        }
        finally {
            this.lock.release();
        }
        return tag;
    }

    public void analyzeFrames() {
        log.debug("Analyzing frames");
        if (this.audioSamplesToChunks != null) {
            int sample = 1;
            Long pos = null;
            for (int i = 0; i < this.audioSamplesToChunks.size(); ++i) {
                SampleToChunkBox.Entry record = this.audioSamplesToChunks.get(i);
                long firstChunk = record.getFirstChunk();
                long lastChunk = this.audioChunkOffsets.length;
                if (i < this.audioSamplesToChunks.size() - 1) {
                    SampleToChunkBox.Entry nextRecord = this.audioSamplesToChunks.get(i + 1);
                    lastChunk = nextRecord.getFirstChunk() - 1L;
                }
                for (long chunk = firstChunk; chunk <= lastChunk; ++chunk) {
                    long sampleCount = record.getSamplesPerChunk();
                    pos = this.audioChunkOffsets[(int)(chunk - 1L)];
                    while (sampleCount > 0L) {
                        double ts = (double)(this.audioSampleDuration * (long)(sample - 1)) / this.audioTimeScale;
                        int size = 0;
                        if (this.audioSamples.length > 0) {
                            size = (int)this.audioSamples[sample - 1];
                            log.trace("Audio sample - size: {} pos: {}", (Object)size, (Object)pos);
                            if (size == 6) {
                                try {
                                    long position = this.dataSource.position();
                                    this.dataSource.position(pos);
                                    ByteBuffer dst = ByteBuffer.allocate(6);
                                    this.dataSource.read(dst);
                                    dst.flip();
                                    this.dataSource.position(position);
                                    byte[] tmp = dst.array();
                                    log.trace("Audio bytes: {} equal: {}", (Object)HexDump.byteArrayToHexString(tmp), (Object)Arrays.equals(MP4Reader.EMPTY_AAC, tmp));
                                    if (Arrays.equals(MP4Reader.EMPTY_AAC, tmp)) {
                                        log.trace("Skipping empty AAC data frame");
                                        pos = pos + (long)size;
                                        --sampleCount;
                                        ++sample;
                                        continue;
                                    }
                                }
                                catch (IOException e) {
                                    log.warn("Exception during audio analysis", (Throwable)e);
                                }
                            }
                        }
                        size = (int)(size != 0 ? (long)size : this.audioSampleSize);
                        MP4Frame frame = new MP4Frame();
                        frame.setOffset(pos);
                        frame.setSize(size);
                        frame.setTime(ts);
                        frame.setType((byte)8);
                        this.frames.add(frame);
                        pos = pos + (long)size;
                        --sampleCount;
                        ++sample;
                    }
                }
            }
        }
        Collections.sort(this.frames);
        log.debug("Frames count: {}", (Object)this.frames.size());
        if (this.audioSamplesToChunks != null) {
            this.audioChunkOffsets = null;
            this.audioSamplesToChunks.clear();
            this.audioSamplesToChunks = null;
        }
    }

    @Override
    public void position(long pos) {
        log.debug("position: {}", (Object)pos);
        this.currentFrame = this.getFrame(pos);
        log.debug("Setting current sample: {}", (Object)this.currentFrame);
    }

    private int getFrame(long pos) {
        int sample = 1;
        int len = this.frames.size();
        MP4Frame frame = null;
        for (int f = 0; f < len; ++f) {
            frame = this.frames.get(f);
            if (pos != frame.getOffset()) continue;
            sample = f;
            break;
        }
        return sample;
    }

    @Override
    public void close() {
        log.debug("Close");
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (IOException e) {
                log.error("Channel close {}", (Throwable)e);
            }
            finally {
                if (this.frames != null) {
                    this.frames.clear();
                    this.frames = null;
                }
            }
        }
    }

    public void setAudioCodecId(String audioCodecId) {
        this.audioCodecId = audioCodecId;
    }

    public ITag readTagHeader() {
        return null;
    }
}

